/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.utils.URIException;
import java.io.File;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class URI {
    protected String reference_ = null;
    protected String query_ = null;
    protected String path_ = null;
    protected String authority_ = null;
    protected String scheme_ = null;
    protected static String ADDITIONAL_REFERENCE_CHARS_ = "";
    protected static final String REFERENCE_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,";
    protected static final String QUERY_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,";
    protected static final String PATH_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/:@&=+$,";
    protected static final String AUTHORITY_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();:@&=+$,";
    protected static final String SCHEME_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'()+-.";
    protected static final String RESERVED_ = ";/?:@&=+$,";
    protected static final String UNRESERVED_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'()";

    protected String unescape(String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'escpaed' can not be null");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 != '%') {
                stringBuffer.append(c2);
            } else {
                int n2;
                int[] nArray = new int[3];
                nArray[0] = Integer.parseInt(string.substring(n + 1, n + 3), 16);
                if ((nArray[0] & 0xE0) == 224) {
                    nArray[1] = Integer.parseInt(string.substring(n + 4, n + 6), 16);
                    nArray[2] = Integer.parseInt(string.substring(n + 7, n + 9), 16);
                    n2 = ((nArray[0] & 0xF) << 12) + ((nArray[1] & 0x3F) << 6) + (nArray[2] & 0x3F);
                    stringBuffer.append((char)n2);
                    n += 8;
                } else if ((nArray[0] & 0xC0) == 192) {
                    nArray[1] = Integer.parseInt(string.substring(n + 4, n + 6), 16);
                    n2 = ((nArray[0] & 0x1F) << 6) + (nArray[1] & 0x3F);
                    stringBuffer.append((char)n2);
                    n += 5;
                } else if ((nArray[0] & 0x80) == 0) {
                    stringBuffer.append((char)nArray[0]);
                    n += 2;
                } else {
                    throw new RuntimeException();
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toUnescapedString() {
        return this.unescape(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme_ != null) {
            stringBuffer.append(String.valueOf(this.scheme_) + ":");
        }
        if (this.authority_ != null) {
            stringBuffer.append("//" + this.authority_);
        }
        if (this.path_ != null) {
            stringBuffer.append(this.path_);
        }
        if (this.query_ != null) {
            stringBuffer.append("?" + this.query_);
        }
        if (this.reference_ != null) {
            stringBuffer.append("#" + this.reference_);
        }
        return stringBuffer.toString();
    }

    public static void setAdditionalFragmentChars(String string) {
        ADDITIONAL_REFERENCE_CHARS_ = string == null ? "" : string;
    }

    private static String remove_dot_segments_c14n11_wrong(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (n + 1 < stringBuffer.length() && stringBuffer.charAt(n) == '/' && stringBuffer.charAt(n + 1) == '/') {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string.length());
        n = 0;
        block1: while (stringBuffer.length() != 0) {
            int n2;
            if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '/') {
                stringBuffer.delete(0, 2);
                continue;
            }
            if (stringBuffer.length() >= 3 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.' && stringBuffer.charAt(2) == '/') {
                stringBuffer.delete(0, 3);
                stringBuffer2.append("../");
                continue;
            }
            if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '.' && (stringBuffer.length() < 3 || stringBuffer.charAt(2) == '/')) {
                stringBuffer.delete(1, stringBuffer.length() < 3 ? 2 : 3);
                continue;
            }
            if (stringBuffer.length() >= 3 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '.' && stringBuffer.charAt(2) == '.' && (stringBuffer.length() < 4 || stringBuffer.charAt(3) == '/')) {
                String string2 = stringBuffer.substring(1, 3);
                stringBuffer.delete(1, stringBuffer.length() < 4 ? 3 : 4);
                n2 = stringBuffer2.length();
                if (n2 >= 3 && (n2 < 4 || stringBuffer2.charAt(n2 - 4) == '/') && stringBuffer2.charAt(n2 - 3) == '.' && stringBuffer2.charAt(n2 - 2) == '.' && stringBuffer2.charAt(n2 - 1) == '/') {
                    System.out.print("prefix1 ");
                    stringBuffer2.append(string2);
                    continue;
                }
                int n3 = n2 - 1;
                if (n3 < 0) continue;
                if (stringBuffer2.charAt(n3) == '/') {
                    --n3;
                }
                while (n3 >= 0) {
                    char c2 = stringBuffer2.charAt(n3);
                    if (c2 == '/') {
                        stringBuffer2.deleteCharAt(n3);
                        continue block1;
                    }
                    stringBuffer2.deleteCharAt(n3);
                    --n3;
                }
                continue;
            }
            if (stringBuffer.length() == 1 && stringBuffer.charAt(0) == '.') {
                stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.length() == 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.') {
                stringBuffer.delete(0, 3);
                if (stringBuffer2.length() == 1 && stringBuffer2.charAt(0) == '/') continue;
                stringBuffer2.append("..");
                continue;
            }
            int n4 = 0;
            while (n4 < stringBuffer.length()) {
                n2 = stringBuffer.charAt(n4);
                if (n4 > 0 && n2 == 47) break;
                stringBuffer2.append((char)n2);
                ++n4;
            }
            stringBuffer.delete(0, n4);
        }
        int n5 = stringBuffer2.length();
        return stringBuffer2.toString();
    }

    private static String remove_dot_segments_c14n11_simple(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (!(n2 - 1 >= 0 && stringBuffer.charAt(n2 - 1) != '/' || stringBuffer.charAt(n2) != '.' || n2 + 1 < stringBuffer.length() && stringBuffer.charAt(n2 + 1) != '/')) {
                if (n2 + 1 >= stringBuffer.length() || stringBuffer.charAt(n2 + 1) != '/') {
                    stringBuffer.deleteCharAt(n2);
                } else {
                    n = n2 + 1;
                    while (n < stringBuffer.length() && stringBuffer.charAt(n) == '/') {
                        ++n;
                    }
                    stringBuffer.delete(n2, n);
                }
                n2 = n2 - 1 < 0 ? 0 : n2 - 1;
                continue;
            }
            if (stringBuffer.charAt(n2) == '/') {
                if (n2 + 1 < stringBuffer.length() && stringBuffer.charAt(n2 + 1) == '/') {
                    stringBuffer.deleteCharAt(n2);
                    continue;
                }
                if (n2 + 2 < stringBuffer.length() && stringBuffer.charAt(n2 + 1) == '.' && stringBuffer.charAt(n2 + 2) == '.' && (n2 + 3 >= stringBuffer.length() || stringBuffer.charAt(n2 + 3) == '/')) {
                    if (n2 - 1 < 0) {
                        stringBuffer.delete(n2 + 1, n2 + 3);
                        continue;
                    }
                    n = n2 - 1;
                    while (n != 0 && stringBuffer.charAt(n) != '/') {
                        --n;
                    }
                    if (n == 0) {
                        if (stringBuffer.charAt(0) == '/') {
                            stringBuffer.delete(1, n2 + 3);
                            n2 = 0;
                            continue;
                        }
                        if (stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.') {
                            n2 += 3;
                            continue;
                        }
                        if (n2 + 3 >= stringBuffer.length()) {
                            stringBuffer.delete(0, n2 + 3);
                            n2 = 0;
                            continue;
                        }
                        int n3 = n2 + 4;
                        while (n3 < stringBuffer.length() && stringBuffer.charAt(n3) == '/') {
                            ++n3;
                        }
                        stringBuffer.delete(0, n3);
                        n2 = 0;
                        continue;
                    }
                    if (stringBuffer.charAt(n2 - 3) == '/' && stringBuffer.charAt(n2 - 2) == '.' && stringBuffer.charAt(n2 - 1) == '.') {
                        n2 += 3;
                        continue;
                    }
                    stringBuffer.delete(n + 1, n2 + 3);
                    n2 = n;
                    continue;
                }
            }
            ++n2;
        }
        n = stringBuffer.length();
        if (n >= 2 && (n < 3 || stringBuffer.charAt(n - 3) == '/') && stringBuffer.charAt(n - 2) == '.' && stringBuffer.charAt(n - 1) == '.') {
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    private static String remove_dot_segments_c14n11(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (n + 1 < stringBuffer.length() && stringBuffer.charAt(n) == '/' && stringBuffer.charAt(n + 1) == '/') {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string.length());
        if (stringBuffer.charAt(0) == '/') {
            stringBuffer.deleteCharAt(0);
            stringBuffer2.append('/');
        }
        n = 0;
        while (stringBuffer.length() != 0) {
            int n2;
            if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '/') {
                stringBuffer.delete(0, 2);
                continue;
            }
            if (stringBuffer.length() >= 3 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.' && stringBuffer.charAt(2) == '/') {
                stringBuffer.delete(0, 3);
                if (stringBuffer2.length() == 1 && stringBuffer2.charAt(0) == '/') continue;
                stringBuffer2.append("../");
                continue;
            }
            if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '.' && (stringBuffer.length() < 3 || stringBuffer.charAt(2) == '/')) {
                stringBuffer.delete(1, stringBuffer.length() < 3 ? 2 : 3);
                continue;
            }
            if (stringBuffer.length() >= 3 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '.' && stringBuffer.charAt(2) == '.' && (stringBuffer.length() < 4 || stringBuffer.charAt(3) == '/')) {
                String string2 = stringBuffer.substring(1, 3);
                stringBuffer.delete(1, stringBuffer.length() < 4 ? 3 : 4);
                n2 = stringBuffer2.length();
                if (n2 == 0 || n2 >= 3 && (n2 < 4 || stringBuffer2.charAt(n2 - 4) == '/') && stringBuffer2.charAt(n2 - 3) == '.' && stringBuffer2.charAt(n2 - 2) == '.' && stringBuffer2.charAt(n2 - 1) == '/') {
                    stringBuffer2.append(string2);
                    continue;
                }
                if (n2 >= 2 && (n2 < 3 || stringBuffer2.charAt(n2 - 3) == '/') && stringBuffer2.charAt(n2 - 2) == '.' && stringBuffer2.charAt(n2 - 1) == '.') {
                    stringBuffer2.append("/" + string2);
                    continue;
                }
                int n3 = n2 - 1;
                if (n3 < 0) continue;
                if (stringBuffer2.charAt(n3) == '/') {
                    --n3;
                }
                while (n3 >= 0) {
                    char c2 = stringBuffer2.charAt(n3);
                    if (c2 == '/') {
                        stringBuffer2.deleteCharAt(n3);
                        break;
                    }
                    stringBuffer2.deleteCharAt(n3);
                    --n3;
                }
                if (n3 >= 0 || stringBuffer.length() < 1 || stringBuffer.charAt(0) != '/') continue;
                stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.length() == 1 && stringBuffer.charAt(0) == '.') {
                stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.length() == 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.') {
                stringBuffer.delete(0, 3);
                if (stringBuffer2.length() == 1 && stringBuffer2.charAt(0) == '/') continue;
                stringBuffer2.append("..");
                continue;
            }
            int n4 = 0;
            while (n4 < stringBuffer.length()) {
                n2 = stringBuffer.charAt(n4);
                if (n4 > 0 && n2 == 47) break;
                stringBuffer2.append((char)n2);
                ++n4;
            }
            stringBuffer.delete(0, n4);
        }
        int n5 = stringBuffer2.length();
        if (n5 >= 2 && (n5 < 3 || stringBuffer2.charAt(n5 - 3) == '/') && stringBuffer2.charAt(n5 - 2) == '.' && stringBuffer2.charAt(n5 - 1) == '.') {
            stringBuffer2.append('/');
        }
        return stringBuffer2.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String parseIPv6(String var0) throws URIException {
        var1_1 = new StringTokenizer(var0, "[.:]", true);
        var2_2 = false;
        var3_3 = 8;
        var4_4 = 0;
        var5_5 = false;
        var6_6 = false;
        var7_7 = var1_1.nextToken();
        if (var7_7.equals("[")) ** GOTO lbl59
        throw new URIException("ipv6 has top start in URI with '[' " + var0);
lbl-1000:
        // 1 sources

        {
            var8_8 = var1_1.nextToken();
            if (var7_7.equals("[") && var8_8.equals(":")) {
                var6_6 = true;
                var7_7 = var8_8;
                continue;
            }
            if (var6_6 && !var8_8.equals(":")) {
                throw new URIException("ipv6 leading single ':' not allowed, has to be \"::\" " + var0);
            }
            var6_6 = false;
            if (var7_7.equals(":") && var8_8.equals(":")) {
                if (var5_5) {
                    throw new URIException("ipv6 only one appearance of \"::\" allowed " + var0);
                }
                var5_5 = true;
                var7_7 = var8_8;
                continue;
            }
            if (var7_7.equals(":") && var8_8.equals(".")) {
                throw new URIException("\":.\" not allowed " + var0);
            }
            if (var7_7.equals(":") && var8_8.equals("]")) {
                if (!var0.endsWith("::]")) {
                    throw new URIException("not allowed ipv6 ending " + var0);
                }
                var7_7 = var8_8;
                continue;
            }
            if (var8_8.equals(":") || var8_8.equals(".") || var8_8.equals("]")) {
                var9_9 = var7_7;
                if (var8_8.equals(".") && var4_4 == 0) {
                    var3_3 -= 2;
                    var4_4 += 4;
                }
                if (var4_4 > 0 && (var8_8.equals(".") || var8_8.equals("]"))) {
                    var10_10 = -1;
                    try {
                        var10_10 = Integer.parseInt(var9_9);
                    }
                    catch (Exception var11_11) {
                        throw new URIException(" ! (0 >= dec-octet > 255) irregular ipv4 ipv6 mixed address" + var0, var11_11);
                    }
                    if (var10_10 <= 0 || var10_10 > 255) {
                        throw new URIException(" ! (0 >= dec-octet > 255) irregular ipv4 ipv6 mixed address" + var0);
                    }
                    --var4_4;
                    var7_7 = var8_8;
                    continue;
                }
                try {
                    var10_10 = Integer.parseInt(var9_9, 16);
                }
                catch (Exception var11_12) {
                    throw new URIException(" irregular ipv6 address" + var0, var11_12);
                }
                if (var9_9.length() > 4) {
                    throw new URIException("irregular ipv6 address" + var0);
                }
                --var3_3;
                var7_7 = var8_8;
                continue;
            }
            var7_7 = var8_8;
lbl59:
            // 7 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl60:
        // 1 sources

        if (!var7_7.equals("]")) {
            throw new URIException("ipv6 has to stop in URI with ']' " + var0);
        }
        if (var4_4 < 0) {
            throw new URIException("irregular ipv4 address part, too many ipv4 bytes " + var0);
        }
        if (var4_4 > 0) {
            throw new URIException("irregular ipv4 address part, 4 ipv4 bytes needed " + var0);
        }
        if (var3_3 < 0) {
            throw new URIException("irregular ipv6 address, too many ipv6 double bytes " + var0);
        }
        if (!var5_5 && var3_3 > 0) {
            throw new URIException("irregular ipv6 address part, more ipv6 double bytes needed " + var0);
        }
        return var0;
    }

    protected String parseComponent(String string, int n, String string2) throws URIException {
        int n2;
        if (string == null) {
            throw new NullPointerException("Argument 'uri' can not be null");
        }
        if (n < 0 || n > string.length()) {
            throw new IllegalArgumentException("Argument 'fromIndex' must me be in [0, uri.legnth()]");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'allowedChars' can not be null");
        }
        if (string2 == AUTHORITY_CHARS_ && n < string.length() && string.charAt(n) == '[' && (n2 = string.indexOf(93, n + 1)) != -1) {
            return URI.parseIPv6(string.substring(n, n2 + 1));
        }
        string2 = String.valueOf(string2) + "%";
        n2 = n;
        while (n2 < string.length() && string2.indexOf(string.charAt(n2)) != -1) {
            ++n2;
        }
        return string.substring(n, n2);
    }

    private String merge(String string) {
        if (this.path_ == null) {
            return string;
        }
        int n = this.path_.lastIndexOf(47);
        int n2 = this.path_.lastIndexOf("..");
        if (string == null || string.length() == 0) {
            return this.path_;
        }
        if (string.startsWith("/")) {
            return string;
        }
        if (n2 + 2 == this.path_.length() && (n == -1 || n + 3 == this.path_.length())) {
            return String.valueOf(this.path_.substring(0, n2 + 2)) + "/" + string;
        }
        return String.valueOf(this.path_.substring(0, n + 1)) + string;
    }

    public URI joinUriReference(URI uRI) {
        String string;
        String string2;
        String string3;
        String string4;
        if (uRI.scheme_ != null && uRI.scheme_.length() != 0) {
            string4 = uRI.scheme_;
            string3 = uRI.authority_;
            string2 = uRI.path_;
            string = uRI.query_;
        } else {
            if (uRI.authority_ != null && uRI.scheme_.length() != 0) {
                string3 = uRI.authority_;
                string2 = URI.remove_dot_segments_c14n11(uRI.path_);
                string = uRI.query_;
            } else {
                if (uRI.path_ == null || uRI.path_.length() == 0) {
                    string2 = this.path_;
                    string = uRI.query_ != null && uRI.query_.length() != 0 ? uRI.query_ : this.query_;
                } else {
                    if (uRI.path_.charAt(0) == '/') {
                        string2 = URI.remove_dot_segments_c14n11(uRI.path_);
                    } else {
                        string2 = this.merge(uRI.path_);
                        string2 = URI.remove_dot_segments_c14n11(string2);
                    }
                    string = uRI.query_;
                }
                string3 = this.authority_;
            }
            string4 = this.scheme_;
        }
        return new URI(string4, string3, string2, string, null);
    }

    public boolean isSameDocument() {
        return this.isReference() || this.isEmpty();
    }

    public boolean isReference() {
        return this.scheme_ == null && this.authority_ == null && "".equals(this.path_) && this.query_ == null && this.reference_ != null;
    }

    public boolean isEmpty() {
        return this.scheme_ == null && this.authority_ == null && "".equals(this.path_) && this.query_ == null && this.reference_ == null;
    }

    public boolean isAbsolute() {
        return this.scheme_ != null;
    }

    public int hashCode() {
        return this.toUnescapedString().toLowerCase().hashCode();
    }

    public String getURIWithoutReference() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme_ != null) {
            stringBuffer.append(String.valueOf(this.scheme_) + ":");
        }
        if (this.authority_ != null) {
            stringBuffer.append("//" + this.authority_);
        }
        if (this.path_ != null) {
            stringBuffer.append(this.path_);
        }
        if (this.query_ != null) {
            stringBuffer.append("?" + this.query_);
        }
        return stringBuffer.toString();
    }

    public String getSchemeUnescaped() {
        return this.scheme_ == null ? null : this.unescape(this.scheme_);
    }

    public String getScheme() {
        return this.scheme_;
    }

    public String getReferenceUnescaped() {
        return this.reference_ == null ? null : this.unescape(this.reference_);
    }

    public String getReference() {
        return this.reference_;
    }

    public String getQueryUnescaped() {
        return this.query_ == null ? null : this.unescape(this.query_);
    }

    public String getQuery() {
        return this.query_;
    }

    public String getPathUnescaped() {
        return this.path_ == null ? null : this.unescape(this.path_);
    }

    public String getPath() {
        return this.path_;
    }

    public String getAuthorityUnescaped() {
        return this.authority_ == null ? null : this.unescape(this.authority_);
    }

    public String getAuthority() {
        return this.authority_;
    }

    protected String escape(String string, String string2) {
        byte[] byArray;
        if (string == null) {
            throw new NullPointerException("Argument 'original' can not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'allowedChars' can not be null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 128 && string2.indexOf((char)n3) != -1) {
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append('%');
                stringBuffer.append(Integer.toHexString(n3));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof URI) {
            URI uRI = (URI)object;
            return this.toUnescapedString().equalsIgnoreCase(uRI.toUnescapedString());
        }
        return this.toString().equalsIgnoreCase(object.toString()) || this.toUnescapedString().equalsIgnoreCase(object.toString());
    }

    public static URI absolutizeURI(URI uRI, URI uRI2) throws URIException {
        if (uRI == null) {
            throw new NullPointerException("Argument 'base' can not be null");
        }
        if (uRI2 == null) {
            throw new NullPointerException("Argument 'candidate' can not be null");
        }
        URI uRI3 = new URI(uRI2.toString());
        boolean bl = false;
        if (uRI2.scheme_ == null && uRI2.authority_ == null && uRI2.path_ == null && uRI2.query_ == null) {
            return new URI(null, null, null, null, uRI3.reference_);
        }
        if (uRI2.scheme_ != null) {
            return uRI3;
        }
        uRI3.scheme_ = uRI.scheme_;
        if (uRI2.authority_ != null) {
            bl = true;
        } else {
            uRI3.authority_ = uRI.authority_;
        }
        if (!bl && uRI2.path_ != null && !uRI2.path_.startsWith("/")) {
            uRI3.path_ = URI.absolutizePath(uRI.path_, uRI2.path_, '/');
        }
        return uRI3;
    }

    public static String absolutizePath(String string, String string2, char c2) throws URIException {
        int n;
        int n2;
        if (string == null) {
            throw new NullPointerException("Argument 'basePath' can not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'candidatePath' can not be null");
        }
        if (new File(string2).isAbsolute()) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.lastIndexOf(c2) + 1;
        if (n3 != -1) {
            stringBuffer.append(string.substring(0, n3));
        }
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        String string4 = "." + new Character(c2).toString();
        int n4 = 0;
        while ((n2 = string3.indexOf(string4, n4)) != -1) {
            if (n2 == 0 || string3.charAt(n2 - 1) != '.') {
                if (n2 != 0 && string3.charAt(n2 - 1) != c2) {
                    throw new URIException("Further canonicalization of path '" + string3 + "' failed.");
                }
                stringBuffer.delete(n2, n2 + string4.length());
                n4 = n2;
                string3 = stringBuffer.toString();
                continue;
            }
            n4 = n2 + string4.length();
        }
        String string5 = "." + string4;
        n4 = 0;
        while ((n2 = string3.indexOf(string5, n4)) != -1) {
            n = n2 + string5.length();
            if (n2 < 2 || string3.charAt(n2 - 1) != c2) {
                throw new URIException("Further canonicalization of path '" + string3 + "' failed.");
            }
            --n2;
            if ((n2 = string3.substring(0, n2).lastIndexOf(c2) + 1) == -1) {
                n2 = 0;
            }
            stringBuffer.delete(n2, n);
            string3 = stringBuffer.toString();
        }
        String string6 = String.valueOf(new Character(c2).toString()) + "..";
        if (string3.endsWith(string6)) {
            n = string3.length();
            n2 = n - string6.length();
            if (n2 == 0) {
                throw new URIException("Further canonicalization of path '" + string3 + "' failed.");
            }
            if ((n2 = string3.substring(0, n2).lastIndexOf(c2)) == -1) {
                n2 = 0;
            }
            stringBuffer.delete(n2, n);
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    public URI(String string, String string2, String string3, String string4, String string5) {
        if (string != null) {
            this.scheme_ = this.escape(string, SCHEME_CHARS_);
        }
        if (string2 != null) {
            this.authority_ = this.escape(string2, AUTHORITY_CHARS_);
        }
        if (string3 != null) {
            this.path_ = this.escape(string3, PATH_CHARS_);
        }
        if (string4 != null) {
            this.query_ = this.escape(string4, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,");
        }
        if (string5 != null) {
            this.reference_ = this.escape(string5, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$," + ADDITIONAL_REFERENCE_CHARS_);
        }
    }

    public URI(String string) throws URIException {
        int n;
        if (string == null) {
            throw new NullPointerException("Argument 'uri' can not be null");
        }
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.2));
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            if (n == 32) {
                stringBuffer.append("%20");
            } else if (n > 31 && n < 127) {
                stringBuffer.append((char)n);
            } else {
                stringBuffer.append(URLEncoder.encode(String.valueOf((char)n)));
            }
            ++n2;
        }
        string = stringBuffer.toString();
        n = 0;
        this.scheme_ = this.parseComponent(string, n, SCHEME_CHARS_);
        n += this.scheme_.length();
        if (this.scheme_.length() == 0) {
            if (n < string.length() && string.charAt(n) == ':') {
                throw new URIException("URI '" + string + "' can not be parsed successfully.");
            }
            this.scheme_ = null;
        } else if (n == string.length() || string.charAt(n) != ':') {
            this.scheme_ = null;
            n = 0;
        } else {
            ++n;
        }
        if (n <= string.length() - 2 && string.substring(n, n + 2).equals("//")) {
            this.authority_ = this.parseComponent(string, n += 2, AUTHORITY_CHARS_);
            n += this.authority_.length();
        }
        this.path_ = this.parseComponent(string, n, PATH_CHARS_);
        if ((n += this.path_.length()) <= string.length() - 1 && string.substring(n, n + 1).equals("?")) {
            this.query_ = this.parseComponent(string, ++n, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,");
            n += this.query_.length();
        }
        if (n <= string.length() - 1 && string.substring(n, n + 1).equals("#")) {
            this.reference_ = this.parseComponent(string, ++n, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$," + ADDITIONAL_REFERENCE_CHARS_);
            n += this.reference_.length();
        }
        if (n < string.length()) {
            throw new URIException("URI '" + string + "' can not be parsed successfully.");
        }
    }
}

