/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.risorse;

import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RigaTabellaBeanModel {
    private String tipo = null;
    private String codice = null;
    private String descrizione = null;
    private int lunghezza;
    private static Properties beans = null;
    private boolean solaScrittura;

    public RigaTabellaBeanModel(String riga) {
        StringTokenizer st = new StringTokenizer(riga, "#");
        if (st.countTokens() > 1) {
            this.solaScrittura = true;
        }
        st = new StringTokenizer(st.nextToken(), "*");
        this.tipo = st.nextToken();
        this.codice = st.nextToken();
        this.descrizione = st.nextToken();
        String valore = this.getProperty(this.tipo);
        StringTokenizer valoreToken = new StringTokenizer(valore, "*");
        if (valoreToken.countTokens() > 1) {
            valoreToken.nextToken();
            this.lunghezza = Integer.parseInt(valoreToken.nextToken());
        } else {
            this.lunghezza = st.hasMoreElements() ? Integer.parseInt(st.nextToken()) : 1;
        }
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public int getLunghezza() {
        return this.lunghezza;
    }

    private String getProperty(String key) {
        if (beans == null) {
            try {
                beans = new Properties();
                beans.load(this.getClass().getResourceAsStream("beans.ger"));
            }
            catch (IOException iOException) {
                System.out.println("Impossibile leggere il file beans.txt.");
            }
        }
        return beans.getProperty(key);
    }

    public String getTipo() {
        return this.tipo;
    }

    public boolean isSolaScrittura() {
        return this.solaScrittura;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[tipo=" + this.tipo + ", codice=" + this.codice + ", descrizione=" + this.descrizione + ", lunghezza=" + this.lunghezza + "]";
    }
}

