/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;

final class Krb5KeyExchange {
    static final SSLKeyAgreementGenerator kaGenerator = new Krb5KAGenerator();

    Krb5KeyExchange() {
    }

    private static final class Krb5KAGenerator
    implements SSLKeyAgreementGenerator {
        private Krb5KAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            Krb5PremasterSecret krb5PremasterSecret = null;
            if (handshakeContext instanceof ClientHandshakeContext) {
                for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                    if (!(sSLPossession instanceof Krb5PremasterSecret)) continue;
                    krb5PremasterSecret = (Krb5PremasterSecret)sSLPossession;
                    break;
                }
            } else {
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof Krb5PremasterSecret)) continue;
                    krb5PremasterSecret = (Krb5PremasterSecret)sSLCredentials;
                    break;
                }
            }
            if (krb5PremasterSecret == null) {
                handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient KRB5 key agreement parameters negotiated");
            }
            return new Krb5KAKeyDerivation(handshakeContext, krb5PremasterSecret.premasterSecret);
        }

        private static final class Krb5KAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final SecretKey preMasterSecret;

            Krb5KAKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
                this.context = handshakeContext;
                this.preMasterSecret = secretKey;
            }

            @Override
            public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (sSLMasterKeyDerivation == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, this.preMasterSecret);
                return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
            }
        }
    }

    static final class Krb5PremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final SecretKey premasterSecret;

        Krb5PremasterSecret(SecretKey secretKey) {
            this.premasterSecret = secretKey;
        }
    }
}

