/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.eclipse;

import it.sogei.rcp.core.controller.AdvisorStore;
import it.sogei.rcp.core.eclipse.RCPActionBarAdvisor;
import it.sogei.rcp.core.entity.ConfigurationItems;
import it.sogei.rcp.core.handlers.MenusHandler;
import it.sogei.rcp.core.handlers.WindowHandler;
import it.sogei.rcp.core.xml.bean.TabStyle;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class RCPWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public RCPWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new RCPActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        WindowHandler windowConfig = new WindowHandler(this.getWindowConfigurer());
        windowConfig.init();
        if (ConfigurationItems.getTabStyle() == TabStyle.CURVED) {
            PlatformUI.getPreferenceStore().setValue("SHOW_TRADITIONAL_STYLE_TABS", false);
        }
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowPerspectiveBar(ConfigurationItems.isShowPerspectivebar());
        configurer.setShowProgressIndicator(ConfigurationItems.isShowProgressIndicator());
        configurer.setShowFastViewBars(false);
        AdvisorStore.getWindowAdvisor().preWindowOpen();
    }

    public void postWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.getWindow().getShell().setMaximized(ConfigurationItems.getFullScreen());
        IMenuManager menuBar = configurer.getActionBarConfigurer().getMenuManager();
        MenusHandler.fillMenuList(menuBar.getItems());
        PreferenceManager prefMan = PlatformUI.getWorkbench().getPreferenceManager();
        List preference = prefMan.getElements(0);
        for (PreferenceNode node : preference) {
            if (!node.getId().equals("org.eclipse.ui.net.NetPreferences")) {
                prefMan.remove((IPreferenceNode)node);
                continue;
            }
            prefMan.addToRoot((IPreferenceNode)node);
        }
        AdvisorStore.getWindowAdvisor().postWindowOpen();
    }

    public void postWindowCreate() {
        AdvisorStore.getWindowAdvisor().postWindowCreate();
    }

    public void postWindowClose() {
        AdvisorStore.getWindowAdvisor().postWindowClose();
    }
}

