/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.structures.Attribute;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.smime.EncryptedContent;
import iaik.smime.PKCS10Content;
import iaik.smime.SignedContent;
import iaik.smime.TrustVerifier;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class SMimeShow {
    TrustVerifier trustVerifier;
    PrivateKey privateKey;
    boolean verbose = false;
    String url;
    String mbox = "INBOX";
    String password;
    String user;
    String host;
    String protocol;
    String from;

    public void show(String[] stringArray) throws IOException {
        int n = -1;
        int n2 = 0;
        if (stringArray.length > 0) {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-T")) {
                    this.protocol = stringArray[++n2];
                } else if (stringArray[n2].equals("-H")) {
                    this.host = stringArray[++n2];
                } else if (stringArray[n2].equals("-U")) {
                    this.user = stringArray[++n2];
                } else if (stringArray[n2].equals("-P")) {
                    this.password = stringArray[++n2];
                } else if (stringArray[n2].equals("-v")) {
                    this.verbose = true;
                } else if (stringArray[n2].equals("-f")) {
                    this.mbox = stringArray[++n2];
                } else if (stringArray[n2].equals("-L")) {
                    this.url = stringArray[++n2];
                } else {
                    if (stringArray[n2].equals("--")) {
                        ++n2;
                        break;
                    }
                    if (!stringArray[n2].startsWith("-")) break;
                    System.out.println("Usage: SMimeShow [-L url] [-T protocol] [-H host] [-U user] [-P password] [-f mailbox] [msgnum] [-v]");
                    System.exit(1);
                }
                ++n2;
            }
        } else {
            this.protocol = "pop3";
            this.host = "mailhost";
            this.user = "jsmime";
            this.password = "password";
            this.verbose = true;
        }
        try {
            URLName uRLName;
            if (n2 < stringArray.length) {
                n = Integer.parseInt(stringArray[n2]);
            }
            Session session = DemoUtil.getSession();
            Store store = null;
            if (this.url != null) {
                uRLName = new URLName(this.url);
                store = session.getStore(uRLName);
                store.connect();
            } else {
                store = this.protocol != null ? session.getStore(this.protocol) : session.getStore();
                if (this.host != null || this.user != null || this.password != null) {
                    store.connect(this.host, this.user, this.password);
                } else {
                    store.connect();
                }
            }
            uRLName = store.getDefaultFolder();
            if (uRLName == null) {
                System.out.println("No default folder");
                System.exit(1);
            }
            if ((uRLName = uRLName.getFolder(this.mbox)) == null) {
                System.out.println("Invalid folder");
                System.exit(1);
            }
            uRLName.open(1);
            int n3 = uRLName.getMessageCount();
            if (n3 == 0) {
                System.out.println("Empty folder");
                uRLName.close(false);
                store.close();
                System.exit(1);
            }
            if (this.verbose) {
                int n4 = uRLName.getNewMessageCount();
                System.out.println("Total messages = " + n3);
                System.out.println("New messages = " + n4);
                System.out.println("-------------------------------");
            }
            if (n == -1) {
                Message[] messageArray = uRLName.getMessages();
                FetchProfile fetchProfile = new FetchProfile();
                fetchProfile.add(FetchProfile.Item.ENVELOPE);
                fetchProfile.add(FetchProfile.Item.FLAGS);
                fetchProfile.add("X-Mailer");
                uRLName.fetch(messageArray, fetchProfile);
                int n5 = 0;
                while (n5 < messageArray.length) {
                    System.out.println("--------------------------");
                    System.out.println("MESSAGE #" + (n5 + 1) + ":");
                    this.from = messageArray[n5].getFrom()[0].toString();
                    this.dump(messageArray[n5]);
                    ++n5;
                }
            } else {
                System.out.println("Getting message number: " + n);
                Message message = uRLName.getMessage(n);
                this.from = message.getFrom()[0].toString();
                this.dump(message);
            }
            uRLName.close(false);
            store.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
        System.out.println("Ready! Press the space bar...");
        System.in.read();
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initSMimeDemos();
        new SMimeShow().show(stringArray);
        System.out.println("Ready!");
    }

    public static void dumpEnvelope(Message message) throws MessagingException {
        Object object;
        int n;
        System.out.println("This is the message envelope");
        System.out.println("---------------------------");
        Address[] addressArray = message.getFrom();
        if (addressArray != null) {
            n = 0;
            while (n < addressArray.length) {
                System.out.println("FROM: " + addressArray[n].toString());
                ++n;
            }
        }
        if ((addressArray = message.getRecipients(Message.RecipientType.TO)) != null) {
            n = 0;
            while (n < addressArray.length) {
                System.out.println("TO: " + addressArray[n].toString());
                ++n;
            }
        }
        System.out.println("SUBJECT: " + message.getSubject());
        Date date = message.getSentDate();
        System.out.println("SendDate: " + (date != null ? date.toString() : "UNKNOWN"));
        System.out.println("Size: " + message.getSize());
        Flags flags = message.getFlags();
        StringBuffer stringBuffer = new StringBuffer();
        Flags.Flag[] flagArray = flags.getSystemFlags();
        boolean bl = true;
        int n2 = 0;
        while (n2 < flagArray.length) {
            block20: {
                block15: {
                    Flags.Flag flag;
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        flag = flagArray[n2];
                                        if (flag != Flags.Flag.ANSWERED) break block14;
                                        object = "\\Answered";
                                        break block15;
                                    }
                                    if (flag != Flags.Flag.DELETED) break block16;
                                    object = "\\Deleted";
                                    break block15;
                                }
                                if (flag != Flags.Flag.DRAFT) break block17;
                                object = "\\Draft";
                                break block15;
                            }
                            if (flag != Flags.Flag.FLAGGED) break block18;
                            object = "\\Flagged";
                            break block15;
                        }
                        if (flag != Flags.Flag.RECENT) break block19;
                        object = "\\Recent";
                        break block15;
                    }
                    if (flag != Flags.Flag.SEEN) break block20;
                    object = "\\Seen";
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(' ');
                }
                stringBuffer.append((String)object);
            }
            ++n2;
        }
        object = flags.getUserFlags();
        int n3 = 0;
        while (n3 < ((String[])object).length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(object[n3]);
            ++n3;
        }
        System.out.println("FLAGS = " + stringBuffer.toString());
        String[] stringArray = message.getHeader("X-Mailer");
        if (stringArray != null) {
            System.out.println("X-Mailer: " + stringArray[0]);
            return;
        }
        System.out.println("X-Mailer NOT available");
    }

    public void dump(Object object) throws Exception {
        if (object instanceof Message) {
            SMimeShow.dumpEnvelope((Message)object);
        }
        if (object instanceof Part) {
            System.out.println("CONTENT-TYPE: " + ((Part)object).getContentType());
            object = ((Part)object).getContent();
        }
        if (object instanceof EncryptedContent) {
            System.out.println("This message is encrypted!");
            EncryptedContent encryptedContent = (EncryptedContent)object;
            encryptedContent.decryptSymmetricKey((Key)this.privateKey, 0);
            this.dump(encryptedContent.getContent());
            return;
        }
        if (object instanceof SignedContent) {
            X509Certificate[] x509CertificateArray;
            System.out.println("This message is signed!");
            SignedContent signedContent = (SignedContent)object;
            if (signedContent.getSMimeType().equals("certs-only")) {
                System.out.println("This message contains only certificates!");
                Certificate[] certificateArray = signedContent.getCertificates();
                int n = 0;
                while (n < certificateArray.length) {
                    System.out.println(certificateArray[n].toString());
                    ++n;
                }
                return;
            }
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = signedContent.verify();
                System.out.println("This message is signed from: " + x509Certificate.getSubjectDN());
                x509CertificateArray = Util.convertCertificateChain((Certificate[])signedContent.getCertificates());
                x509CertificateArray = Util.arrangeCertificateChain((X509Certificate[])x509CertificateArray, (boolean)false);
                if (x509CertificateArray != null) {
                    try {
                        this.trustVerifier.verifyCertificateChain(x509CertificateArray);
                        System.out.println("Certificate chain trusted!");
                    }
                    catch (CertificateException certificateException) {
                        System.out.println("Certificate chain not trusted!");
                    }
                }
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Signature verification error!" + signatureException.getMessage());
            }
            if (this.trustVerifier.checkEMail(this.from, x509Certificate)) {
                System.out.println("EMail is ok!");
            } else {
                System.out.println("EMail not ok!");
            }
            x509CertificateArray = signedContent.getSignerInfos();
            int n = 0;
            while (n < x509CertificateArray.length) {
                Attribute[] attributeArray;
                Attribute[] attributeArray2 = x509CertificateArray[n].getSignedAttributes();
                if (attributeArray2 != null) {
                    System.out.println("SignerInfo " + n + " contains the following signed attributes:");
                    int n2 = 0;
                    while (n2 < attributeArray2.length) {
                        System.out.println(attributeArray2[n2].getType().getName());
                        System.out.println(attributeArray2[n2]);
                        System.out.println();
                        ++n2;
                    }
                }
                if ((attributeArray = x509CertificateArray[n].getUnsignedAttributes()) != null) {
                    System.out.println("SignerInfo " + n + " contains the following unsigned attributes:");
                    int n3 = 0;
                    while (n3 < attributeArray.length) {
                        System.out.println(attributeArray[n3].getType().getName());
                        ++n3;
                    }
                }
                ++n;
            }
            this.dump(signedContent.getContent());
            return;
        }
        if (object instanceof PKCS10Content) {
            System.out.println("This message contains a certificate request:");
            PKCS10Content pKCS10Content = (PKCS10Content)object;
            CertificateRequest certificateRequest = pKCS10Content.getCertRequest();
            System.out.println(certificateRequest.toString());
            try {
                if (certificateRequest.verify()) {
                    System.out.println("Request verification ok for " + certificateRequest.getSubject());
                    return;
                }
                System.out.println("Request verification error for " + certificateRequest.getSubject());
                return;
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Request verification error for " + certificateRequest.getSubject());
            }
        }
        if (object instanceof String) {
            System.out.println("Content is a String");
            System.out.println("---------------------------");
            System.out.println((String)object);
            return;
        }
        if (object instanceof Multipart) {
            System.out.println("----------------> Content is a Multipart");
            Multipart multipart = (Multipart)object;
            int n = multipart.getCount();
            int n4 = 0;
            while (n4 < n) {
                System.out.println("----------------> Multipart: " + (n4 + 1));
                this.dump(multipart.getBodyPart(n4));
                ++n4;
            }
            System.out.println("----------------> End of Multipart");
            return;
        }
        if (object instanceof Message) {
            System.out.println("Content is a Nested Message");
            System.out.println("---------------------------");
            this.dump(object);
            return;
        }
        if (object instanceof InputStream) {
            int n;
            System.out.println("Content is just an input stream: " + object);
            System.out.println("---------------------------");
            InputStream inputStream = (InputStream)object;
            int n5 = 0;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                n5 += n;
            }
            System.out.println("Length of data: " + n5 + " bytes");
        }
    }

    public SMimeShow() {
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                                 SMimeShow demo                                         *");
        System.out.println("*     (shows how to parse and verify/decrypt signed and/or encrypted S/MIME messages)    *");
        System.out.println("******************************************************************************************");
        System.out.println();
        this.privateKey = CMSKeyStore.getPrivateKey(0, 5);
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 1);
        this.trustVerifier = new TrustVerifier();
        this.trustVerifier.addTrustedCertificate(x509CertificateArray[1]);
    }
}

