/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import iaik.asn1.structures.Attribute;
import iaik.cms.SignerInfo;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.smime.CompressedContent;
import iaik.smime.EncryptedContent;
import iaik.smime.PKCS10Content;
import iaik.smime.SignedContent;
import iaik.smime.ess.Receipt;
import iaik.smime.ess.ReceiptContent;
import iaik.x509.X509Certificate;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;

public class DumpMessage {
    public static PrivateKey privateKey;

    public static void dumpEnvelope(Message message) throws MessagingException {
        Object object;
        int n;
        System.out.println("This is the message envelope");
        System.out.println("---------------------------");
        Address[] addressArray = message.getFrom();
        if (addressArray != null) {
            n = 0;
            while (n < addressArray.length) {
                System.out.println("FROM: " + addressArray[n].toString());
                ++n;
            }
        }
        if ((addressArray = message.getRecipients(Message.RecipientType.TO)) != null) {
            n = 0;
            while (n < addressArray.length) {
                System.out.println("TO: " + addressArray[n].toString());
                ++n;
            }
        }
        System.out.println("SUBJECT: " + message.getSubject());
        Date date = message.getSentDate();
        System.out.println("SendDate: " + (date != null ? date.toString() : "UNKNOWN"));
        System.out.println("Size: " + message.getSize());
        Flags flags = message.getFlags();
        StringBuffer stringBuffer = new StringBuffer();
        Flags.Flag[] flagArray = flags.getSystemFlags();
        boolean bl = true;
        int n2 = 0;
        while (n2 < flagArray.length) {
            block20: {
                block15: {
                    Flags.Flag flag;
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        flag = flagArray[n2];
                                        if (flag != Flags.Flag.ANSWERED) break block14;
                                        object = "\\Answered";
                                        break block15;
                                    }
                                    if (flag != Flags.Flag.DELETED) break block16;
                                    object = "\\Deleted";
                                    break block15;
                                }
                                if (flag != Flags.Flag.DRAFT) break block17;
                                object = "\\Draft";
                                break block15;
                            }
                            if (flag != Flags.Flag.FLAGGED) break block18;
                            object = "\\Flagged";
                            break block15;
                        }
                        if (flag != Flags.Flag.RECENT) break block19;
                        object = "\\Recent";
                        break block15;
                    }
                    if (flag != Flags.Flag.SEEN) break block20;
                    object = "\\Seen";
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(' ');
                }
                stringBuffer.append((String)object);
            }
            ++n2;
        }
        object = flags.getUserFlags();
        int n3 = 0;
        while (n3 < ((String[])object).length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(object[n3]);
            ++n3;
        }
        System.out.println("FLAGS = " + stringBuffer.toString());
        String[] stringArray = message.getHeader("X-Mailer");
        if (stringArray != null) {
            System.out.println("X-Mailer: " + stringArray[0]);
            return;
        }
        System.out.println("X-Mailer NOT available");
    }

    public static void dump(Object object) throws Exception {
        if (object instanceof Message) {
            DumpMessage.dumpEnvelope((Message)object);
        }
        if (object instanceof Part) {
            System.out.println("CONTENT-TYPE: " + ((Part)object).getContentType());
            object = ((Part)object).getContent();
        }
        if (object instanceof EncryptedContent) {
            System.out.println("This message is encrypted!");
            EncryptedContent encryptedContent = (EncryptedContent)object;
            encryptedContent.decryptSymmetricKey((Key)privateKey, 0);
            DumpMessage.dump(encryptedContent.getContent());
            return;
        }
        if (object instanceof SignedContent) {
            System.out.println("This message is signed!");
            SignedContent signedContent = (SignedContent)object;
            if (signedContent.getSMimeType().equals("certs-only")) {
                System.out.println("This message contains only certificates!");
                Certificate[] certificateArray = signedContent.getCertificates();
                int n = 0;
                while (n < certificateArray.length) {
                    System.out.println(certificateArray[n].toString());
                    ++n;
                }
                return;
            }
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = signedContent.verify();
                System.out.println("This message is signed from: " + x509Certificate.getSubjectDN());
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Signature verification error: " + signatureException.toString());
            }
            SignerInfo[] signerInfoArray = signedContent.getSignerInfos();
            int n = 0;
            while (n < signerInfoArray.length) {
                Attribute[] attributeArray;
                Attribute[] attributeArray2 = signerInfoArray[n].getSignedAttributes();
                if (attributeArray2 != null) {
                    System.out.println("SignerInfo " + n + " contains the following signed attributes:");
                    int n2 = 0;
                    while (n2 < attributeArray2.length) {
                        System.out.println(attributeArray2[n2].getType().getName());
                        System.out.println(attributeArray2[n2]);
                        System.out.println();
                        ++n2;
                    }
                }
                if ((attributeArray = signerInfoArray[n].getUnsignedAttributes()) != null) {
                    System.out.println("SignerInfo " + n + " contains the following unsigned attributes:");
                    int n3 = 0;
                    while (n3 < attributeArray.length) {
                        System.out.println(attributeArray[n3].getType().getName());
                        ++n3;
                    }
                }
                ++n;
            }
            DumpMessage.dump(signedContent.getContent());
            return;
        }
        if (object instanceof PKCS10Content) {
            System.out.println("This message contains a certificate request:");
            PKCS10Content pKCS10Content = (PKCS10Content)object;
            CertificateRequest certificateRequest = pKCS10Content.getCertRequest();
            System.out.println(certificateRequest.toString());
            try {
                if (certificateRequest.verify()) {
                    System.out.println("Request verification ok for " + certificateRequest.getSubject());
                    return;
                }
                throw new SignatureException("Incorrect signature!");
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Request verification error for " + certificateRequest.getSubject() + signatureException.getMessage());
            }
        }
        if (object instanceof CompressedContent) {
            System.out.println("The content of this message is compressed.");
            CompressedContent compressedContent = (CompressedContent)object;
            DumpMessage.dump(compressedContent.getContent());
            return;
        }
        if (object instanceof PKCS10Content) {
            System.out.println("This message contains a signed receipt:");
            ReceiptContent receiptContent = (ReceiptContent)object;
            Receipt receipt = (Receipt)receiptContent.getContent();
            System.out.println(receipt);
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = receiptContent.verify();
                System.out.println("This receipt content is signed from: " + x509Certificate.getSubjectDN());
                return;
            }
            catch (SignatureException signatureException) {
                System.err.println("Signature verification error!");
                throw signatureException;
            }
        }
        if (object instanceof String) {
            System.out.println("Content is a String");
            System.out.println("---------------------------");
            System.out.println((String)object);
            return;
        }
        if (object instanceof Multipart) {
            System.out.println("----------------> Content is a Multipart");
            Multipart multipart = (Multipart)object;
            int n = multipart.getCount();
            int n4 = 0;
            while (n4 < n) {
                System.out.println("----------------> Multipart: " + (n4 + 1));
                DumpMessage.dump(multipart.getBodyPart(n4));
                ++n4;
            }
            System.out.println("----------------> End of Multipart");
            return;
        }
        if (object instanceof Message) {
            System.out.println("Content is a Nested Message");
            System.out.println("---------------------------");
            DumpMessage.dump(object);
            return;
        }
        if (object instanceof InputStream) {
            int n;
            System.out.println("Content is just an input stream: " + object);
            System.out.println("---------------------------");
            InputStream inputStream = (InputStream)object;
            int n5 = 0;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                n5 += n;
            }
            System.out.println("Length of data: " + n5 + " bytes");
        }
    }
}

