/*
 * Decompiled with CFR 0.152.
 */
package demo.cms.tsp;

import demo.DemoUtil;
import demo.cms.tsp.TimeStampListener;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.smime.attributes.SignatureTimeStampToken;
import iaik.tsp.MessageImprint;
import iaik.tsp.TSTInfo;
import iaik.tsp.TimeStampToken;
import iaik.tsp.TspException;
import iaik.utils.CryptoUtils;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;

public class TimeStampDemo {
    X509Certificate[] certificates_;
    PrivateKey signerKey_;
    X509Certificate signerCert_;
    byte[] message_;
    static final String a = "http://tsp.iaik.at/tsp/TspRequest";

    public void start() {
        try {
            byte[] byArray = null;
            System.out.println("\nImplicit SignedDataStream TSP demo [create]:\n");
            byte[] byArray2 = this.createSignedDataStream(this.message_, 1);
            System.out.println("\nImplicit SignedDataStream TSP demo [parse]:\n");
            byArray = this.getSignedDataStream(byArray2, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            System.out.println("\nExplicit SignedDataStream TSP demo [create]:\n");
            byArray2 = this.createSignedDataStream(this.message_, 2);
            System.out.println("\nExplicit SignedDataStream TSP demo [parse]:\n");
            byArray = this.getSignedDataStream(byArray2, this.message_);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            DemoUtil.initDemos();
            new TimeStampDemo().start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2) throws Exception {
        SignatureTimeStampToken signatureTimeStampToken;
        CMSContentType cMSContentType;
        X509Certificate x509Certificate;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        if (byArray2 != null) {
            signedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        InputStream inputStream = signedDataStream.getInputStream();
        byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        SignerInfo signerInfo = signedDataStream.getSignerInfos()[0];
        try {
            x509Certificate = signedDataStream.verify(0);
            System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfo.getSignerIdentifier()).getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        x509Certificate = (SigningTime)signerInfo.getSignedAttributeValue(ObjectID.signingTime);
        if (x509Certificate != null) {
            System.out.println("This message has been signed at " + x509Certificate.get());
        }
        if ((cMSContentType = (CMSContentType)signerInfo.getSignedAttributeValue(ObjectID.contentType)) != null) {
            System.out.println("The content has CMS content type " + cMSContentType.get().getName());
        }
        if ((signatureTimeStampToken = (SignatureTimeStampToken)signerInfo.getUnsignedAttributeValue(SignatureTimeStampToken.oid)) != null) {
            System.out.println("SignerInfo contains SignatureTimeStampToken attribute.");
            TimeStampToken timeStampToken = new TimeStampToken(signatureTimeStampToken.toASN1Object());
            X509Certificate x509Certificate2 = (X509Certificate)timeStampToken.getSigningCertificate();
            if (x509Certificate2 == null) {
                throw new TspException("Cannot verify TimeStampToken: TSA certificate not included!");
            }
            timeStampToken.verifyTimeStampToken((java.security.cert.X509Certificate)x509Certificate2);
            TSTInfo tSTInfo = timeStampToken.getTSTInfo();
            MessageImprint messageImprint = tSTInfo.getMessageImprint();
            AlgorithmID algorithmID = messageImprint.getHashAlgorithm();
            MessageDigest messageDigest = null;
            try {
                messageDigest = algorithmID.getMessageDigestInstance();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new TspException("Cannot calculate MessageImprint! Hash Algorithm not supported: " + noSuchAlgorithmException.getMessage());
            }
            byte[] byArray3 = messageDigest.digest(signerInfo.getSignatureValue());
            if (!CryptoUtils.equalsBlock((byte[])byArray3, (byte[])messageImprint.getHashedMessage())) {
                throw new TspException("Invalid timestamp token: wrong MessageImprint value!");
            }
            System.out.println("Signature has been time stamped from " + x509Certificate2.getSubjectDN() + " at: " + tSTInfo.getGenTime());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws Exception {
        Object object;
        Closeable closeable;
        System.out.println("Create SignedData message...");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates((Certificate[])this.certificates_);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.signerCert_);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.signerKey_);
        Attribute[] attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(ObjectID.cms_data)), new Attribute((AttributeValue)new SigningTime())};
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        TimeStampListener timeStampListener = new TimeStampListener(a);
        timeStampListener.setDebugStream(System.out);
        signedDataStream.setSDSEncodeListener((SDSEncodeListener)timeStampListener);
        if (n == 2) {
            int n2;
            closeable = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)closeable).read((byte[])object)) > 0) {
            }
        }
        signedDataStream.setBlockSize(2048);
        closeable = new ByteArrayOutputStream();
        object = new ContentInfoStream((ContentStream)signedDataStream);
        object.writeTo((OutputStream)closeable);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public TimeStampDemo() {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           TimeStampDemo demo                                   *");
        System.out.println("*   (shows how to add a TimeStampToken attribute to a SignedDataStream object)   *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.message_ = "This is a test message!".getBytes();
        this.certificates_ = CMSKeyStore.getCertificateChain(0, 1);
        this.signerCert_ = this.certificates_[0];
        this.signerKey_ = CMSKeyStore.getPrivateKey(0, 1);
    }
}

