/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.x509.UnknownExtension;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.ocsp.extensions.AcceptableResponses;
import iaik.x509.ocsp.extensions.ArchiveCutoff;
import iaik.x509.ocsp.extensions.CrlID;
import iaik.x509.ocsp.extensions.Nonce;
import iaik.x509.ocsp.extensions.ServiceLocator;

public class OCSPExtensions
extends X509Extensions {
    static /* synthetic */ Class a;
    static /* synthetic */ Class b;
    static /* synthetic */ Class c;
    static /* synthetic */ Class d;
    static /* synthetic */ Class e;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        boolean bl = true;
        byte[] byArray = (byte[])this.critical_extensions.get(objectID);
        if (byArray == null) {
            byArray = (byte[])this.noncritical_extensions.get(objectID);
            if (byArray == null) {
                return null;
            }
            bl = false;
        }
        V3Extension v3Extension = null;
        try {
            v3Extension = X509Extensions.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            v3Extension = new UnknownExtension(objectID);
        }
        v3Extension.setCritical(bl);
        try {
            ASN1Object aSN1Object = objectID.equals(Nonce.oid) ? new OCTET_STRING(byArray) : DerCoder.decode(byArray);
            v3Extension.init(aSN1Object);
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new X509ExtensionInitException(objectID, bl, x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new X509ExtensionInitException(objectID, bl, codingException.toString());
        }
        return v3Extension;
    }

    public boolean addExtension(V3Extension v3Extension) throws X509ExtensionException {
        ASN1Object aSN1Object = v3Extension.toASN1Object();
        byte[] byArray = aSN1Object == null ? new byte[]{} : (v3Extension.getObjectID().equals(Nonce.oid) ? ((Nonce)v3Extension).getValue() : DerCoder.encode(v3Extension.toASN1Object()));
        if (v3Extension.isCritical()) {
            return this.critical_extensions.put(v3Extension.getObjectID(), byArray) != null;
        }
        return this.noncritical_extensions.put(v3Extension.getObjectID(), byArray) != null;
    }

    public OCSPExtensions(ASN1Object aSN1Object) throws X509ExtensionException {
        super(aSN1Object);
    }

    public OCSPExtensions() {
    }

    static {
        X509Extensions.register(AcceptableResponses.oid, e != null ? e : (e = OCSPExtensions.a("iaik.x509.ocsp.extensions.AcceptableResponses")));
        X509Extensions.register(ArchiveCutoff.oid, d != null ? d : (d = OCSPExtensions.a("iaik.x509.ocsp.extensions.ArchiveCutoff")));
        X509Extensions.register(CrlID.oid, c != null ? c : (c = OCSPExtensions.a("iaik.x509.ocsp.extensions.CrlID")));
        X509Extensions.register(Nonce.oid, b != null ? b : (b = OCSPExtensions.a("iaik.x509.ocsp.extensions.Nonce")));
        X509Extensions.register(ServiceLocator.oid, a != null ? a : (a = OCSPExtensions.a("iaik.x509.ocsp.extensions.ServiceLocator")));
    }
}

