/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.pkcs.NetscapeCertList;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.utils.ASN1InputStream;
import iaik.utils.Util;
import iaik.x509.CertificateFactory;
import iaik.x509.X509CertPath;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class X509CertificateFactory
extends CertificateFactory {
    public Iterator engineGetCertPathEncodings() {
        return X509CertPath.a();
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        return new X509CertPath(list);
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        X509CertPath x509CertPath;
        block9: {
            if (inputStream == null) {
                throw new NullPointerException("inStream must not be null!");
            }
            if (string == null) {
                throw new NullPointerException("encoding must not be null!");
            }
            x509CertPath = null;
            String string2 = string.toUpperCase();
            try {
                if (string2.equals(X509CertPath.d)) {
                    x509CertPath = new X509CertPath(Util.readPkiPath(inputStream));
                    break block9;
                }
                ASN1InputStream aSN1InputStream = inputStream instanceof ASN1InputStream ? (ASN1InputStream)inputStream : new ASN1InputStream(inputStream);
                if (string2.equals("DER") || string2.equals("PEM")) {
                    x509CertPath = new X509CertPath(Util.readCertificateChain(aSN1InputStream));
                    break block9;
                }
                if (string2.equals("PKCS7")) {
                    PKCS7CertList pKCS7CertList = new PKCS7CertList(aSN1InputStream);
                    x509CertPath = new X509CertPath(pKCS7CertList.getCertificateList());
                    break block9;
                }
                if (string2.equals("NETSCAPE")) {
                    NetscapeCertList netscapeCertList = new NetscapeCertList(aSN1InputStream);
                    x509CertPath = new X509CertPath(netscapeCertList.getCertificateList());
                    break block9;
                }
                throw new CertificateException("Requested encoding format \"" + string + "\" not supported!");
            }
            catch (PKCSException pKCSException) {
                throw new CertificateException("Error reading certificates: " + pKCSException.toString());
            }
            catch (IOException iOException) {
                throw new CertificateException("Error reading certificates: " + iOException.toString());
            }
        }
        return x509CertPath;
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new NullPointerException("inStream must not be null!");
        }
        X509Certificate[] x509CertificateArray = null;
        CertificateException certificateException = null;
        try {
            x509CertificateArray = Util.readPkiPath(inputStream);
        }
        catch (Exception exception) {
            certificateException = new CertificateException("Error while reading certificates: " + exception.toString());
        }
        if (x509CertificateArray == null) {
            try {
                Collection collection = this.engineGenerateCertificates(inputStream);
                x509CertificateArray = new X509Certificate[collection.size()];
                Object[] objectArray = collection.toArray();
                int n2 = 0;
                while (n2 < x509CertificateArray.length) {
                    x509CertificateArray[n2] = (X509Certificate)objectArray[n2];
                    ++n2;
                }
            }
            catch (CertificateException certificateException2) {
                if (certificateException != null) {
                    throw certificateException;
                }
                throw certificateException2;
            }
        }
        return new X509CertPath(x509CertificateArray);
    }
}

