/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.dsa.DSAParams;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.DSAPrivateKeySpec;

public class DSAPrivateKey
extends PrivateKeyInfo
implements Serializable,
java.security.interfaces.DSAPrivateKey {
    private DSAParams c;
    private BigInteger a;
    private transient ASN1 b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DSA private key");
        stringBuffer.append(this.c == null ? ":\n" : " (" + this.c.getP().bitLength() + " bits):\n");
        stringBuffer.append("x: " + this.a.toString(16) + "\n");
        stringBuffer.append(this.c.toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.c.hashCode() ^ this.a.hashCode();
    }

    public BigInteger getX() {
        return this.a;
    }

    public java.security.interfaces.DSAParams getParams() {
        return this.c;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)object;
            if (!this.a.equals(dSAPrivateKey.getX())) {
                return false;
            }
            return this.c.equals(dSAPrivateKey.getParams());
        }
        return false;
    }

    public byte[] encode() {
        return this.b.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a = (BigInteger)this.b.toASN1Object().getValue();
            this.c = new DSAParams(this.private_key_algorithm.getParameter());
            return;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DSA private key.");
        }
    }

    private void b() {
        try {
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.dsa.clone();
            this.private_key_algorithm.setParameter(this.c.toASN1Object());
            this.b = new ASN1(new INTEGER(this.a));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPrivateKeyInfo();
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DSAPrivateKey(DSAPrivateKeySpec dSAPrivateKeySpec) {
        this(dSAPrivateKeySpec.getX(), dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
    }

    public DSAPrivateKey(java.security.interfaces.DSAPrivateKey dSAPrivateKey) {
        this(dSAPrivateKey.getX(), dSAPrivateKey.getParams());
    }

    public DSAPrivateKey(BigInteger bigInteger, java.security.interfaces.DSAParams dSAParams) {
        this.a = bigInteger;
        this.c = new DSAParams(dSAParams);
        this.b();
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.a = bigInteger;
        this.c = new DSAParams(bigInteger2, bigInteger3, bigInteger4);
        this.b();
    }

    public DSAPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    public DSAPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }
}

