/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurveImpl;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.FieldException;
import java.math.BigInteger;

class BinaryAffineCurve
extends EllipticCurveImpl {
    public boolean useAffine() {
        return true;
    }

    public void multiply(ECPoint eCPoint, BigInteger bigInteger) {
        if (eCPoint.isInfinity()) {
            return;
        }
        if (this.order_ != null && bigInteger.compareTo(this.order_) >= 0) {
            bigInteger = bigInteger.mod(this.order_);
        }
        ECPoint eCPoint2 = (ECPoint)eCPoint.clone();
        switch (bigInteger.signum()) {
            case 0: {
                eCPoint.setInfinity();
                return;
            }
            case -1: {
                bigInteger = bigInteger.negate();
                eCPoint.invert();
            }
            case 1: {
                eCPoint2.invert();
            }
        }
        ECPoint eCPoint3 = (ECPoint)eCPoint.clone();
        BigInteger bigInteger2 = bigInteger.multiply(Constants.BIG_THREE);
        int n = bigInteger2.bitLength() - 2;
        while (n > 0) {
            eCPoint3.doublePoint();
            if (bigInteger2.testBit(n) && !bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint);
            }
            if (!bigInteger2.testBit(n) && bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint2);
            }
            --n;
        }
        if (eCPoint3.isInfinity()) {
            eCPoint.setInfinity();
        } else {
            eCPoint.getCoordinates().setX(eCPoint3.getCoordinates().getX());
            eCPoint.getCoordinates().setY(eCPoint3.getCoordinates().getY());
        }
    }

    public void invert(ECPoint eCPoint) {
        FieldElement fieldElement = (FieldElement)eCPoint.getCoordinates().getX().clone();
        eCPoint.getCoordinates().setY(fieldElement.add(eCPoint.getCoordinates().getY()));
    }

    public Field getField() {
        return this.field_;
    }

    public void doublePoint(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        this.addPoint(eCPoint, eCPoint);
    }

    public void addPoint(ECPoint eCPoint, ECPoint eCPoint2) {
        if (eCPoint2 == eCPoint) {
            if (eCPoint.isInfinity()) {
                return;
            }
            eCPoint2 = (ECPoint)eCPoint2.clone();
        }
        if (eCPoint.isInfinity()) {
            if (eCPoint2.isInfinity()) {
                return;
            }
            Coordinate coordinate = (Coordinate)eCPoint2.getCoordinates().clone();
            eCPoint.setCoordinates(coordinate);
            eCPoint.unsetInfinity();
            return;
        }
        if (eCPoint2.isInfinity()) {
            return;
        }
        if (!eCPoint.getCoordinates().getX().equals(eCPoint2.getCoordinates().getX())) {
            FieldElement fieldElement = FieldElement.add(eCPoint.getCoordinates().getY(), eCPoint2.getCoordinates().getY()).divide(FieldElement.add(eCPoint.getCoordinates().getX(), eCPoint2.getCoordinates().getX()));
            eCPoint.getCoordinates().setX(FieldElement.add(this.a_, FieldElement.square(fieldElement)).add(fieldElement).add(eCPoint.getCoordinates().getX()).add(eCPoint2.getCoordinates().getX()));
            eCPoint.getCoordinates().setY(FieldElement.add(eCPoint.getCoordinates().getX(), eCPoint2.getCoordinates().getX()).multiply(fieldElement).add(eCPoint.getCoordinates().getX()).add(eCPoint2.getCoordinates().getY()));
            return;
        }
        if (!eCPoint.getCoordinates().getY().equals(eCPoint2.getCoordinates().getY()) || eCPoint2.getCoordinates().getX().isZero()) {
            eCPoint.setInfinity();
            return;
        }
        FieldElement fieldElement = FieldElement.add(eCPoint2.getCoordinates().getY(), eCPoint2.getCoordinates().getX());
        try {
            fieldElement = FieldElement.divide(eCPoint2.getCoordinates().getY(), eCPoint2.getCoordinates().getX());
        }
        catch (FieldException fieldException) {
            throw new IllegalArgumentException("A non invertible FieldElement is fed to method FieldElement#divide");
        }
        FieldElement fieldElement2 = FieldElement.add(eCPoint.getCoordinates().getX(), fieldElement);
        eCPoint.getCoordinates().setX(FieldElement.add(this.a_, FieldElement.square(fieldElement2)).add(fieldElement2));
        eCPoint.getCoordinates().setY(FieldElement.add(FieldElement.multiply(fieldElement2, eCPoint.getCoordinates().getX()), eCPoint.getCoordinates().getX()).add(FieldElement.square(eCPoint2.getCoordinates().getX())));
    }

    BinaryAffineCurve(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) {
        this.a_ = fieldElement;
        this.b_ = fieldElement2;
        this.field_ = fieldElement.getField();
        this.order_ = bigInteger;
    }
}

