/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs12.SafeBag;

public class SecretBag
extends SafeBag {
    protected ObjectID secret_type;
    protected ASN1Object secret_object;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Secret type: " + this.secret_type + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.secret_type);
        sEQUENCE.addComponent(new CON_SPEC(0, this.secret_object));
        return sEQUENCE;
    }

    public ObjectID getSecretType() {
        return this.secret_type;
    }

    public ASN1Object getSecretObject() {
        return this.secret_object;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.secret_type = (ObjectID)aSN1Object.getComponentAt(0);
        this.secret_object = (ASN1Object)aSN1Object.getComponentAt(1).getValue();
    }

    public SecretBag(ASN1Object aSN1Object, ObjectID objectID, String string, byte[] byArray) {
        super(string, byArray);
        this.secret_object = aSN1Object;
        this.secret_type = objectID;
        this.j = ObjectID.pkcs12_secretBag;
    }

    public SecretBag(ASN1Object aSN1Object, ObjectID objectID) {
        this.secret_object = aSN1Object;
        this.j = ObjectID.pkcs12_secretBag;
        this.secret_type = objectID;
    }

    protected SecretBag() {
        this.j = ObjectID.pkcs12_secretBag;
    }
}

