/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.CreateCert;
import demo.Demo;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.x509.X509Certificate;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;

public class PKCS12Demo
extends CreateCert
implements Demo {
    protected static char[] password_ = "password".toCharArray();

    protected void run() throws Exception {
        KeyPair keyPair = this.generateKeyPair(this.curveName_);
        X509Certificate x509Certificate = this.createCertificate(keyPair);
        String string = "test.p12";
        PKCS12 pKCS12 = this.createPKCS12(x509Certificate, keyPair);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        pKCS12.writeTo((OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        System.out.println("Parsing PKCS#12 object...");
        FileInputStream fileInputStream = new FileInputStream(string);
        PKCS12 pKCS122 = new PKCS12((InputStream)fileInputStream);
        System.out.println("Verifying MAC...");
        if (!pKCS122.verify(password_)) {
            throw new PKCSException("Verification error!");
        }
        System.out.println("Decrypting PKCS#12 object...");
        pKCS122.decrypt(password_);
        KeyBag keyBag = pKCS122.getKeyBag();
        PrivateKey privateKey = keyBag.getPrivateKey();
        System.out.println("Key is " + privateKey.getAlgorithm());
        CertificateBag[] certificateBagArray = pKCS122.getCertificateBags();
        System.out.println("Certificate : ");
        System.out.println(certificateBagArray[0].getCertificate());
        System.out.println("DONE!");
    }

    protected PKCS12 createPKCS12(X509Certificate x509Certificate, KeyPair keyPair) throws PKCSException {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
        byte[] byArray = new byte[]{1, 2, 3, 4};
        KeyBag keyBag = new KeyBag(keyPair.getPrivate(), "MyTest ID", byArray);
        CertificateBag[] certificateBagArray = new CertificateBag[x509CertificateArray.length];
        certificateBagArray[0] = new CertificateBag(x509CertificateArray[0]);
        certificateBagArray[0].setFriendlyName("My Test ID");
        certificateBagArray[0].setLocalKeyID(byArray);
        PKCS12 pKCS12 = new PKCS12(keyBag, certificateBagArray, false);
        pKCS12.encrypt(password_);
        return pKCS12;
    }

    public boolean runDemo() {
        try {
            this.run();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        CreateCert.init();
        PKCS12Demo pKCS12Demo = new PKCS12Demo();
        if (pKCS12Demo.runDemo()) {
            System.out.println("FINISHED");
        } else {
            System.out.println("FAILED");
        }
    }
}

