/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2002;

import finanze.IDTE.generale2002.CF;
import finanze.IDTE.generale2002.Campo;
import finanze.IDTE.generale2002.DataSogei;
import finanze.IDTE.generale2002.Dichiarazione;
import finanze.IDTE.generale2002.PIVA;
import finanze.IDTE.resources.RecordParser;
import java.text.CollationKey;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    public static String accapo(int dove, String riga) {
        String out = "";
        if (dove >= riga.length()) {
            out = riga;
        } else {
            int taglio = riga.lastIndexOf(32, dove);
            if (taglio == 0 || taglio == -1) {
                taglio = dove;
            }
            out = riga.length() - taglio >= dove ? riga.substring(0, taglio) + "\n" + Util.accapo(dove, riga.substring(taglio, riga.length()).trim()) : riga.substring(0, taglio) + "\n" + riga.substring(taglio, riga.length()).trim();
        }
        return out;
    }

    public static String aggiungiMigliaia(String num) {
        if (Util.numerico(num)) {
            String out = new String();
            int pos = num.indexOf(",");
            int i = pos > 0 ? pos : num.length();
            while (i > 0) {
                if (i - 3 <= 0 || i - 3 == 1 && num.charAt(0) == '-') {
                    return num.substring(0, i) + out + (pos > 0 ? num.substring(pos, num.length()) : "");
                }
                out = "." + num.substring(i - 3, i) + out;
                i -= 3;
            }
        }
        System.out.println("Errore nella conversione delle migliaia del numero:" + num);
        return "0";
    }

    public static int aggRc(int rc, int rc_new) {
        if (rc_new > rc) {
            return rc_new;
        }
        return rc;
    }

    public static double arrotonda(int mod, double a) {
        return mod == 1 ? (double)Math.round(a) : Math.floor(a + 0.499);
    }

    public static String bollino(String s) {
        int lng = s.length();
        byte[] rigabyte = s.getBytes();
        byte[] rc = new byte[]{0};
        long x = 0L;
        int i = 0;
        while (i < lng) {
            x = (long)rigabyte[i] + x;
            ++i;
        }
        rc[0] = (byte)(x % 26L + 65L);
        String car = new String(rc);
        return car;
    }

    public static String cambiaEstensione(String nomeFile, String nuovaEstensione) {
        int p = nomeFile.lastIndexOf(46);
        if (p < 0) {
            return nomeFile + "." + nuovaEstensione;
        }
        return nomeFile.substring(0, p) + "." + nuovaEstensione;
    }

    public static int compare(String s1, String s2) {
        int l2;
        int l1 = s1.length();
        if (l1 != (l2 = s2.length())) {
            return l1 > l2 ? l2 : l1;
        }
        int i = 0;
        while (i < l1) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int contaCampiPresenti(RecordParser rp, int[] codCampi) {
        int conta = 0;
        int i = 0;
        while (i < codCampi.length) {
            if (!Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                ++conta;
            }
            ++i;
        }
        return conta;
    }

    public static int contaCampiPresenti(RecordParser rp, int primo, int ultimo) {
        int conta = 0;
        while (primo <= ultimo) {
            if (!Util.isNonValorizzato(rp.prendiValore(primo))) {
                ++conta;
            }
            ++primo;
        }
        return conta;
    }

    public static int[] contaRec(Vector memoRec, int[] ctrRecZ) {
        Enumeration listaCampi = memoRec.elements();
        while (listaCampi.hasMoreElements()) {
            byte[] record = (byte[])listaCampi.nextElement();
            int i = record[0] - 65;
            if (i < 0 || i > 25) continue;
            int n = i;
            ctrRecZ[n] = ctrRecZ[n] + 1;
        }
        return ctrRecZ;
    }

    public static int contaValorizzati(String[] codici, Dichiarazione dic) {
        int cont = 0;
        int i = 0;
        while (i < codici.length) {
            if (dic.esisteCampo(codici[i])) {
                ++cont;
            }
            ++i;
        }
        return cont;
    }

    public static boolean controllaImposta(double dich, double calc) {
        boolean dichiaratoOK = true;
        if (calc <= 20.0) {
            if (dich != calc && dich != 0.0) {
                dichiaratoOK = false;
            }
        } else if (dich != calc) {
            dichiaratoOK = false;
        }
        return dichiaratoOK;
    }

    public static boolean controllaPeriodoImposta(String data1, String data2) {
        int giorno = 0;
        int mese = 0;
        int anno = 0;
        int giornomese = 0;
        giorno = Integer.parseInt(data2.substring(0, 2));
        mese = Integer.parseInt(data2.substring(2, 4));
        anno = Integer.parseInt(data2.substring(4, 6));
        switch (mese) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                giornomese = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                giornomese = 30;
                break;
            }
            case 2: {
                if (anno % 4 == 0 && anno != 1900) {
                    giornomese = 29;
                    break;
                }
                giornomese = 28;
                break;
            }
        }
        if (giorno == giornomese) {
            giorno = 1;
            if (mese == 12) {
                mese = 1;
                ++anno;
            } else {
                ++mese;
            }
        } else {
            ++giorno;
        }
        data2 = String.valueOf(Util.formNum(2, giorno)) + Util.formNum(2, mese) + Util.formNum(2, --anno);
        if ((String.valueOf(data1.substring(0, 2)) + data1.substring(2, 4)).equals("2902")) {
            return data2.equals("2802" + anno) || data2.equals("0103" + anno);
        }
        return data1.equals(data2);
    }

    public static boolean controllaStruttura(String f, String s) {
        if (f.length() != s.length()) {
            return false;
        }
        int i = 0;
        while (i < f.length()) {
            if (f.charAt(i) == 'C' && Character.isDigit(s.charAt(i))) {
                return false;
            }
            if (f.charAt(i) == 'N' && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean controlloCF(String s) {
        PIVA p;
        String cf = s.trim();
        if (cf.length() == 16) {
            CF c;
            char x = cf.charAt(11);
            boolean xFlag = false;
            if (x >= 'A' && x <= 'M' || x == 'Z') {
                xFlag = true;
            }
            if ((c = new CF(cf)).getCfCodiceRitorno() == 0 && Util.controllaStruttura("CCCCCCNN", cf.substring(0, 8)) && xFlag) {
                return true;
            }
        }
        return cf.length() == 11 && (p = new PIVA(cf, 'F')).getPIVACodiceRitorno() == 0;
    }

    public static boolean controlloData(String s) {
        DataSogei d = new DataSogei(s);
        return d.getOk();
    }

    public static boolean controlloMeseAnno(String data) {
        return Util.controlloMeseAnno(data, 1900, 2100);
    }

    public static boolean controlloMeseAnno(String data, int minAnno, int maxAnno) {
        int anno;
        if ((data = data.trim()).equals("0")) {
            return true;
        }
        if (data.length() != 6) {
            return false;
        }
        int mese = Integer.parseInt(data.substring(0, 2));
        if (mese + (anno = Integer.parseInt(data.substring(2, 6))) == 0) {
            return true;
        }
        return mese > 0 && mese < 13 && anno >= minAnno && anno <= maxAnno;
    }

    public static boolean controlloPI(String s) {
        PIVA p;
        String cf = s.trim();
        return cf.length() == 11 && (p = new PIVA(cf, 'I')).getPIVACodiceRitorno() == 0;
    }

    public static String convertiAccentate(String s) {
        s = Util.replaceString(s, "\u00c0", "A'");
        s = Util.replaceString(s, "\u00c8", "E'");
        s = Util.replaceString(s, "\u00cc", "I'");
        s = Util.replaceString(s, "\u00d2", "O'");
        s = Util.replaceString(s, "\u00d9", "U'");
        s = Util.replaceString(s, "\u00c9", "E'");
        return s;
    }

    public static String dateWithoutSlash(String date) {
        int firstSlash = date.indexOf("/");
        int lastSlash = date.lastIndexOf("/");
        String firstToken = date.substring(0, firstSlash);
        String secondToken = date.substring(firstSlash + 1, lastSlash);
        String thirdToken = date.substring(lastSlash + 1);
        return Util.formNum(2, firstToken) + Util.formNum(2, secondToken) + thirdToken;
    }

    public static boolean detectLowValueChars(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) < ' ') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(Dichiarazione dich, String quadro, String riga, String[] col, String modulo) {
        int i = 0;
        while (i < col.length) {
            if (dich.esisteCampo(quadro, riga, col[i], modulo)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(RecordParser rp, int[] codCampi) {
        int i = 0;
        while (i < codCampi.length) {
            if (!Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(RecordParser rp, int primo, int ultimo) {
        while (primo <= ultimo) {
            if (!Util.isNonValorizzato(rp.prendiValore(primo))) {
                return true;
            }
            ++primo;
        }
        return false;
    }

    public static boolean esisteCodAtt(String codatt) {
        boolean trovato = false;
        String[] codiceatt = new String[]{"01111", "01112", "01113", "01114", "01115", "01116", "01121", "01122", "01123", "01124", "01131", "01132", "01133", "01134", "01135", "01210", "01221", "01222", "01230", "01241", "01242", "01251", "01252", "01253", "01254", "01255", "01300", "0141A", "0141B", "01411", "01412", "01420", "01500", "02011", "02012", "02020", "05011", "05012", "05021", "05022", "05030", "10100", "10200", "10300", "11110", "11120", "11130", "11200", "12000", "13100", "13200", "14111", "14112", "14121", "14122", "14130", "14210", "14220", "14301", "14302", "14303", "14400", "14501", "14502", "14503", "15111", "15112", "15121", "15122", "15130", "15201", "15202", "15310", "15320", "15330", "15411", "15412", "15413", "15421", "15422", "15423", "15430", "15511", "15512", "15520", "15611", "15612", "15620", "15710", "15720", "15811", "15812", "15820", "15830", "15840", "15850", "15860", "15870", "15880", "15891", "15892", "15893", "15910", "15920", "15931", "15932", "15940", "15950", "15960", "15970", "15980", "15990", "16000", "17110", "17121", "17122", "17131", "17132", "17140", "17150", "17160", "17170", "17210", "17220", "17230", "17240", "17250", "17300", "17401", "17402", "17510", "17520", "17530", "17541", "17542", "17543", "17544", "17545", "17546", "17600", "17710", "17720", "17730", "17740", "17750", "18100", "18210", "18221", "18222", "18230", "18241", "18242", "18243", "18244", "1830A", "1830B", "19100", "19200", "19301", "19302", "19303", "20100", "20200", "20301", "20302", "20400", "20511", "20512", "20521", "20522", "21110", "21120", "21210", "21220", "21230", "21240", "21250", "22110", "22120", "22130", "22140", "22150", "22210", "22220", "22230", "22240", "22250", "22310", "22320", "22330", "23100", "23201", "23202", "23203", "23204", "23300", "24110", "24120", "24130", "24140", "24150", "24160", "24170", "24200", "24300", "24410", "24420", "24511", "24512", "24520", "24610", "24620", "24630", "24640", "24650", "24661", "24662", "24663", "24664", "24665", "24666", "24700", "25110", "25120", "25130", "25210", "25220", "25230", "25240", "26110", "26120", "26130", "26140", "26151", "26152", "26153", "26210", "26220", "26230", "26240", "26250", "26260", "26300", "26400", "26510", "26520", "26530", "26610", "26620", "26630", "26640", "26650", "26660", "26701", "26702", "26703", "26810", "26820", "27100", "27210", "27221", "27222", "27310", "27320", "27330", "27340", "27350", "27410", "27420", "27430", "27440", "27450", "27510", "27520", "27530", "27540", "28110", "28121", "28122", "28210", "28220", "28300", "28401", "28402", "28403", "28404", "28510", "28520", "28610", "28621", "28622", "28630", "28710", "28720", "28730", "28741", "28742", "28743", "28751", "28752", "28753", "28754", "28755", "28756", "29111", "29112", "29120", "29130", "29141", "29142", "29211", "29212", "29221", "29222", "29231", "29232", "29241", "29242", "29243", "29244", "29311", "29312", "29321", "29322", "29400", "29510", "29520", "29530", "29541", "29542", "29543", "29550", "29561", "29562", "29563", "29564", "29565", "29600", "29710", "29720", "30010", "30020", "31101", "31102", "31201", "31202", "31300", "31400", "31500", "31610", "31621", "31622", "32100", "32201", "32202", "32203", "32300", "33101", "33102", "33103", "33104", "33201", "33202", "33203", "33204", "33205", "33300", "33401", "33402", "33403", "33404", "33405", "33406", "33500", "34100", "34200", "34300", "35111", "35112", "35113", "35114", "35120", "35201", "35202", "35203", "35204", "35300", "35411", "35412", "35421", "35422", "35430", "35501", "35502", "36111", "36112", "36121", "36122", "36130", "36141", "36142", "36150", "36210", "36221", "36222", "36300", "36400", "36501", "36502", "36610", "36620", "36631", "36632", "36633", "36634", "36635", "36636", "37100", "37201", "37202", "40100", "40201", "40202", "40300", "41001", "41002", "45110", "45120", "45210", "45220", "45230", "45240", "45250", "45310", "45320", "45330", "45340", "45410", "45420", "45430", "45440", "45451", "45452", "45500", "50100", "50201", "50202", "50203", "50204", "50205", "50300", "50401", "50402", "50403", "5050A", "5050B", "51110", "51120", "51130", "51140", "51150", "51160", "51170", "51180", "51190", "51211", "51212", "51220", "51231", "51232", "51241", "51242", "51250", "51310", "51321", "51322", "51323", "51331", "51332", "51341", "51342", "51350", "51361", "51362", "51371", "51372", "51381", "51382", "5139A", "5139B", "51391", "51392", "51393", "5141A", "5141B", "51411", "51412", "51413", "5142B", "51421", "51422", "51423", "51424", "51425", "5143A", "5143B", "51431", "51432", "51433", "51434", "51435", "51441", "51442", "51443", "51444", "51445", "51450", "51461", "51462", "51471", "51472", "51473", "51474", "51475", "51476", "51477", "51478", "51479", "51511", "51512", "51513", "51521", "51522", "51523", "51524", "51531", "51532", "51533", "51534", "51535", "51541", "51542", "51543", "51544", "51550", "51561", "51562", "51571", "51572", "51573", "51610", "51620", "51630", "51641", "51642", "51650", "51660", "51700", "52111", "52112", "52113", "52114", "52115", "52121", "52122", "52210", "52221", "52222", "52230", "52241", "52242", "52250", "52260", "52271", "52272", "52273", "52122", "52210", "52221", "52222", "52230", "52241", "52242", "52250", "52260", "52271", "52272", "52273", "52274", "52310", "52320", "52331", "52332", "52411", "52412", "52413", "52414", "52421", "52422", "52423", "52424", "52425", "52426", "52431", "52432", "52441", "52442", "52443", "52444", "52445", "52451", "52452", "52453", "52454", "52455", "52461", "52462", "52463", "52464", "52465", "52466", "52471", "52472", "52473", "5248A", "5248B", "5248C", "5248D", "5248E", "5248F", "5248G", "5248H", "52481", "52482", "52483", "52484", "52485", "52486", "52487", "52488", "52501", "52502", "52503", "52504", "52610", "52621", "52622", "52623", "52624", "52625", "52626", "52627", "52631", "52632", "52633", "52634", "52635", "52710", "52720", "52730", "52740", "55110", "55120", "55211", "55212", "55220", "55231", "55232", "55233", "55234", "55235", "55236", "55301", "55302", "55303", "55304", "55305", "55401", "55402", "55403", "55404", "55510", "55520", "60101", "60102", "60210", "60220", "60230", "60240", "60250", "60301", "60302", "61110", "61120", "61200", "62100", "62200", "62300", "63111", "63112", "63113", "63121", "63122", "63210", "63220", "63230", "6330A", "6330B", "63301", "63401", "63402", "64110", "64120", "64200", "65110", "65121", "65122", "65123", "65210", "65221", "65222", "65231", "65232", "65233", "66010", "66020", "66030", "67110", "67120", "67130", "67201", "67202", "70110", "70120", "70200", "70310", "70320", "71100", "71210", "71220", "71230", "71310", "71320", "71330", "71340", "71401", "71402", "72100", "72200", "72300", "72400", "72500", "72601", "72602", "7310A", "7310B", "7310C", "7310D", "7310E", "7310F", "7310G", "7320A", "7320B", "7320C", "74111", "74112", "7412A", "7412B", "7412C", "7412D", "74122", "74123", "74130", "7414A", "7414B", "74141", "74142", "74144", "74145", "74146", "74150", "7420A", "7420B", "7420C", "7420D", "74201", "74202", "74203", "74204", "74205", "74301", "74302", "74401", "74402", "74500", "74601", "74602", "74701", "74702", "74811", "74812", "74813", "74821", "74822", "74831", "74832", "74833", "74834", "74835", "7484A", "7484B", "74841", "74842", "74843", "74844", "74845", "75111", "75112", "75121", "75122", "75123", "75124", "75131", "75132", "75133", "75134", "75135", "75136", "75137", "75140", "75210", "75220", "75230", "75240", "75250", "75300", "80101", "80102", "80211", "80212", "80220", "80301", "80302", "80303", "80410", "80421", "80422", "85111", "85112", "85113", "85114", "85115", "8512A", "8512B", "85121", "85122", "85124", "85125", "85126", "85127", "85130", "8514A", "8514B", "8514C", "8514D", "85141", "85142", "85144", "85200", "85310", "8532A", "8532B", "90001", "90002", "90003", "91111", "91112", "91113", "91120", "91200", "91310", "91320", "91330", "92110", "92120", "92130", "92200", "9231A", "9231B", "9231C", "9231D", "9231E", "9231F", "9231G", "92320", "92330", "92341", "92342", "92343", "92344", "9240A", "9240B", "9240C", "92510", "92520", "92530", "92611", "92612", "92613", "92614", "92615", "92616", "9262A", "9262B", "9262C", "92621", "92623", "92710", "92721", "92722", "93011", "93012", "93021", "93022", "93023", "93024", "93030", "93041", "93042", "93050", "95000", "99000"};
        int i = 0;
        while (i <= 931) {
            if (codatt.equals(codiceatt[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodiceConcessione(String cod) {
        boolean trovato = false;
        String[] codiceConc = new String[]{"001", "003", "005", "007", "008", "010", "012", "014", "016", "017", "019", "020", "021", "022", "024", "025", "027", "028", "030", "032", "033", "034", "035", "037", "039", "041", "043", "045", "047", "048", "050", "051", "052", "053", "054", "056", "057", "059", "061", "062", "063", "064", "066", "067", "068", "070", "071", "073", "074", "075", "077", "078", "079", "080", "082", "083", "085", "087", "089", "091", "092", "093", "094", "095", "096", "097", "099", "100", "102", "103", "104", "105", "106", "108", "109", "110", "112", "113", "114", "115", "117", "119", "121", "122", "124", "125", "132", "133", "134", "135", "136", "137", "138", "139", "291", "292", "293", "294", "295", "296", "297", "298", "299"};
        int i = 0;
        while (i <= 102) {
            if (cod.equals(codiceConc[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodiceEstero(String cod) {
        boolean trovato = false;
        String[] codice = new String[]{"A001", "B001", "B002", "B003", "C001", "D001", "D002", "D003", "D004", "D005", "D006", "D007", "D008", "D009", "D010", "E001", "F001", "G001", "G002", "G003", "H001", "H002", "H003", "6671", "6672", "6674", "6673", "6675", "6676", "6677", "6678", "0513", "0514", "0515", "0516", "0517", "0512", "0108", "0107", "0109", "6800", "6801", "6802", "6803", "0750", "0751", "6805", "6806", "6807", "6820", "6821", "6822", "6808", "6809", "6810", "6811", "6812", "6804", "6679", "6680", "6681", "6682", "6683", "6684", "6685", "1202", "1201", "1203", "1300", "1301", "1303", "1304", "1305", "1306", "6632", "6633", "6634", "6631", "1113", "1114", "1115", "6686", "6630", "6605", "6660", "6666", "6667", "6668", "6624", "6636", "6638", "6661", "6612", "6687", "6601", "6690", "6688", "6629", "6606", "6689", "6602", "6647", "6691", "0801", "0802", "0803", "6693", "6635", "6692", "6650", "1100", "1105", "1106", "1102", "1101", "1103", "1104", "1107", "1108", "1110", "1109", "1111", "1112", "6620", "6617", "6618", "6619", "0204", "0202", "0212", "0218", "0203", "0201", "0205", "0207", "0219", "0213", "0214", "0215", "0216", "0217", "0318", "0302", "0319", "0304", "0305", "0306", "0303", "0314", "0315", "0316", "0313", "0312", "0317", "0721", "0722", "0723", "0724", "0725", "0727", "0728", "0729", "0730", "0731", "0515", "0516", "0517", "0726", "0732", "0512", "0733", "Z001", "Z002", "Z003"};
        int i = 0;
        while (i <= 173) {
            if (cod.equals(codice[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodiceOperazioneEstero(String cod) {
        boolean trovato = false;
        String[] codiceOperazione = new String[]{"6671", "6672", "6673", "6674", "6675", "6676", "6677", "6678", "0107", "0108", "0109", "0201", "0202", "0203", "0204", "0205", "0207", "0212", "0213", "0214", "0215", "0216", "0217", "0218", "0219", "0302", "0303", "0304", "0305", "0306", "0312", "0313", "0314", "0315", "0316", "0317", "0318", "0319", "0512", "0513", "0514", "0515", "0516", "0517", "0721", "0722", "0723", "0724", "0725", "0726", "0727", "0728", "0729", "0730", "0731", "0732", "0733", "0750", "0751", "0801", "0802", "0803", "1100", "1101", "1102", "1103", "1104", "1105", "1106", "1107", "1108", "1109", "1110", "1111", "1112", "1113", "1114", "1115", "1201", "1202", "1203", "1300", "1301", "1303", "1304", "1305", "1306", "6601", "6602", "6605", "6606", "6612", "6617", "6618", "6619", "6620", "6624", "6629", "6630", "6631", "6632", "6633", "6634", "6635", "6636", "6638", "6647", "6650", "6660", "6661", "6666", "6667", "6668", "6679", "6680", "6681", "6682", "6683", "6684", "6685", "6686", "6687", "6688", "6689", "6690", "6691", "6692", "6693", "6800", "6801", "6802", "6803", "6804", "6805", "6806", "6807", "6808", "6809", "6810", "6811", "6812", "6820", "6821", "6822", "A001", "B001", "B002", "B003", "C001", "D001", "D002", "D003", "D004", "D005", "D006", "D007", "D008", "D009", "D010", "E001", "F001", "G001", "G002", "G003", "H001", "H002", "H003", "Z001", "Z002", "Z003"};
        int i = 0;
        while (i < codiceOperazione.length) {
            if (cod.equals(codiceOperazione[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodicePaeseEstero(String paese) {
        boolean trovato = false;
        String[] paeseEst = new String[]{"002", "003", "004", "005", "006", "007", "008", "009", "010", "011", "012", "013", "015", "016", "017", "018", "019", "020", "021", "022", "023", "024", "025", "026", "027", "028", "029", "031", "032", "033", "034", "035", "036", "037", "038", "039", "040", "041", "042", "043", "044", "045", "046", "047", "048", "049", "050", "051", "052", "053", "054", "055", "056", "057", "058", "059", "061", "062", "063", "064", "065", "066", "067", "068", "069", "070", "071", "072", "073", "074", "075", "076", "077", "078", "080", "081", "082", "083", "084", "085", "087", "088", "089", "090", "091", "092", "093", "094", "095", "097", "098", "100", "101", "102", "103", "104", "105", "106", "107", "109", "110", "112", "113", "114", "115", "116", "117", "118", "119", "120", "121", "122", "123", "124", "125", "126", "127", "128", "129", "130", "131", "132", "133", "134", "135", "136", "137", "138", "139", "141", "142", "143", "144", "145", "146", "147", "148", "149", "150", "151", "152", "153", "154", "155", "156", "157", "158", "159", "160", "161", "162", "163", "164", "166", "167", "168", "169", "175", "176", "177", "178", "180", "182", "183", "185", "186", "187", "188", "189", "190", "191", "192", "193", "194", "195", "196", "197", "198", "199", "200", "201", "202", "203", "204", "205", "206", "207", "208", "209", "210", "211", "212", "213", "214", "215", "216", "217", "218", "219", "220", "221", "222", "223", "225", "226", "227", "228", "229", "230", "231", "232", "233", "234", "235", "236", "237", "238", "239", "240", "241", "242", "243", "244", "245", "246", "247", "248", "249", "250", "251", "252", "253", "254", "255", "256", "257", "258", "259", "260", "261", "262", "263", "264", "265", "266", "267", "268", "269", "270", "271", "272", "273", "274", "275", "276", "277", "278", "279", "280", "281", "282", "283", "284", "285", "286", "287", "799"};
        int i = 0;
        while (i < paeseEst.length) {
            if (paese.equals(paeseEst[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esistenzaTuttiCampi(Dichiarazione dich, String quadro, String riga, String[] col, String modulo, boolean esistenza) {
        int i = 0;
        while (i < col.length) {
            if (esistenza && !dich.esisteCampo(quadro, riga, col[i], modulo)) {
                return false;
            }
            if (!esistenza && dich.esisteCampo(quadro, riga, col[i], modulo)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean esistenzaTuttiCampi(RecordParser rp, int[] codCampi, boolean esistenza) {
        int i = 0;
        while (i < codCampi.length) {
            if (esistenza && Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return false;
            }
            if (!esistenza && !Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean esistenzaTuttiCampi(RecordParser rp, int primo, int ultimo, boolean esistenza) {
        while (primo <= ultimo) {
            if (esistenza && Util.isNonValorizzato(rp.prendiValore(primo))) {
                return false;
            }
            if (!esistenza && !Util.isNonValorizzato(rp.prendiValore(primo))) {
                return false;
            }
            ++primo;
        }
        return true;
    }

    public static boolean esisteProvincia(String prov) {
        boolean trovato = false;
        String[] provincia = new String[]{"AG", "AL", "AN", "AO", "AR", "AP", "AT", "AV", "BA", "BL", "BN", "BG", "BO", "BZ", "BS", "BR", "CA", "CL", "CB", "CE", "CT", "CZ", "CH", "CO", "CS", "CR", "CN", "EN", "FE", "FI", "FG", "FO", "FR", "GE", "GO", "GR", "IM", "IS", "AQ", "SP", "LT", "LE", "LI", "LU", "MC", "MN", "OR", "MS", "MT", "ME", "MI", "MO", "NA", "NO", "NU", "PD", "PA", "BI", "PR", "PV", "PG", "PS", "PE", "PC", "PI", "PT", "PN", "PZ", "RG", "RA", "RC", "RE", "RI", "RM", "RO", "SA", "SS", "SV", "SI", "SR", "SO", "TA", "TE", "TR", "TO", "TP", "TN", "TV", "TS", "UD", "VA", "VE", "VC", "VR", "VI", "VT", "KR", "LC", "LO", "PO", "RN", "VB", "VV", "FM", "PL", "ZA", "FU", "EE", "FC", "PU"};
        int i = 0;
        while (i < provincia.length) {
            if (prov.equals(provincia[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static float fl(String st) {
        return Float.valueOf(st).floatValue();
    }

    public static String format(double valore) {
        String out = "";
        try {
            String s = String.valueOf(valore);
            if (s.substring(s.length() - 2, s.length()).equals(".0")) {
                int vi = (int)valore;
                out = String.valueOf(vi);
            } else if (s.indexOf("E") > 0) {
                long vl = (long)valore;
                out = String.valueOf(vl);
            } else {
                out = String.valueOf(valore).replace('.', ',');
            }
        }
        catch (Exception exception) {
            out = String.valueOf(valore).replace('.', ',');
        }
        return out;
    }

    public static String formattaN(String st) {
        String st1 = st.trim().replace(',', '.');
        try {
            new Float(st1);
        }
        catch (NumberFormatException numberFormatException) {
            st1 = "E" + st1;
            return st1;
        }
        return st1;
    }

    public static String formNum(int l, int i) {
        return Util.formNum(l, String.valueOf(i));
    }

    public static String formNum(int l, long i) {
        return Util.formNum(l, String.valueOf(i));
    }

    public static String formNum(int l, String si) {
        int li = si.length();
        if (li == l) {
            return si;
        }
        if (li < l) {
            char[] vchar = new char[l];
            int c = 0;
            while (c < l) {
                vchar[c] = c < l - li ? 48 : (int)si.charAt(c - (l - li));
                ++c;
            }
            return new String(vchar);
        }
        return si.substring(0, l);
    }

    public static String formStr(int l, String valore, char riemp) {
        int li;
        int lstr;
        String rc = "";
        if (valore == null) {
            valore = "";
        }
        if ((lstr = l - (li = valore.length())) == 0) {
            rc = valore;
        } else if (lstr > 0) {
            char[] vchar = new char[lstr];
            int i = 0;
            while (i < lstr) {
                vchar[i] = 32;
                ++i;
            }
            String bb = new String(vchar);
            if (riemp == 'R') {
                rc = String.valueOf(valore) + bb;
            }
            if (riemp == 'L') {
                rc = String.valueOf(bb) + valore;
            }
        } else {
            if (riemp == 'R') {
                rc = valore.substring(0, l);
            }
            if (riemp == 'L') {
                rc = valore.substring(li - l, li);
            }
        }
        return rc;
    }

    public static String getDataCorrente() {
        Date dateNow = new Date();
        SimpleDateFormat dfGiorno = new SimpleDateFormat("dd");
        SimpleDateFormat dfMese = new SimpleDateFormat("MM");
        SimpleDateFormat dfAnno = new SimpleDateFormat("yyyy");
        String data = String.valueOf(dfGiorno.format(dateNow)) + dfMese.format(dateNow) + dfAnno.format(dateNow);
        return data;
    }

    public static boolean isDiffMaggioreDi1(long a, long b) {
        return Math.abs(a - b) > 1L;
    }

    public static boolean isInside(double i, String s) {
        double p1 = 0.0;
        double p2 = 0.0;
        int ii = 0;
        while (ii < s.length()) {
            if (s.charAt(ii) == '-') {
                p1 = Util.valoreDouble(s.substring(0, ii));
                p2 = Util.valoreDouble(s.substring(ii + 1, s.length() - 1));
                break;
            }
            ++ii;
        }
        return p1 <= i && i <= p2;
    }

    public static boolean isInside(int i, String s) {
        Vector<Integer> v = new Vector<Integer>();
        int valore_in = 0;
        int valore_fin = 0;
        int valore = 0;
        char[] cfr_ignored_0 = new char[1];
        boolean trattino = false;
        int mem = 0;
        int ii = 0;
        while (ii < s.length()) {
            Integer Vint;
            char ch = s.charAt(ii);
            if (ch == '-') {
                trattino = true;
                Vint = new Integer(s.substring(mem, ii));
                valore_in = Vint;
                mem = ii + 1;
            }
            if (ch == ',') {
                Vint = new Integer(s.substring(mem, ii));
                if (trattino) {
                    valore_fin = Vint;
                    int sv = valore_in;
                    while (sv <= valore_fin) {
                        v.addElement(new Integer(sv));
                        ++sv;
                    }
                } else {
                    valore = Vint;
                    v.addElement(new Integer(valore));
                }
                trattino = false;
                mem = ii + 1;
            }
            ++ii;
        }
        boolean rc = false;
        Enumeration elem = v.elements();
        while (elem.hasMoreElements()) {
            if ((Integer)elem.nextElement() != i) continue;
            rc = true;
        }
        v = null;
        return rc;
    }

    public static boolean isInside(long i, String s) {
        Vector<Long> v = new Vector<Long>();
        long valore_in = 0L;
        long valore_fin = 0L;
        long valore = 0L;
        char[] cfr_ignored_0 = new char[1];
        boolean trattino = false;
        int mem = 0;
        int ii = 0;
        while (ii < s.length()) {
            Long Vlong;
            char ch = s.charAt(ii);
            if (ch == '-') {
                trattino = true;
                Vlong = new Long(s.substring(mem, ii));
                valore_in = Vlong;
                mem = ii + 1;
            }
            if (ch == ',') {
                Vlong = new Long(s.substring(mem, ii));
                if (trattino) {
                    valore_fin = Vlong;
                    long sv = valore_in;
                    while (sv <= valore_fin) {
                        v.addElement(new Long(sv));
                        ++sv;
                    }
                } else {
                    valore = Vlong;
                    v.addElement(new Long(valore));
                }
                trattino = false;
                mem = ii + 1;
            }
            ++ii;
        }
        boolean rc = false;
        Enumeration elem = v.elements();
        while (elem.hasMoreElements()) {
            if ((Long)elem.nextElement() != i) continue;
            rc = true;
        }
        v = null;
        return rc;
    }

    public static boolean isInside(String i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String elem = st.nextToken();
            if (!elem.equals(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonValorizzato(String valore) {
        String s = valore.trim();
        if (s.equals("")) {
            return true;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumericoAssoluto(String s) {
        if (s.length() == 0) {
            return false;
        }
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] < '0' || sArray[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        return (s = s.replace('\u00df', 'S')).toUpperCase().equals(s);
    }

    public static long lire2euro(double in) {
        return Util.lire2euro(in, true);
    }

    public static double lire2euro(double in, int decimali, boolean isMigliaia) {
        if (isMigliaia) {
            in *= 1000.0;
        }
        double ris = in / 1936.27;
        double divisore = Math.pow(10.0, decimali);
        return Util.arrotonda(1, ris * divisore) / divisore;
    }

    public static long lire2euro(double in, boolean isMigliaia) {
        return (long)Util.lire2euro(in, 0, isMigliaia);
    }

    public static String mills2Date(long theTime) {
        long ja;
        long julianDayOffset = 2440588L;
        int millisPerDay = 86400000;
        long gregorianCutover = -12219292800000L;
        long julian = 0L;
        julian = theTime >= 0L ? julianDayOffset + theTime / (long)millisPerDay : julianDayOffset + (theTime - (long)millisPerDay + 1L) / (long)millisPerDay;
        if (theTime >= gregorianCutover) {
            long jalpha = (long)(((double)(julian - 1867216L) - 0.25) / 36524.25);
            ja = julian + 1L + jalpha - (long)(0.25 * (double)jalpha);
        } else {
            ja = julian;
        }
        long jb = ja + 1524L;
        long jc = (long)Math.floor(6680.0 + ((double)(jb - 2439870L) - 122.1) / 365.25);
        long jd = (long)Math.floor((double)(365L * jc) + 0.25 * (double)jc);
        long je = (long)((double)(jb - jd) / 30.6001);
        int date = (int)(jb - jd - (long)(30.6001 * (double)je));
        int month = (int)je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = (int)(jc - 4715L);
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            year = 1 - year;
        }
        return date + "/" + month + "/" + year;
    }

    public static boolean numerico(String valore) {
        int ldopo;
        int lprima = Util.trimL(valore).length();
        if (lprima != (ldopo = Util.trimL(valore = valore.replace('-', ' ')).length()) && lprima - 1 != ldopo) {
            return false;
        }
        String v = Util.trimL(valore);
        if (v.equals("")) {
            return false;
        }
        if (v.length() == 1 && v.charAt(0) == ',') {
            return false;
        }
        if (v.charAt(0) == ',' || v.charAt(v.length() - 1) == ',') {
            return false;
        }
        if (v.indexOf(",") != v.lastIndexOf(",")) {
            return false;
        }
        char[] vchar = new char[v.length()];
        v.getChars(0, v.length(), vchar, 0);
        int i = 0;
        boolean out = true;
        while (out && i < v.length()) {
            if ((vchar[i] < '0' || vchar[i] > '9') && vchar[i] != ',') {
                out = false;
            }
            ++i;
        }
        return out;
    }

    public static boolean numericoTrim(String valore) throws NumberFormatException {
        try {
            valore = valore.trim();
            if (Double.valueOf(Util.trimL(valore).replace(',', '.')) == 0.0) {
                return Util.trimL(valore).indexOf(" ") == -1 && Util.trimL(valore).indexOf("=") == -1;
            }
            Double.valueOf(Util.trimL(valore).replace(',', '.')).doubleValue();
            return Util.trimL(valore).indexOf(" ") == -1 && Util.trimL(valore).indexOf("=") == -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String[] ordinaArray(String[] array, boolean az) {
        boolean cicla = true;
        while (cicla) {
            cicla = false;
            int i = 0;
            while (i < array.length - 1) {
                boolean bl = az ? array[i].compareTo(array[i + 1]) > 0 : array[i].compareTo(array[i + 1]) < 0;
                if (bl) {
                    String appo = array[i];
                    array[i] = array[i + 1];
                    array[i + 1] = appo;
                    cicla = true;
                }
                ++i;
            }
        }
        return array;
    }

    public static void ottimizzaRigheInLista(Dichiarazione dich, String quadro, int daRiga, int aRiga, String[] indCols) {
        Vector vCampi = null;
        Vector<Campo[]> tabRighe = new Vector<Campo[]>();
        Campo[] recRiga = new Campo[indCols.length];
        int imod = 0;
        int molteplicita = aRiga - daRiga + 1;
        while (!(vCampi = dich.ricavaCampi(quadro, null, null, Util.formNum(8, ++imod), true)).isEmpty()) {
            int lastRiga = -1;
            int c = 0;
            while (c < vCampi.size()) {
                Campo campo = (Campo)vCampi.elementAt(c);
                int currRiga = Integer.parseInt(campo.getRiga());
                if (currRiga >= daRiga && currRiga <= aRiga) {
                    String currCol = campo.getColonna();
                    int icol = -1;
                    int ic = 0;
                    while (ic < indCols.length) {
                        if (indCols[ic].equals(currCol)) {
                            icol = ic;
                        }
                        ++ic;
                    }
                    if (icol != -1) {
                        if (currRiga > lastRiga) {
                            int rr = 0;
                            while (rr < recRiga.length) {
                                if (recRiga[rr] != null) {
                                    tabRighe.addElement(recRiga);
                                    break;
                                }
                                ++rr;
                            }
                            recRiga = new Campo[indCols.length];
                            lastRiga = currRiga;
                        }
                        recRiga[icol] = campo;
                        dich.eliminaCampo(campo);
                    }
                }
                ++c;
            }
        }
        int rr = 0;
        while (rr < recRiga.length) {
            if (recRiga[rr] != null) {
                tabRighe.addElement(recRiga);
                break;
            }
            ++rr;
        }
        int r = 0;
        while (r < tabRighe.size()) {
            recRiga = (Campo[])tabRighe.elementAt(r);
            int rr2 = 0;
            while (rr2 < recRiga.length) {
                if (recRiga[rr2] != null) {
                    String nuovoCod = String.valueOf(quadro) + Util.formNum(3, daRiga + r % molteplicita) + Util.formNum(3, indCols[rr2]) + Util.formNum(8, r / molteplicita + 1);
                    dich.scriviValoreCampo(nuovoCod, recRiga[rr2].getValore());
                }
                ++rr2;
            }
            ++r;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void quickSort(CollationKey[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo].compareTo(mid) < 0) continue block0;
                    while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    Util.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                Util.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Util.quickSort(a, lo, hi0);
            }
        }
    }

    public static String replaceString(String in, String da, String a) {
        int position = in.indexOf(da);
        String out = "";
        out = position >= 0 ? in.substring(0, position) + a + Util.replaceString(in.substring(position + da.length(), in.length()), da, a) : in;
        return out;
    }

    public static double restituisciValoreIntervallo(double valore, double[] tabella, double[] risultato) {
        int i = 0;
        while (i < tabella.length) {
            if (valore <= tabella[i]) {
                return risultato[i];
            }
            ++i;
        }
        return risultato[risultato.length - 1];
    }

    public static void sort(String[] dirList) {
        if (dirList != null && dirList.length > 0) {
            Collator collator = Collator.getInstance();
            CollationKey[] keys = new CollationKey[dirList.length];
            int i = 0;
            while (i < dirList.length) {
                keys[i] = collator.getCollationKey(dirList[i]);
                ++i;
            }
            Util.quickSort(keys, 0, dirList.length - 1);
            i = 0;
            while (i < dirList.length) {
                dirList[i] = keys[i].getSourceString();
                ++i;
            }
        }
    }

    public static void substituteString(char[] in, String r, int offset) {
        char[] a = r.toCharArray();
        if (offset + r.length() > in.length) {
            throw new StringIndexOutOfBoundsException(offset + r.length());
        }
        int i = offset;
        while (i < offset + a.length) {
            in[i] = r.charAt(i - offset);
            ++i;
        }
    }

    private static void swap(CollationKey[] a, int i, int j) {
        CollationKey T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public static String trimL(String s) {
        int len = s.length();
        int st = 0;
        char[] value = s.toCharArray();
        while (st < len && value[st] <= ' ') {
            ++st;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static String trimR(String s) {
        int len = s.length();
        int st = 0;
        char[] value = s.toCharArray();
        while (st < len && value[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static double valoreDouble(String valore) {
        double numD = 0.0;
        try {
            String str = new String();
            str = Util.trimL(valore).replace(',', '.');
            numD = Double.valueOf(str);
        }
        catch (Exception exception) {
            System.out.println("Errore nel metodo valoreDouble Stringa:" + valore);
        }
        return numD;
    }

    public static int valoreInt(String valore) {
        int numI = 0;
        try {
            numI = Integer.valueOf(Util.trimL(valore));
        }
        catch (Exception exception) {
            System.out.println("Errore nel metodo valoreInt Stringa:" + valore);
        }
        return numI;
    }

    public static String versionWithoutPoint(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        st.countTokens();
        String token = "";
        while (st.hasMoreTokens()) {
            String appTok = Util.formNum(2, st.nextToken());
            token = String.valueOf(token) + appTok;
        }
        if (token.length() < 5) {
            token = String.valueOf(token) + Util.formNum(6 - token.length(), "");
        }
        return token;
    }
}

