/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.cms.Utils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncapsulatedContentInfo
extends EncapsulatedContentInfoStream {
    private byte[] a;

    public void writeTo(OutputStream outputStream) throws CMSException, IOException {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.contentType_.getName() + " \n");
        if (this.a != null) {
            stringBuffer.append(String.valueOf(this.a.length) + " bytes");
            if (bl) {
                stringBuffer.append(": " + Util.toString((byte[])this.a, (int)0, (int)15));
                if (this.a.length > 15) {
                    stringBuffer.append("...");
                }
            }
        } else {
            stringBuffer.append("No content!");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() throws CMSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws CMSException {
        if (this.contentType_ == null) {
            throw new CMSException("Cannot create ASN.1 object of CMS EncapsulatedContentInfo. At least the content type must be set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(this.blockSize_ > 0);
        sEQUENCE.addComponent((ASN1Object)this.contentType_);
        if (this.a != null) {
            OCTET_STRING oCTET_STRING = this.blockSize_ > 0 ? new OCTET_STRING(this.a, this.blockSize_) : new OCTET_STRING(this.a);
            CON_SPEC cON_SPEC = new CON_SPEC(0, (ASN1Object)oCTET_STRING);
            cON_SPEC.setIndefiniteLength(this.blockSize_ > 0);
            sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        }
        return sEQUENCE;
    }

    void a(byte[] byArray) {
        this.a = byArray;
    }

    public boolean hasContent() {
        return this.a != null;
    }

    public ObjectID getContentType() {
        return this.contentType_;
    }

    public InputStream getContentInputStream() {
        if (this.a == null) {
            return null;
        }
        return new ByteArrayInputStream(this.a);
    }

    public byte[] getContent() {
        return this.a;
    }

    protected void decode(DerInputStream derInputStream) throws CMSParsingException, IOException {
        super.decode(derInputStream);
        if (this.contentData_ != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            Utils.copyStream(this.contentData_, byteArrayOutputStream, null);
            this.a = byteArrayOutputStream.toByteArray();
        }
    }

    public EncapsulatedContentInfo(byte[] byArray, ObjectID objectID) {
        this();
        this.a = byArray;
        this.contentType_ = objectID;
    }

    public EncapsulatedContentInfo(InputStream inputStream) throws CMSParsingException, IOException {
        this();
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
            return;
        }
        this.decode(new DerInputStream(inputStream));
    }

    public EncapsulatedContentInfo(ObjectID objectID) {
        this();
        this.contentType_ = objectID;
        this.a = null;
    }

    public EncapsulatedContentInfo(ASN1Object aSN1Object) throws CMSParsingException {
        this();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object));
        try {
            this.decode(new DerInputStream((InputStream)byteArrayInputStream));
            return;
        }
        catch (IOException iOException) {
            throw new InternalErrorException("Error form ByteArrayInputStream!", (Exception)iOException);
        }
    }

    protected EncapsulatedContentInfo() {
        this.blockSize_ = -1;
    }
}

