/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.EncryptedData;
import iaik.cms.EncryptedDataStream;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;

public class CMSEncryptedData {
    SecureRandom random;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nEncryptedDataStream demo [create]:\n");
            byte[] byArray3 = this.createEncryptedDataStream(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nEncryptedDataStream demo [parse]:\n");
            byArray2 = this.getEncryptedDataStream(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nEncryptedData demo [create]:\n");
            byArray3 = this.createEncryptedData(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nEncryptedData demo [parse]:\n");
            byArray2 = this.getEncryptedData(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new CMSEncryptedData().start();
        System.in.read();
    }

    public byte[] getEncryptedDataStream(byte[] byArray, char[] cArray) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EncryptedDataStream encryptedDataStream = new EncryptedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = encryptedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        try {
            encryptedDataStream.setupCipher(cArray);
            InputStream inputStream = encryptedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Invalid Parameters: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Content encryption algorithm not implemented: " + invalidParameterSpecException.getMessage());
        }
    }

    public byte[] getEncryptedData(byte[] byArray, char[] cArray) throws IOException, CMSException {
        EncryptedData encryptedData = new EncryptedData((InputStream)new ByteArrayInputStream(byArray));
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        try {
            encryptedData.setupCipher(cArray);
            return encryptedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Invalid Parameters: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Content encryption algorithm not implemented: " + invalidParameterSpecException.getMessage());
        }
    }

    public byte[] createEncryptedDataStream(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, CMSException {
        EncryptedDataStream encryptedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            encryptedDataStream = new EncryptedDataStream((InputStream)byteArrayInputStream, 2048);
            encryptedDataStream.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        encryptedDataStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEncryptedData(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, CMSException {
        EncryptedData encryptedData;
        try {
            encryptedData = new EncryptedData(byArray);
            encryptedData.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        return encryptedData.getEncoded();
    }

    public CMSEncryptedData() {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           CMSEncryptedData demo                                *");
        System.out.println("*        (shows the usage of the CMS EncryptedData type implementation)          *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.random = SecRandom.getDefault();
    }
}

