/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl;

import iaik.asn1.CodingException;
import iaik.tsp.TimeStampReq;
import iaik.tsp.transport.http.TspHttpClient;
import iaik.tsp.transport.http.TspHttpResponse;
import iaik.xml.crypto.xades.impl.TSPTimeStampProcessor;
import iaik.xml.crypto.xades.timestamp.TimeStampException;
import iaik.xml.crypto.xades.timestamp.TimeStampProcessor;
import iaik.xml.crypto.xades.timestamp.TimeStampToken;
import iaik.xml.crypto.xades.timestamp.impl.TSPTimeStampTokenImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.crypto.OctetStreamData;

public class HTTPTSPTimeStampProcessor
extends TSPTimeStampProcessor
implements TimeStampProcessor {
    protected URL url_;

    public TimeStampToken timeStamp(OctetStreamData octetStreamData) throws TimeStampException {
        TspHttpResponse tspHttpResponse;
        TimeStampReq timeStampReq;
        TspHttpClient tspHttpClient;
        try {
            tspHttpClient = new TspHttpClient(this.url_);
            timeStampReq = this.createTimeStampReq(this.calculateMessageImprint(octetStreamData));
            tspHttpResponse = tspHttpClient.sendRequest(timeStampReq);
        }
        catch (IOException iOException) {
            throw new TimeStampException("Failed to receive time-stamp, " + iOException.getMessage());
        }
        catch (CodingException codingException) {
            throw new TimeStampException("Failed to receive time-stamp, " + codingException.getMessage());
        }
        if (tspHttpResponse.isErrorResponse()) {
            throw new TimeStampException("Failed to receive time-stamp, " + tspHttpResponse.getErrorMsg());
        }
        tspHttpClient = tspHttpResponse.getTimeStampResp();
        timeStampReq = tspHttpClient.getTimeStampToken();
        if (timeStampReq == null) {
            throw new TimeStampException("Failed to receive time-stamp, " + tspHttpClient.getPKIStatusInfo().getPKIFailureInfo().getFailureInfo());
        }
        return new TSPTimeStampTokenImpl((iaik.tsp.TimeStampToken)timeStampReq);
    }

    public HTTPTSPTimeStampProcessor(String string) throws MalformedURLException {
        this.url_ = new URL(string);
    }
}

