/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import sun.nio.fs.LinuxFileSystem;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class LinuxFileStore
extends UnixFileStore {
    private volatile boolean xattrChecked;
    private volatile boolean xattrEnabled;

    LinuxFileStore(UnixPath unixPath) throws IOException {
        super(unixPath);
    }

    LinuxFileStore(UnixFileSystem unixFileSystem, UnixMountEntry unixMountEntry) throws IOException {
        super(unixFileSystem, unixMountEntry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        Object object;
        Object object2;
        LinuxFileSystem linuxFileSystem = (LinuxFileSystem)this.file().getFileSystem();
        Object object3 = null;
        try {
            object2 = UnixNativeDispatcher.realpath(this.file());
            object3 = new UnixPath((UnixFileSystem)linuxFileSystem, (byte[])object2);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file());
        }
        for (object2 = (Object)((UnixPath)object3).getParent(); object2 != null; object2 = ((UnixPath)object2).getParent()) {
            object = null;
            try {
                object = UnixFileAttributes.get((UnixPath)object2, true);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException((UnixPath)object2);
            }
            if (((UnixFileAttributes)object).dev() != this.dev()) break;
            object3 = object2;
        }
        object = ((UnixPath)object3).asByteArray();
        for (UnixMountEntry unixMountEntry : linuxFileSystem.getMountEntries("/proc/mounts")) {
            if (!Arrays.equals((byte[])object, unixMountEntry.dir())) continue;
            return unixMountEntry;
        }
        throw new IOException("Mount point not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExtendedAttributesEnabled(UnixPath unixPath) {
        try {
            int n = unixPath.openForAttributeAccess(false);
            try {
                LinuxNativeDispatcher.fgetxattr(n, "user.java".getBytes(), 0L, 0);
                boolean bl = true;
                return bl;
            }
            catch (UnixException unixException) {
                if (unixException.errno() != 61) return false;
                boolean bl2 = true;
                return bl2;
            }
            finally {
                UnixNativeDispatcher.close(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        if (clazz == DosFileAttributeView.class || clazz == UserDefinedFileAttributeView.class) {
            UnixFileStore.FeatureStatus featureStatus = this.checkIfFeaturePresent("user_xattr");
            if (featureStatus == UnixFileStore.FeatureStatus.PRESENT) {
                return true;
            }
            if (featureStatus == UnixFileStore.FeatureStatus.NOT_PRESENT) {
                return false;
            }
            if (this.entry().hasOption("user_xattr")) {
                return true;
            }
            if (this.entry().fstype().equals("ext3") || this.entry().fstype().equals("ext4")) {
                return false;
            }
            if (!this.xattrChecked) {
                UnixPath unixPath = new UnixPath(this.file().getFileSystem(), this.entry().dir());
                this.xattrEnabled = this.isExtendedAttributesEnabled(unixPath);
                this.xattrChecked = true;
            }
            return this.xattrEnabled;
        }
        return super.supportsFileAttributeView(clazz);
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        if (string.equals("dos")) {
            return this.supportsFileAttributeView(DosFileAttributeView.class);
        }
        if (string.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return super.supportsFileAttributeView(string);
    }
}

