/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.RSACipher;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.InternalErrorException;
import iaik.utils.NumberTheory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;

public class RSAPrivateKey
extends PrivateKeyInfo
implements Serializable,
RSAPrivateCrtKey {
    private BigInteger j;
    private BigInteger g;
    private BigInteger h;
    private BigInteger e;
    private BigInteger f;
    private BigInteger d;
    private BigInteger b;
    private BigInteger i;
    int a;
    private transient ASN1 c;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getAlgorithm()) + " private key (" + this.i.bitLength() + " bits):\n");
        stringBuffer.append("modulus: " + this.i.toString(16) + "\n");
        stringBuffer.append("public exponent: " + this.b.toString(16) + "\n");
        stringBuffer.append("private exponent: " + this.d.toString(16) + "\n");
        stringBuffer.append("primeP: " + this.f.toString(16) + "\n");
        stringBuffer.append("primeQ: " + this.e.toString(16) + "\n");
        stringBuffer.append("primeExponentP: " + this.h.toString(16) + "\n");
        stringBuffer.append("primeExponentQ: " + this.g.toString(16) + "\n");
        stringBuffer.append("crt_coefficient: " + this.j.toString(16) + "\n");
        return stringBuffer.toString();
    }

    public static RSAPrivateKey parse(byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        rSAPrivateKey.decode(byArray);
        rSAPrivateKey.a(true);
        return rSAPrivateKey;
    }

    void a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.d = bigInteger3;
        this.b = bigInteger2;
        this.i = bigInteger;
        this.f = bigInteger4;
        this.e = bigInteger5;
        this.h = bigInteger6;
        this.g = bigInteger7;
        this.j = bigInteger8;
    }

    void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a(bigInteger, NumberTheory.ZERO, bigInteger2, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO);
    }

    public int hashCode() {
        return this.i.hashCode() ^ this.b.hashCode() ^ this.d.hashCode() ^ this.f.hashCode() ^ this.e.hashCode() ^ this.h.hashCode() ^ this.g.hashCode() ^ this.j.hashCode();
    }

    public PublicKey getPublicKey() {
        return new RSAPublicKey(this.i, this.b);
    }

    public BigInteger getPublicExponent() {
        return this.b;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public BigInteger getPrimeQ() {
        return this.e;
    }

    public BigInteger getPrimeP() {
        return this.f;
    }

    public BigInteger getPrimeExponentQ() {
        return this.g;
    }

    public BigInteger getPrimeExponentP() {
        return this.h;
    }

    public BigInteger getModulus() {
        return this.i;
    }

    public BigInteger getCrtCoefficient() {
        return this.j;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] encode() {
        return this.c.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.a = ((BigInteger)this.c.getComponentAt(0).getValue()).intValue();
            this.i = (BigInteger)this.c.getComponentAt(1).getValue();
            this.b = (BigInteger)this.c.getComponentAt(2).getValue();
            this.d = (BigInteger)this.c.getComponentAt(3).getValue();
            this.f = (BigInteger)this.c.getComponentAt(4).getValue();
            this.e = (BigInteger)this.c.getComponentAt(5).getValue();
            this.h = (BigInteger)this.c.getComponentAt(6).getValue();
            this.g = (BigInteger)this.c.getComponentAt(7).getValue();
            this.j = (BigInteger)this.c.getComponentAt(8).getValue();
            return;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No RSA Private Key: " + exception.toString());
        }
    }

    public BigInteger crypt(BigInteger bigInteger) {
        return new RSACipher().rawPrivateRSA(bigInteger, this, null);
    }

    void a(boolean bl) {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(new INTEGER(this.i));
            sEQUENCE.addComponent(new INTEGER(this.b));
            sEQUENCE.addComponent(new INTEGER(this.d));
            sEQUENCE.addComponent(new INTEGER(this.f));
            sEQUENCE.addComponent(new INTEGER(this.e));
            sEQUENCE.addComponent(new INTEGER(this.h));
            sEQUENCE.addComponent(new INTEGER(this.g));
            sEQUENCE.addComponent(new INTEGER(this.j));
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        if (bl) {
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            this.createPrivateKeyInfo();
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public RSAPrivateKey(RSAPrivateKeySpec rSAPrivateKeySpec) {
        if (rSAPrivateKeySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)rSAPrivateKeySpec;
            this.a(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        } else {
            this.a(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        this.a(true);
    }

    public RSAPrivateKey(java.security.interfaces.RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            this.a(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        } else {
            this.a(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
        }
        this.a(true);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        this.a(true);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, NumberTheory.ZERO, bigInteger2, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO);
    }

    public RSAPrivateKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public RSAPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    protected RSAPrivateKey() {
    }
}

