/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdh;

import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.interfaces.ECDSAPrivateKey;
import iaik.security.ecc.interfaces.ECDSAPublicKey;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.spec.ECCParameterSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class ECDH
extends KeyAgreementSpi {
    protected boolean withCoFactor_;
    protected byte[] secret_;
    protected ECDSAPrivateKey privateKey_;
    protected ECDSAParams parameter_;

    protected boolean equalParameters(ECDSAParams eCDSAParams, ECDSAParams eCDSAParams2) {
        if (eCDSAParams.getK() != null && eCDSAParams2.getK() != null && !eCDSAParams.getK().equals(eCDSAParams2.getK())) {
            return false;
        }
        if (!eCDSAParams.getG().equals(eCDSAParams2.getG())) {
            return false;
        }
        return eCDSAParams.getR().equals(eCDSAParams2.getR());
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ECDSAPrivateKey)) {
            throw new InvalidKeyException("Not an ec key");
        }
        this.privateKey_ = (ECDSAPrivateKey)key;
        this.parameter_ = this.privateKey_.getParameter();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECDSAPrivateKey)) {
            throw new InvalidKeyException("Not an ec key");
        }
        this.privateKey_ = (ECDSAPrivateKey)key;
        try {
            if (algorithmParameterSpec instanceof ECCParameterSpec) {
                ECCParameterSpec eCCParameterSpec = (ECCParameterSpec)algorithmParameterSpec;
                this.parameter_ = new ECDSAParameter(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId()));
                return;
            }
        }
        catch (ECCException eCCException) {
            // empty catch block
        }
        throw new InvalidAlgorithmParameterException("no ecc parameters");
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secret_, string);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            return secretKeyFactory.generateSecret(secretKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Invalid key: " + invalidKeySpecException.toString());
        }
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (byArray.length - n < this.secret_.length) {
            throw new ShortBufferException("Output buffer is to small for holding the secret.");
        }
        System.arraycopy(this.secret_, 0, byArray, n, this.secret_.length);
        return this.secret_.length;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.secret_;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (key instanceof ECDSAPublicKey) {
            Object object;
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)key;
            ECDSAParams eCDSAParams = eCDSAPublicKey.getParameter();
            if (this.parameter_ == null) {
                this.parameter_ = eCDSAParams;
            } else if (eCDSAParams != null) {
                if (!this.equalParameters(eCDSAParams, this.parameter_)) {
                    throw new InvalidKeyException("Different domain parameters");
                }
            } else {
                throw new InvalidKeyException("private key without domain parameters");
            }
            BigInteger bigInteger = this.privateKey_.getS();
            if (this.withCoFactor_) {
                object = this.parameter_.getK();
                if (object == null) {
                    throw new InvalidKeyException("co factor not defined");
                }
                bigInteger.multiply((BigInteger)object);
            }
            object = eCDSAPublicKey.getW();
            ((ECPoint)object).multiply(bigInteger);
            if (bl) {
                this.secret_ = ((ECPoint)object).getCoordinates().toAffine().getX().toByteArray();
                return null;
            }
            return new ECPublicKey(eCDSAParams, (ECPoint)object);
        }
        throw new InvalidKeyException("Not an ec public key");
    }

    protected ECDH(boolean bl) {
        this.withCoFactor_ = bl;
    }

    public ECDH() {
        this(false);
    }
}

