/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSPrimitiveValueImpl;
import com.sun.webpane.webkit.dom.CSSValueListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class CSSValueImpl
implements CSSValue {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;
    public static final int CSS_INHERIT = 0;
    public static final int CSS_PRIMITIVE_VALUE = 1;
    public static final int CSS_VALUE_LIST = 2;
    public static final int CSS_CUSTOM = 3;

    CSSValueImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static CSSValue create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        switch (CSSValueImpl.getCssValueTypeImpl(peer)) {
            case 1: {
                return new CSSPrimitiveValueImpl(peer, contextPeer, rootPeer);
            }
            case 2: {
                return new CSSValueListImpl(peer, contextPeer, rootPeer);
            }
        }
        return new CSSValueImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(CSSValue arg) {
        return arg == null ? 0L : ((CSSValueImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof CSSValueImpl && this.peer == ((CSSValueImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static CSSValue getImpl(long peer, long contextPeer, long rootPeer) {
        return CSSValueImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public String getCssText() {
        return CSSValueImpl.getCssTextImpl(this.getPeer());
    }

    static native String getCssTextImpl(long var0);

    @Override
    public void setCssText(String value) throws DOMException {
        CSSValueImpl.setCssTextImpl(this.getPeer(), value);
    }

    static native void setCssTextImpl(long var0, String var2);

    @Override
    public short getCssValueType() {
        return CSSValueImpl.getCssValueTypeImpl(this.getPeer());
    }

    static native short getCssValueTypeImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            CSSValueImpl.dispose(this.peer);
        }
    }
}

