/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.StyleConverter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javafx.scene.text.Font;

public final class EnumConverter<T extends Enum<T>>
extends StyleConverter<String, T> {
    private final Class enumClass;

    public EnumConverter(Class clazz) {
        this.enumClass = clazz;
    }

    @Override
    public T convert(ParsedValue<String, T> parsedValue, Font font) {
        if (this.enumClass == null) {
            return null;
        }
        String string = parsedValue.getValue();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        try {
            string = string.replace('-', '_');
            return Enum.valueOf(this.enumClass, string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Enum.valueOf(this.enumClass, string);
        }
    }

    @Override
    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        super.writeBinary(dataOutputStream, stringStore);
        int n = stringStore.addString(this.enumClass.getName());
        dataOutputStream.writeShort(n);
    }

    public EnumConverter(DataInputStream dataInputStream, String[] stringArray) {
        Class<?> clazz = null;
        try {
            short s = dataInputStream.readShort();
            String string = stringArray[s];
            clazz = Class.forName(string);
        }
        catch (IOException iOException) {
            System.err.println("EnumConveter caught: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("EnumConveter caught: " + classNotFoundException.toString());
        }
        this.enumClass = clazz;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EnumConverter)) {
            return false;
        }
        return this.enumClass.equals(((EnumConverter)object).enumClass);
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    public String toString() {
        return "EnumConveter[" + this.enumClass.getName() + "]";
    }
}

