;============================================================================
; File: y2kfix.asm
; Created:   01-Feb-2000
;
; Revisions:
;  Fri 02-04-00 10:28:36 jplc v1.0a -  optimized code. com file size = 364b
;     Decreased size from 432 bytes to the ff:
;     Segment  Region       Total        Type
;      0B15C       1         32    (0K)  Environment
;      0DF47       2        384    (0K)  Program
;     Total Size:           416    (0K)
;  Fri 02-04-00 19:41:44 jplc v1.1a - further decreased com file size to
;     309 bytes. Zapped the environment.
;     Segment  Region       Total        Type
;      0E73E       3        384    (0K)  Program
;     Total Size:           384    (0K)
;  Sat 02-05-00 14:59:39 jplc v1.2 - even further decreased com file size to
;     259 bytes, then to 257 bytes. Heck it's just the text.
;  Sun 09-03-00 03:55:43 jplc v1.3 - Firt release under GNU GPL.
;============================================================================
.386p
.387

codesg  segment byte public use16    ; Declare the start of the code segment
        assume  cs:codesg, ds:codesg ; Set up cs & ds for access
        org 100h          ; Make it a COM program
y2k_prog:
    jmp short Init        ; Self Explanatory
    nop                   ; Why is this here? It's required.
                          ; Leaving it out hangs the system.
;============================================================================
; Old int vect offset storage
; The first dword holds the segment, (cs register), and the second holds the
;  offset, (ip register), to the replaced interrupt vector
;============================================================================
old_int1c_add dw  0, 0    

;============================================================================
; check_y2k is the actual routine that stays in memory. It determines if
; the current date and time combination needs special handling and if so
; manipulates the date and time before giving it up to DOS.
;============================================================================
check_y2k proc far
    pushf                 ; Push flags
    cli                   ; Disable interrupts
    call dword ptr cs:old_int1c_add ; use the original
    push  ds              ;  procedure
    push  cs
    pop ds
    cmp [tmp_var], 0
    jne short pop_ds      ; Restore ds and exit
    mov [tmp_var], 1
    sti                   ; Enable interrupts
    push  ax              ; Save data in all registers
    push  bx              ; except for fs & gs
    push  cx
    push  dx
    push  si
    push  di
    push  bp
    push  es

                          ; Real time clock   ah=func 02h
    mov ah, 2             ;  read clock cx=hrs/min, dh=sec
    int 1Ah               ;   dl=0 standrd,=1 daylight sav
    cmp cx, 2359h         ; cx == 23 hours, 59 minutes ?
    jne short pop_regs    ; Restore registers and exit
    cmp dh, 59h           ; dh == 59 seconds ?
    jne short pop_regs    ; Restore registers and exit

    mov ah, 4             ; Real time clock   ah=func 04h
    int 1Ah               ;  get date  cx=year, dx=mon/day
    cmp cx, 1999h         ; cx == 1999 ?
    jne short chk_cen     ; Restore registers and exit
    cmp dx, 1231h         ; dx == Dec 31 ?
    jne short pop_regs    ; Restore registers and exit

chk_cen:
    mov ah, 4             ; Real time clock   ah=func 04h
    int 1Ah               ;  get date  cx=year, dx=mon/day
    cmp ch, 19h           ; ch == 19?
    jne short pop_regs    ; Restore registers and exit

    mov ah, 5
    mov ch, 20h           ; Real time clock   ah=func 05h
    int 1Ah               ;  set date  cx=year, dx=mon/day

    mov ah, 3             ; Real time clock   ah=func 03h
    xor cx, cx            ;  set clock cx=hrs/min - saves a byte
    xor dx, dx            ; dh=sec,dl=0 standrd,=1 daylight sav - saves a byte
    int 1Ah               ; dec .com size to 257 bytes due to above 2 lines

    mov ah, 5             ; Real time clock   ah=func 05h
    mov cx, 2000h         ;  set date  cx=year
    mov dx, 0101h         ; dx=mon/day
    int 1Ah

    mov ah, 2Ah           ; DOS Services  ah=function 2Ah
    int 21h               ;  get date, cx=year, dh=month
                          ;   dl=day, al=day-of-week 0=SUN
    mov ah, 2Bh           ; DOS Services  ah=function 2Bh
    mov cx, 7D0h          ;  cx == 2000d, dx == as is
    int 21h               ;  set date, cx=year, dx=mon/day

pop_regs:
    mov [tmp_var], 0
    pop es                ; Restore all register's data before
    pop bp                ;  returning to DOS
    pop di
    pop si
    pop dx
    pop cx
    pop bx
    pop ax

pop_ds:
    pop ds
    iret                  ; Interrupt return
check_y2k endp
lastbyte equ $            ; This marks the end of the resident code

;============================================================================
; The Init routine is responsible for putting our interrupt service routine
; check_y2k into memory. We first correct the current year if it's corrupted
; before we proceed to load our own routine.
; Everything from here on is dumped after installation
;============================================================================
Init:
;============================================================================
; Before doing so however, we first get the RTC's values and check for a
; year value of 1900, if not then we proceed to deallocate the environment
;============================================================================
    mov ah, 4             ; Real time clock   ah=func 04h
    int 1Ah               ;  get date  cx=year, dx=mon/day
    cmp cx, 1900h         ; cx == 1900?
    jne short env_dealloc ; Deallocate env and load routine

;============================================================================
; But if cx == 1900, then we correct the century - leaving the year as is
;============================================================================
    mov ah, 5
    mov ch, 20h           ; Real time clock   ah=func 05h
    int 1Ah               ;  set date  cx=year, dx=mon/day

;============================================================================
; Then we do the same for the BIOS
;============================================================================
    mov ah, 2Ah           ; DOS Services  ah=function 2Ah
    int 21h               ;  get date, cx=year, dh=month
                          ;   dl=day, al=day-of-week 0=SUN
    mov ah, 2Bh           ; DOS Services  ah=function 2Bh
    mov cx, 7D0h          ;  cx == 2000d, dx == as is
    int 21h               ;  set date, cx=year, dx=mon/day

;============================================================================
; If we disable the code from here to set_vector without
; deallocating the environment, we waste:
;  Segment  Region       Total        Type
;   0B7BD       1        832    (1K)  Environment
;   0E73E       3        384    (0K)  Program
;  Total Size:         1,216    (1K) !!!!
; Deallocate our copy of the environment block from memory - Saves 32 bytes
;============================================================================
env_dealloc:
    mov ax, cs:[psp_seg]  ; Get code seg PSP env address
    mov es,ax             ; Load address into es
    mov ah, 49h           ; DOS Services ah=function 49h
    int 21h               ; release memory block, es=seg

;============================================================================
; This is where we get and save the current time-of-day interrupt vector so
; we could chain in after it.
;============================================================================
set_vector:
    mov ax, 351Ch         ; DOS Services  ah=function 35h
    int 21h               ;  get intrpt vector al in es:bx

    mov old_int1c_add, bx
    mov old_int1c_add[2], es
    mov dx, offset check_y2k
    mov ax, 251Ch         ; DOS Services  ah=function 25h
    int 21h               ;  set intrpt vector al to ds:dx

    mov dx, offset credits
    mov ah, 9             ; DOS Services  ah=function 09h
    int 21h               ;  display char string at ds:dx

;============================================================================
; Calculate the number of paragraphs we need to save the
;  resident routine in - then save that data in dx
;============================================================================
    mov dx,(offset lastbyte - offset codesg + 15) shr 4
    mov ah, 31h           ;  terminate & stay resident
    int 21h               ;   al=return code,dx=paragraphs

psp_seg equ 2Ch           ; Self-Explanatory
tmp_var db  0
credits db  0Dh, 0Ah, 'Y2K RTC & BIOS Fix v1.3 (c) Sep 03 2000 JPLC'
        db  0Dh, 0Ah, '$'
codesg  ends

    end y2k_prog
