#include "drives.h"	/* DPB structure */
#include "fatio.h"	/* readfat */
#include <stdio.h>	/* printf */

#define CTS clustertosector
Dword clustertosector(Word cluster, struct DPB * dpb)
{
  Dword sector;
  if ((cluster < 2) || (cluster > dpb->maxclustnum)) {
    printf("Cluster number %u out of range [2..%u]\n",
      cluster, dpb->maxclustnum);
    return 0;
  }
  sector = cluster - 2; /* make it 0 based */
  sector <<= dpb->shlclusttosec;
  /*
    sector += dpb->numressec + (dpb->secperfat * dpb->fats);
    sector += (dpb->rootdirents >> 4); 
  */ /* rootdirents>>4 because of 512/32 being 1<<4... */
  sector += dpb->firstdatasec;
  return sector;
}

/* ***************************************************** */

Word nextcluster(Word cluster, struct DPB * dpb)
{		/* follow FAT chain or guess! */
  Word oldcluster = cluster;
  int state;

  printf("%d->",oldcluster);
  state = readfat(dpb->drive, oldcluster, &cluster, dpb);
  if (state < 0) { printf("FAT read error\n"); return 0; }
      
  if (cluster > dpb->maxclustnum) {
     printf("EOF\n");
     return 0;
  }
  if (cluster==0) {
    printf("NIL/"); /* if we come from empty... (undelete) */
    do {
      oldcluster++;
      state = readfat(dpb->drive, oldcluster, &cluster, dpb);
      if (state < 0) { printf("FAT read error\n"); return 0; }
      if (cluster != 0) { printf("."); }
    } while (cluster != 0); /* skip over used clusters */
    cluster = oldcluster; /* return next empty cluster! */    
  } /* else stay inside FAT chain */

  /* printf("%d "); */
  return cluster;
}

