program TAIL;
{$R+}{$S+}{$D+}
uses DOS,OpenDOS;

const version  = '7.02b' {$IFOPT D+} + #225{beta} {$ENDIF};
      author   = 'M.Aitchison@phys.canterbury.ac.nz';
      ValidOptions = Attr_+'/Characters=n[k]/Follow a growing file/Lines=n'+Pause_+'/Quiet'+Subdirs_+Verbose_;
      Syntax       = '[+|-lines] ['+filelist_+']';
      WhatItDoes   = 'Filter out all but the "tail" (last few lines of text)';


const
     FollowMode : boolean = false;
     TailNumber : longint = 22;
     TailUnits  : (lines,bytes,Blocks,Kbytes,Mbytes) = lines;

var
    saved : array[byte] of ^string;

procedure Init;
var i : integer;
begin
for i:=0 to 255 do new(saved[i]);
end;

procedure TailBytes(fn : string; HowMany : longint);
const buffersize = 255;
var fyle : file;
    i,j,counter : longint;
    k           : word;
    Buffer : string[buffersize];
begin
filemode:=$40;
assign(fyle,fn);
{$I-}
reset(fyle,1);
{$I+}
i:=IORESULT;
if i<>0
   then with reg do
        begin
        (*
        AX:=$3D40; CX:=0; fn[length(fn)+1]:=#0; DS:=seg(fn[1]); DX:=ofs(fn[1]);
        msdos(reg);
        filerec(fyle).handle:=AX;
        *)
        ErrorMessage(DosErrorMessage(i));
        end;
counter:=0;
j:=FileSize(fyle);
seek(fyle,max(0,j-abs(HowMany)));
Blockread(fyle,buffer[1],buffersize,k);
while k>0 do
      begin
      buffer[0]:=chr(k);
      if PauseInterval=DoNotPause
         then Write(buffer)
         else begin
              i:=pos(^J,buffer);
              while i>0
                    do begin
                       OutputLine(copy(buffer,1,i-1));
                       delete(buffer,1,i);
                       i:=pos(^J,Buffer);
                       end;
              OutputString(buffer);
              end;
      BlockRead(fyle,Buffer[1],Buffersize,k);
      end;
close(fyle);
end;

procedure TailLines(fn : string);
var fyle : text;
    filly: file absolute fyle;
    i,j,counter : longint;
begin
Trim(fn);
assign(fyle,fn);
if boolean(Verbosity and 4)
   then OutputLine(':::: '+fn+' ::::'+decimal(Verbosity)+','+decimal(ParametersInList));
filemode:=$40;
{$I-}
reset(fyle);
i:=IORESULT;
if i<>0
   then ErrorMessage(DosErrorMessage(i));

counter:=0;
repeat readln(fyle,st);
       saved[byte(counter)]^:=st;
       inc(counter);
       until eof(fyle);
for i:=min(Counter,TailNumber) downto 1 do
    begin
    if PauseInterval=DoNotPause
       then WriteToStandardFile(StandardOutputHandle,saved[byte(Counter-i)]^+^M^J)
       else outputLine(saved[byte(Counter-i)]^);
    end;
j:=TextSize(fyle);
close(fyle);
if FollowMode
   then with reg do
        begin
        repeat idle;
               UpdateAllFiles(0);
               FindFirst(Fn,anyfile,S);
               i:=S.Size;
               if i<>j
                  then begin
                       if boolean(Verbosity and 16) then write('Size of ',fn,j:5,'->',S.Size:5);
                       TailBytes(fn,i-j);
                       j:=i;
                       end
                  else repeat idle; dec(i); idle;
                              until keypressed or (i<-123456) or ((byte(TimerTicks) and 31)=0);
               until keypressed; {???}
        end;
end;

begin
Init;
AllowableAttributes:=$3F;
if not Parse('VeRsIoN='+version+#0,'CoPyRiGhT='+copyright+#0,author,
        ValidOptions,Syntax,WhatItDoes
        ) then halt;

{process / options (other than standard ones the Parse routine will have done)}
ChooseFormat(Compatibility);
ProcessFormat(Format); {creates FormatDefinition, and will set Info_Required, etc as needed}
if pos('/F',Globals)>0
   then FollowMode:=true;
if pos('/C',Globals)>0
   then begin
        TailUnits:=Bytes;
        st:=GetGlobalSpec('/C');
        case upcase(st[length(st)]) of
             'K' : TailUnits:=KBytes;
             'M' : TailUnits:=MBytes;
             'B' : TailUnits:=Blocks;
             else inc(st[0]);
             end;
        dec(st[0]);
        if st<>'' then TailNumber:=StringToInteger(st);
        end;

FirstInList:=0;
for i:=1 to ParametersInList do
    if (FirstInList=0)
       then begin
            st:=Parameter[i]^;
            if st[1] in ['+','-']
               then case upcase(st[length(st)]) of
                     'M' : begin TailUnits:=MBytes; dec(st[1]); TailNumber:=-StringToInteger(st); end;
                     'K' : begin TailUnits:=KBytes; dec(st[1]); TailNumber:=-StringToInteger(st); end;
                     'B' : begin TailUnits:=Blocks; dec(st[1]); TailNumber:=-StringToInteger(st); end;
                     else TailNumber:=-StringToInteger(st);
                     end
               else FirstInList:=i;
            end;

if (FirstInList=0) or ((FirstInList=ParametersInList) and (capitals(Parameter[FirstInList]^)='CON'))
   then TailLines('')
   else while GetFile(FileInfo) do with FileInfo do
              if (Attributes and OpenDOS.Directory)=0
                 then begin
                      st:=Directory+trim0(LFN);
                      case TailUnits of
                           Lines : TailLines(st);
                           Kbytes: TailBytes(st,TailNumber*1024);
                           Blocks: TailBytes(st,TailNumber*512);
                           Mbytes: TailBytes(st,TailNumber*1024000); {Whose definition of Mb to use??}
                             else  TailBytes(st,TailNumber);
                         end;
                      end;
FinishOff;
end.
