	page	66, 132
;------ nansi_i.asm ----------------------------------------------
; Contains code only needed at initialization time.
; Copyright (C) 1986,1999 Daniel Kegel
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
; or look on the web at http://www.gnu.org/copyleft/gpl.html.
; 
; Modifications:
;  2/12/85: Removed code for BIOS takeover, added processor check
;  2/13/85: changed processor check to PUSH SP
;  10 Jun 90: Deleted processor check, deleted output translation table
; $Log:	nansi_i.asm $
; Revision 1.9  91/04/07  21:46:34  dan_kegel
; Added /s option for security.  Disables keyboard redefinition.
; 
; Revision 1.8  91/04/07  18:23:04  dan_kegel
; Now supports /t commandline switch to tell nansi about new text modes.
; 
; Revision 1.7  91/04/06  21:38:00  dan_kegel
; Added Log.
; 
;-----------------------------------------------------------------

	include	nansi_d.asm		; definitions

	; to nansi.asm
	public	dosfn0

	; from nansi.asm
	extrn	break_handler:near
	extrn	int_29:near
	extrn	req_ptr:dword
	extrn	is_ega:byte
	extrn	kludge1_00C3:byte
	extrn	install_msg:byte
	extrn	textmode_table:byte	; 256 bit array of video modes

	; from nansi_p.asm
	extrn	param_buffer:word	; adr of first byte free for params
	extrn	param_end:word		; adr of last byte used for params
	extrn	redef_end:word		; adr of last used byte for redefs

	; from nansi_f.asm
	extrn	ibm_kkr:byte

	; for checking init overrun by comparing DOSFN0 to DOSFN0_END
	; in load map
	public	dosfn0_end

	; for debugging
	public	arg_s

code	segment byte public 'CODE'
	assume	cs:code, ds:code

;-------- dos function # 0 : init driver ---------------------
; Initializes device driver interrupts and buffers, then
; passes ending address of the device driver to DOS.
; Since this code is only used once, the buffer can be set up on top
; of it to save RAM.

dosfn0	proc	near
	; Get pointer to commandline options in ES:SI.
	call	near ptr d0_get_dev_args

	; Process arguments in ES:SI.
	; Sets variables textmode_table[], and nukes ibm_kkr.
	call	near ptr d0_process_args

	; See whether this computer has the new BIOS calls
	call	near ptr detect_extbios

	; Print out 'installed' message.
	mov	dx, offset install_msg
	mov	ah, 9
	int	21h

	;-----
	; Install BIOS keyboard break handler.
	xor	ax, ax
	mov	ds, ax
	mov	bx, 6Ch
	mov	word ptr [BX],offset break_handler
	mov	[BX+02], cs
	; Install INT 29 quick putchar.
	mov	bx, 0a4h
	mov	word ptr [bx], offset int_29
	mov	[bx+2], cs

	push	cs
	pop	ds
	push	cs
	pop	es			; es=cs so we can use stosb
	cld				; make sure stosb increments di

	; Test presence of EGA or better by calling BIOS fn 12h.10h.
	mov	ah, 12h
	mov	bx, 0ff10h
	int	10h			; bh=0-1, bl=0-3 if EGA
	xor	ax, ax
	test	bx, 0FEF0H
	jnz	got_ega_status		; sorry, charlie
		inc	ax		; Yippee- it's an EGA or better.
got_ega_status:
	mov	is_ega, al		; save boolean variable
	
	; Calculate addresses of start and end of parameter/redef buffer.
	; The buffer occupies the same area of memory as this code!
	; ANSI parameters are accumulated at the lower end, and
	; keyboard redefinitions are stored at the upper end; the variable
	; param_end is the last byte used by params (changes as redefs added);
	; redef_end is the last word used by redefinitions.
	mov	di, offset dosfn0
	mov	param_buffer, di
	add	di, 512
	mov	param_end, di	; addr of last byte in free area
	inc	di

	; Build the default redefinition table:
	;	control-printscreen -> control-P
	; (Must be careful not to write over ourselves here!)
	; CAUTION - WARNING - THESE STATEMENTS OVERWRITE
	; PART OF THE HEXADECIMAL OUTPUT CODE.  RETURN IMMEDIATELY
	; AFTER EXECUTING THEM.  DO NOT MOVE THEM MORE THAN 100 BYTES
	; FROM DOSFN0.
	mov	al, 16		; control P
	stosb
	mov	ax, 7200h	; control-printscreen
	stosw
	mov	ax, 1		; length field
	mov	redef_end, di	; address of last used word in table
	stosw

	; Return ending address of this device driver.
	; (If ax=di=FFFF, DOS would refuse to load us.)
	xor	ax, ax
	lds	si, req_ptr
	mov	word ptr [si+0Eh], di
	mov	[si+10h], cs

	; Return "not busy" exit status.
	ret

dosfn0	endp


;--------------------------------------------------------------------------
; Get pointer to device arguments in ES:SI.
; On entry and exit, DS=CS.
; Trashes AX, CX, DI.
d0_get_dev_args	proc	near
	les	si, req_ptr			; es:si = BPB/arg ptr ptr
	les	si, es:[si+12h]			; es:si = arg ptr

	; DOS 2 passes a pointer to the DEVICE= line, with a null before the
	; args; DOS 3 passes a pointer to the char after the =.
	cld
	mov	ah, 30h
	int	21h				; get dos version number to AL
	cmp	al, 2
	jnz	gda_ret
		mov	di, si
		mov	cx, 256
		mov	al, 0
		repnz	scasb			; skip to arguments field
		mov	si, di
gda_ret:
	ret
d0_get_dev_args	endp

;--------------------------------------------------------------------------
; Process arguments in ES:SI.
; On entry, DS=CS, ES:SI = argument string.
; Trashes AX,BX,CX,DX,SI.
d0_process_args	proc	near
	; Skip to first blank char (skip past driver filename).
arg_bloop:	call	d0_getchar
		jz	arg_done
		call	isspace
		jnz	arg_bloop
arg_loop:
		; Skip to next nonblank char.  Exit if end of args.
		call	d0_getchar
		jz	arg_done
		call	isspace
		jz	arg_loop

		; We are at start of an argument.  (Are your hackles up?)
		; All legal arguments start with a forward slash and a letter.
		cmp	al, '/'
		jnz	arg_bad
		call	d0_getchar
		jz	arg_bad
		; Handle each possible option
		CMP	AL,'X'                              
		JNZ	arg_not_x                               
		AND	kludge1_00C3,0FEh                 
		MOV	DX,offset xopt_msg                            
		MOV	AH,9                              
		INT	21h                                 
		JMP	arg_loop                               
arg_not_x:
		CMP	AL,'K'                              
		JNZ	arg_not_k                               
		OR	kludge1_00C3,10h                 
		MOV	DX,offset kopt_msg                            
		MOV	AH,09                              
		INT	21h                                 
		JMP	arg_loop                               
arg_not_k:
		cmp	al, 'S'
		jnz	arg_not_s
arg_s:			; /S option (security) takes no argument
			; it simply disables the keyboard redefinition sequence
			mov	dx, offset kkr_off_msg
			mov	ah, 9
			int	21h
			mov	al, nearret
			mov	ibm_kkr, al
			jmp	arg_loop

arg_not_s:	cmp	al, 'T'
		jnz	arg_not_t
			; /T option takes a hexadecimal argument
			call	d0_get_hex
			jc	arg_bad

			; Video mode AL is a text mode.
			; Set the corresponding bit in textmode_table.
			mov	cl, al
			shr	al,1
			shr	al,1
			shr	al,1
			cbw
			add	ax, offset textmode_table
			xchg	ax, bx
			and	cl, 7
			mov	al, 1
			shl	al, cl
			or	byte ptr [bx], al

			jmp	arg_loop
arg_not_t:

arg_bad:	; Otherwise it was an illegal option.
		mov	dx, offset arg_bad_msg
		mov	ah, 9
		int	21h
arg_done:
nearret	label	byte	; for copying near return opcode (brain surgery)
	ret

arg_bad_msg db	"NANSI.SYS: Expected /t followed by a two-digit hexadecimal video mode number"
	    db	13, 10
	    db	"For example, NANSI.SYS /t0b /t4f /t51 /t52", 13, 10, "$"

kkr_off_msg db	"NANSI.SYS /S: Disabling keyboard redefinition.", 13, 10, "$"
xopt_msg db "NANSI.SYS /X: Extended keys redefined independently.", 13, 10, "$"
kopt_msg db "NANSI.SYS /K: Force new keyboard BIOS calls.", 13, 10, "$"

d0_process_args	endp

;--------
; ES:SI points to next arg char.  Return next char in AL, Z=EOLN.
d0_getchar:
	lods	byte ptr es:[si]
	cmp	al, 'a'
	jb	d0gc_nlc
	cmp	al, 'z'
	ja	d0gc_nlc
		sub	al, 'a'-'A'	; convert from lower to uppercase
d0gc_nlc:
	cmp	al, 13
	jz	d0gc_done
	cmp	al, 10
d0gc_done:
	ret

;--------
; Return with Z set if char in AL is a blank or a tab.
isspace:
	cmp	al, 20h
	jz	isspace_ret
	cmp	al, 9
isspace_ret:
	ret

;-------- d0getnib
; Get a char from ES:[SI++]; convert it to hex in AL.
; Returns char in DL, nibble in AL, flags 'above' if char not a valid hex char.
; Preserves all other registers.
d0getnib:
	call	d0_getchar
	mov	dl, al		; save char in DL
	; is it in range '9'+1 ... 'A'-1?
	cmp	al, 'A'
	jae	d0gn_ok
	cmp	al, '9'
	ja	d0gn_ret	; '9' < c < 'A' means char is not hex.
d0gn_ok:
	sub	al, '0'
	cmp	al, 9
	jbe	d0gn_0
		sub	al, 'A' - '0' - 10
d0gn_0:
	cmp	al,0fh		; above means c < '0' or c > 'F'
d0gn_ret:
	; flags set to "above" if char could not be converted to hex
	ret

;--------
; d0_get_hex
; Get a two-digit hexadecimal number & convert to a byte in AL.
; If any char is not hex, print error message and return with carry set.

d0_get_hex:
	call	d0getnib	; get lower nibble
	ja	d0gh_bogus
	shl	al, 1
	shl	al, 1
	shl	al, 1
	shl	al, 1
	xchg	ah, al
	call	d0getnib	; get upper nibble
	ja	d0gh_bogus
	or	al, ah		; AL = byte
	; Return with carry clear.
	clc
d0gh_ret:
	ret
d0gh_bogus:
	push	dx
		; Print out error message.
		mov	ah, 9
		mov	dx, offset gh_errmsg
		int	21h
	; Print out offending char and CRLF.
	pop	dx
	mov	ah, 2
	int	21h
	call	d0_put_crlf
	; Return with carry set.
	stc
	jmp	d0gh_ret

gh_errmsg	db	"NANSI.SYS: Expected two-digit hexadecimal number in CONFIG.SYS"
		db	", but got $"

;--------------------
; Print a hexadecimal number in AL to the console.
d0_put_hex:
	call	d0_put_nib
d0_put_nib:
	ror	al, 1
	ror	al, 1
	ror	al, 1
	ror	al, 1
	mov	dl, al
	and	dl, 0fh
	add	dl, '0'
	cmp	dl, '9'
	jbe	d0_pn_ok
		add	dl, 'A' - '9' - 1
d0_pn_ok:
	push	ax
	mov	ah, 2
	int	21h
	pop	ax
	ret

;---------
; Print a newline.
d0_put_crlf:
	mov	ah, 2
	mov	dl, 13
	int	21h
	mov	ah, 2
	mov	dl, 10
	int	21h
	ret

; Call once during initialization.  Sets the 10h bit of kludge1_00C3 if
; this computer supports the new keyboard BIOS calls.
detect_extbios:
	TEST kludge1_00C3,10h
	JNZ kludge1_0D69
	; Jam special test code into keyboard buffer
	MOV AH,5
	MOV CX,0FFFFh
	INT 16h
	; Try to read special test code from keyboard buffer
	MOV CX,10h
kludge1_0D56:
	; Get keystroke using extended keyboard read
	MOV AH,10h
	INT 16h
	; Is it our special test code?
	CMP AX,0FFFFh
	; Yes; Set flag saying that the extended keyboard BIOS is supported
	JZ  kludge1_0D64
	LOOP kludge1_0D56
	JMP kludge1_0D69
kludge1_0D64:
	OR  kludge1_00C3,10h
kludge1_0D69:
	RET

;---- Be sure to check map file.  If end of code is more than 1c0h bytes
; beyond start of dosfn0, we may clobber ourselves when we set up the
; default keyboard redefinition table!
dosfn0_end:

code	ends
	end				; of nansi_i.asm
