/*
  LFNDOS.CPP  (c) 1998 Chris Jones, all rights reserved

  The resident driver implementation of ABSLFN.

  This is a special release of the LFNDOS 1.06 source code.

  This file is distributed with ABSOLUTELY NO WARRANTY, not even the implied
  warranties of MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.

  This source code is a SPECIAL RELEASE and MUST NOT be distributed.
  In addition, NO DERIVATIVE WORKS are allowed and the program MUST NOT be
  modified in any way and then distributed.

  This is still an ACTIVELY DEVELOPED project; as such, the project source code
  may be modified by the original author (Chris Jones) at any time. Therefore,
  any improvements or changes which you make, and which you feel would benefit
  the community, should be mailed to Chris Jones to be incorporated into the
  next official release.

  For information, and to suggest improvements, mail   dosuser@hotmail.com

*/
#define LFNDOS_VERSION 0x0106
#define LFNDOS_SUBVER  ""
//#define LFNDOS_BETA 1
// The line below MUST NOT BE USED by anyone other than Chris Jones
//#define CHRIS_JONES_AUTHENTIC
#include <alloc.h>
#include <stdio.h>
#include <ctype.H>
#include <dos.h>
#include <dir.h>
#include <process.h>
#include <string.h>
#include <direct.h>
#include <errno.h>
#define __PRETTY_FUNCTION__ "(unknown)"
//#define MSS
#include <mss.h>
#define farmalloc malloc
//#include "/tc/cpp/abslfn.cpp"

#define BIT0  0x0001
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000
struct myffblk {
  short ff_reserved[6];   // [0]=bytes/sector [2]=sector/cluster [3]=drive number [4]=root dir? [5]=rootdirsects
  char  ff_attrib;
  short ff_ftime;
  short ff_fdate;
  long  ff_fsize;
  char  ff_name[13];
  char  ff_longname[255];
  short ff_adate;  // last access
  char  filespec[70];
  char  internalbuffer[700];
  };

extern int myfindfirst(char*,int,myffblk*);
extern int myfindnext(myffblk*);
extern unsigned long findclusterof(myffblk*,char*);
extern void uselfnchdir(int);
extern void createdirectoryentry(char*,int=0);
extern int  deletefile(char*);
extern int  delete_wildcards(char*);
extern int  renamefile(char*,char*);
extern int  make_directory(char*);
extern int  findentry(char*,char*,int=0);
extern void generateshortname(char*,int,char*);
extern void dostodirname(char*,char*);
extern unsigned char * direntryptr;  // set by findentry
extern char shortnameof[80],generatedshortname[80];
extern char longnameof[200];
extern int aa;
extern char *buffr,*trbuf;
extern int cd_findfirst(char*,int,myffblk*);
extern int cd_findnext(myffblk*);
int cd_iscddrive(int);
int remove_tsr();

// These are stub functions; when the actual CD LFN code is written,
// it will replace these functions
int cd_findfirst(char*,int,myffblk*) { return -1; }
int cd_findnext(myffblk*) { return -1; }
char*trbuf;

int __myfindfirst(char*fnam,int attribs,myffblk*mfbptr) {
  if (fnam[1]!=':') {
    printf("LFNDOS Internal: findfirst not truenamed\n");
    return -1;
    }
  fnam[0]=toupper(fnam[0]);
  int ondrive=fnam[0]-'A';
  if (cd_iscddrive(ondrive))
    return cd_findfirst(fnam,attribs,mfbptr);
  else return myfindfirst(fnam,attribs,mfbptr);
  }
int __myfindnext(myffblk*mfbb) {
  if (cd_iscddrive(mfbb->ff_reserved[3]))
    return cd_findnext(mfbb);
  return myfindnext(mfbb);
  }
#define myfindfirst __myfindfirst
#define myfindnext __myfindnext

REGPACK rrr;
int use_cd=0;
int cd_installed() {
  rrr.r_ax=0x1500; intr(0x2f,&rrr);
  if (rrr.r_ax!=0x15ff) return 0;  // not installed
  use_cd=1;
  return rrr.r_bx;
  }

int cd_getversion() { rrr.r_bx=0;
  rrr.r_ax=0x150c; intr(0x2f,&rrr);
  if (rrr.r_bx==0) return 0x100;  // version 1.x
  return rrr.r_bx;
  }

int cd_iscddrive(int drivlab) {  // MSCDEX 2.00 and above
  // is the given drive a CD-ROM drive?
  if (use_cd==0) return 0;
  rrr.r_ax=0x150B; rrr.r_cx=drivlab; intr(0x2f,&rrr);
  if (rrr.r_bx!=0xADAD) return 0;  // not MSCDEX signature
  if (rrr.r_ax!=0) return 1;
  return 0;
  }
// CD stuff

#pragma inline
#define INT21 0x21
char*fatsysid="FAT";
int errorcalls=0;

#define DWORD unsigned long
struct WIN32_FIND_DATA {
  DWORD attrib;
  DWORD creatlow;
  DWORD creathigh;
  DWORD accesslow;
  DWORD accesshigh;
  DWORD modifylow;
  DWORD modifyhigh;
  DWORD filsizhigh;
  DWORD filsizlow;
  char  reserved[8];
  char  name[260];
  char  shortname[14];
  };
myffblk mffb;
#define MAXSEARCHES 10
myffblk*mfbaloc[MAXSEARCHES];
void myffbtowin32(WIN32_FIND_DATA*wfd) {
  wfd->attrib=mffb.ff_attrib;
  wfd->accesshigh=wfd->creathigh=wfd->modifyhigh=0;
  wfd->creatlow=0;
  wfd->accesslow=(long)mffb.ff_adate << 16;
//  printf("date: %X ",mffb.ff_fdate);
  wfd->modifylow=(((unsigned long)mffb.ff_fdate) << 16L) & 0xffff0000L;
  wfd->modifylow|=(mffb.ff_ftime & 0x0000ffff);
//  printf("modify %lX ",wfd->modifylow);
  wfd->filsizhigh=0;
  wfd->filsizlow=mffb.ff_fsize;
  strcpy(wfd->shortname,mffb.ff_name);
  strcpy(wfd->name,mffb.ff_longname);
  }

char handlesinuse[MAXSEARCHES];
int startnewsearch() {
  int hh;
//  printf("ns ");
  for (hh=1;hh<MAXSEARCHES;hh++) {
    if (handlesinuse[hh]==0) { handlesinuse[hh]=1; return hh; }
/*    if (mfbaloc[hh]==NULL) {
      mfbaloc[hh]=(myffblk*)farmalloc(sizeof(myffblk));
      printf("handle %d memfree: %ld\n",hh,farcoreleft());
      if (mfbaloc[hh]==NULL) return -1;
      return hh; }*/
    }
  return -1;
  }

struct InterruptStackState {
  short bp;
  short di;
  short si;
  short ds;
  short es;
  short dx;
  unsigned short cx;
  unsigned short bx;
  short ax;
  short return_ip;
  short return_cs;
  short flags;
  };
void truenameit(char*tempptr,char*secondtemp) {
  for (int ee=0;tempptr[ee]!=0;ee++)
    if (tempptr[ee]=='/') tempptr[ee]='\\';  // convert / to \
  if ((tempptr[1]==':') & (tempptr[2]!='\\')) {
    int drr=tempptr[0]-'a'; if (tempptr[0]<='Z') drr=tempptr[0]-'A';
    drr++; _getdcwd(drr,secondtemp,80);
    if (secondtemp[strlen(secondtemp)-1]!='\\')
      strcat(secondtemp,"\\");
    strcat(secondtemp,&tempptr[2]);
    }
  else if (tempptr[0]=='\\') {
    sprintf(secondtemp,"%c:",getdisk()+'A');
    strcat(secondtemp,tempptr); }
  else if (tempptr[1]==':') strcpy(secondtemp,tempptr);
  else { getcwd(secondtemp,80);
    if (secondtemp[strlen(secondtemp)-1]!='\\') strcat(secondtemp,"\\");
    strcat(secondtemp,tempptr); }
//  printf("truename %s to %s ",tempptr,secondtemp);
  }

InterruptStackState far*iss;
WIN32_FIND_DATA far*wfds;
char*tempptr,*secondtemp;
long*longptr;
char drive;
int lastdrive;
void (*oldreturnaddr)();
int retcs,retip;
char lfdbuffer[80];
#define OURSTACKSIZE 9000  // using CD absread makes this massiev
char far*tempstack;
char bigbuffer[240];

struct DosErrorStruct {
  short ax;
  short bx;
  short cx;
  short dx;
  short si;
  short di;
  short ds;
  short es;
  short resvd;  // =0
  short systemid;  // =0
  short processid;  // =PSP
  };
DosErrorStruct des;

#define DOSERR_FILENOTFOUND 2
#define DOSERR_PATHNOTFOUND 3
#define DOSERR_ACCESSDENIED 5
#define DOSERR_INVALIDDRIVE 0x0F
#define DOSERR_NOMOREFILES  0x12
#define DOSERR_FILEEXISTS   0x50
void setdoserror(int codd) {
  rrr.r_ax=0x5d0a;
  rrr.r_dx=FP_OFF(&des);
  rrr.r_ds=FP_SEG(&des);
  des.ax=codd;
  des.bx=0x0803;
  des.cx=0x0100;
  intr(0x21,&rrr);
  }

int isdriveremote(int drr) {   // 1=a, 2=b, 3=c, ...
  rrr.r_ax=0x4409;
  rrr.r_bx=drr;
  intr(0x21,&rrr);
  if (rrr.r_dx & (BIT12 | BIT9)) return 1;
  return 0;
  }

void replace_slashes(char*sss) {
  int innd=0;
  while (sss[innd]!=0) {
    if (sss[innd]=='/') sss[innd]='\\';
    innd++;
    }
  }

char tempsbuf[100];
int findinuse=0;
extern "C" {
  extern void asminthandler();
  extern void*intpointer;

#define ErrorReturn() { iss->ax=0x7100; iss->flags|=1; return; }
void interrupt (*oldint21)(...);
void cinthandler() {
  iss=(InterruptStackState*)intpointer;
  iss->return_cs=retcs;
  iss->return_ip=retip;
  if (iss->ax==0x71FE) {  // our special "remove LFNDOS" command
    if (iss->bx!=0xdead) { iss->flags|=1; return; }
    if (remove_tsr()==0) iss->bx=0xadde;
    else iss->bx=errorcalls;
    return;
    }
//  printf("LFN %X ",iss->ax);
  if (iss->ax==0x71A0) {  // get volume info
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
    drive=tempptr[0];
    if ((drive>='a') & (drive<='z')) drive-=32;
    drive-='A';
    if ((drive<0) | (drive>=lastdrive)) ErrorReturn();
    tempptr=(char*)MK_FP(iss->es,iss->di);
    strncpy(tempptr,fatsysid,iss->cx);
    if ((isdriveremote(drive+1)!=0) & (cd_iscddrive(drive)==0)) {
      iss->cx=12;
      iss->dx=76;   // don't support LFN on non-absread drives
      iss->bx=0;
      }
    else {
      iss->bx=(0x0002 | 0x0004 | 0x4000);  // see int list for info
      iss->cx=255;  // max filename len
      iss->dx=260;  // max path len
      }
    if (cd_iscddrive(drive)) strncpy(tempptr,"CDFS",iss->cx);
    }
  else if (iss->ax==0x7147) {  // get current dir - send thru to getcwd
    tempptr=(char*)MK_FP(iss->ds,iss->si);
    iss->dx&=0x00ff;
    _getdcwd(iss->dx,lfdbuffer,70);
    mffb.ff_reserved[3]=iss->dx-1;
    if (iss->dx==0) mffb.ff_reserved[3]=getdisk();
//    printf("driv: %d\n",mffb.ff_reserved[3]);
//    strcat(lfdbuffer,"\\.");
//    printf("find for '%s'\n",lfdbuffer);
    if (findclusterof(&mffb,lfdbuffer)==0xffffffff)
      ErrorReturn();
//    printf("curdir: '%s'\n",longnameof);
    strcpy(tempptr,&longnameof[3]);
/*    _getdcwd(iss->dx,lfdbuffer,60);
    strcpy(tempptr,&lfdbuffer[3]);  // doesn't return the 'C:\' bit*/
//    strcpy(tempptr,lfdbuffer);  // doesn't return the 'C:\' bit
    }
  else if (iss->ax==0x7160) {  // truename, attempt some sort of canonalization
/*    if (iss->cx & 0x00ff) {
      printf("LFNDOS: Truename with CL=%d called\n",iss->cx & 0x00ff);
      errorcalls++;
      ErrorReturn();
      }*/
    tempptr=(char*)MK_FP(iss->ds,iss->si);
    secondtemp=(char*)MK_FP(iss->es,iss->di); //secondtemp[0]=0;
    truenameit(tempptr,secondtemp);
    }
  else if (iss->ax==0x713B) {  // change directory
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
    replace_slashes(tempptr);
    strcpy(bigbuffer,tempptr);
    if (tempptr[0]=='\\') sprintf(bigbuffer,"%c:%s",getdisk()+'A',tempptr);
    else if (tempptr[1]==':') ;
    else { getcwd(bigbuffer,80);
      if (bigbuffer[strlen(bigbuffer)-1]!='\\') strcat(bigbuffer,"\\");
      strcat(bigbuffer,tempptr); }
    if ((bigbuffer[0]>='a') & (bigbuffer[0]<='z')) bigbuffer[0]-=32;
    mffb.ff_reserved[3]=(bigbuffer[0]-'A');
//    printf("wantdir: '%s' ",bigbuffer);
    int problem=0;
    if (cd_iscddrive(mffb.ff_reserved[3])) {
      if (cd_findfirst(bigbuffer,0,&mffb)) problem=1;
      }
    else if (findclusterof(&mffb,bigbuffer)==0xffffffff) problem=1;
    if (problem) {
      setdoserror(DOSERR_PATHNOTFOUND); iss->flags|=1; iss->ax=3;
      return; }
//    printf("shortname: '%s'\n",shortnameof);
    chdir(shortnameof);
    }
  else if (iss->ax==0x714E) {  // findfirst
    wfds=(WIN32_FIND_DATA*)MK_FP(iss->es,iss->di);
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
//    strcpy(tempsbuf,tempptr); tempptr=&tempsbuf[0];
    if (findinuse) { printf("LFNDOS: FindFirst used nested\n");
      errorcalls++; ErrorReturn(); }
//    printf("findfirst: '%s' attr 0x%X ",tempptr,iss->cx);
//    if (iss->si!=1) ErrorReturn();  // want date/time in FILETIME format
    truenameit(tempptr,lfdbuffer);
//    if (lfdbuffer[strlen(lfdbuffer)-1]=='\\') strcat(lfdbuffer,"*");
//    printf("findfirst: '%s'\n",lfdbuffer);

    int ert=startnewsearch();
    if (ert<1) { printf("LFNDOS: no search handles.\n"); ErrorReturn(); }
    if (myfindfirst(lfdbuffer,(iss->cx) & 0x00FF,mfbaloc[ert])) {
      handlesinuse[ert]=0;
//    if (myfindfirst(lfdbuffer,(iss->cx) & 0x00FF,&mffb)) { //mfbaloc[ert])) {
      iss->flags|=1; iss->ax=DOSERR_NOMOREFILES;
      if (errno==EINVDRV) iss->ax=DOSERR_INVALIDDRIVE;
      else if (errno==ENOPATH) iss->ax=DOSERR_PATHNOTFOUND;
//      printf("returning %X\n",iss->ax);
      setdoserror(iss->ax); return; }

    memcpy(&mffb,mfbaloc[ert],sizeof(myffblk));
//    printf("found: '%s' ",mffb.ff_longname);

    myffbtowin32(wfds);
    //findinuse=1;
    iss->ax=ert;  // search handle
//    iss->ax=1;   // search handle
    iss->cx=0;  // unicode conversion
    }
  else if (iss->ax==0x714F) {  // findnext
    // BX is handle
//    if (iss->si!=1) ErrorReturn();
    wfds=(WIN32_FIND_DATA*)MK_FP(iss->es,iss->di);
/*    if (myfindnext(mfbaloc[iss->bx])) { iss->flags|=1; iss->ax=0x12;
      setdoserror(DOSERR_NOMOREFILES); return; }*/
    memcpy(&mffb,mfbaloc[iss->bx],sizeof(myffblk));

    if (myfindnext(&mffb)) { iss->flags|=1; iss->ax=0x12;
      setdoserror(DOSERR_NOMOREFILES); return; }

    memcpy(mfbaloc[iss->bx],&mffb,sizeof(myffblk));
//    printf("found: '%s' ",mffb.ff_longname);
    myffbtowin32(wfds);
    iss->cx=0;
    }
  else if (iss->ax==0x71A1) {  // FindClose
    // BX is handle to close, we do nothing
    //printf("findclose: %d\n",iss->bx);
    findinuse=0;
    if ((iss->bx>0) & (iss->bx<MAXSEARCHES)) handlesinuse[iss->bx]=0;
    if ((mfbaloc[iss->bx]==NULL) | ((short)iss->bx<0) | (iss->bx>=MAXSEARCHES))
      ErrorReturn();
//    farfree(mfbaloc[iss->bx]); mfbaloc[iss->bx]=NULL;
    }
  else if (iss->ax==0x71A7) {  // FILETIME to DOS time
    longptr=(long*)MK_FP(iss->ds,iss->si);
    if ((iss->bx & 0x00ff)==0) {  // we cheat by using filetime as dos time
      iss->cx=(longptr[0] & 0x0000ffff);
      iss->dx=(longptr[0] >> 16);
      iss->bx&=0x00ff;
      }
    else if ((iss->bx & 0x00ff)==1) {  // DOS time to FILETIME
      longptr=(long*)MK_FP(iss->es,iss->di);
      longptr[1]=0;
      longptr[0]=(iss->cx) | ((long)(iss->dx) << 16);
      }
    else ErrorReturn();
    }
  else if (iss->ax==0x7141) {  // delete file
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
    replace_slashes(tempptr);
/*    if (iss->si) { printf("LFNDOS: delete called with wildcards on\n");
      errorcalls++; ErrorReturn(); }*/
    int resl=-1;
    if (iss->si) resl=delete_wildcards(tempptr);
    else resl=deletefile(tempptr);
    if (resl==0) {
      if (errno==EACCES) iss->ax=DOSERR_ACCESSDENIED;
      else iss->ax=DOSERR_FILENOTFOUND;
      setdoserror(iss->ax); iss->flags|=1; return; }
    }
  else if (iss->ax==0x713A) {  // remove directory
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
    replace_slashes(tempptr);
    if (deletefile(tempptr)==0) { iss->ax=DOSERR_PATHNOTFOUND;
      setdoserror(iss->ax); iss->flags|=1; return; }
    }
  else if (iss->ax==0x7139) {  // make directory
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
//    printf("md: '%s'\n",tempptr);
    replace_slashes(tempptr);
    if (tempptr[strlen(tempptr)-1]=='\\') tempptr[strlen(tempptr)-1]=0;
    if (make_directory(tempptr)==0) { iss->ax=DOSERR_PATHNOTFOUND;
      setdoserror(iss->ax); iss->flags|=1; return; }
    }
  else if (iss->ax==0x7156) {  // rename file
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
    char*newname=(char*)MK_FP(iss->es,iss->di);
    int errcod;
    if ((errcod=renamefile(tempptr,newname))<0) { iss->ax=DOSERR_FILENOTFOUND;
      if (errcod==-2) iss->ax=DOSERR_FILEEXISTS;  // target exists
      setdoserror(iss->ax); iss->flags|=1; return; }
    }
  else if (iss->ax==0x716C) {   // open/create file
    // DX:  0x01  open, fail if not exist
    //      0x02  truncate, fail if not exist
    //      0x10  create, fail if exist
    //      0x11  open if exist, create if not
    //      0x12  truncate if exist, create if not
    // BX = flags:  bit2-0:  0:r/o  1=w/o  2=r/w  4=r/o, no access date change
    // BX contains extra flags, eg. don't compress, which we ignore
    // CX=attrib  BX=mode & flags  DX=action  DI=alias hint
    tempptr=(char*)MK_FP(iss->ds,iss->si);
//    printf("creat/open '%s' DX:%X  BX:%X  CX:%X\n",tempptr,iss->dx,iss->bx,iss->cx);
    replace_slashes(tempptr);
    int failthis=0;
//    printf("open called: BX:%X DX:%X  ",iss->bx,iss->dx);
    if (findentry(tempptr,lfdbuffer)==0) {
      if ((iss->dx & 0x10)==0)
	failthis=DOSERR_FILENOTFOUND;
      else {
//	failthis=0x7100;
	// should create new LFN entry
	createdirectoryentry(tempptr);
	if (generatedshortname[0]==0) { iss->ax=DOSERR_PATHNOTFOUND;
//	  printf("returning Patherr\n");
	  setdoserror(iss->ax); iss->flags|=1; return; }
	strcpy(lfdbuffer,generatedshortname);
	rrr.r_ax=0x3C00;
	rrr.r_cx=iss->cx;   // attributes
	rrr.r_ds=FP_SEG(lfdbuffer);
	rrr.r_dx=FP_OFF(lfdbuffer);
	rrr.r_flags=0; intr(0x21,&rrr);
	if (rrr.r_flags & 1) failthis=rrr.r_ax;
	else { iss->ax=rrr.r_ax;  // handle
	  iss->cx=2; }  // file was created
	}
      }
    else {   // entry found
      if ((iss->dx & 0x03)==0) failthis=DOSERR_FILEEXISTS;
      else if (iss->dx & 1) {
//	printf("DOSopen: '%s' ",lfdbuffer);
	rrr.r_ax=0x3D00+(iss->bx & 0x07);  // mode (r/o, r/w, etc)
	rrr.r_ds=FP_SEG(lfdbuffer);
	rrr.r_dx=FP_OFF(lfdbuffer);  // short name
	rrr.r_cx=iss->cx;
	rrr.r_flags=0;     // call old DOS open file
	intr(0x21,&rrr);
	if (rrr.r_flags & 1) failthis=rrr.r_ax;
	else { iss->ax=rrr.r_ax;  // handle
	  iss->cx=1; }  // file was opened
	}
      else if (iss->dx & 2) {   // truncate existing file
	rrr.r_ax=0x3C00;
	rrr.r_cx=iss->cx;   // attributes
	rrr.r_ds=FP_SEG(lfdbuffer);
	rrr.r_dx=FP_OFF(lfdbuffer);
	rrr.r_flags=0; intr(0x21,&rrr);
	if (rrr.r_flags & 1) failthis=rrr.r_ax;
	else { iss->ax=rrr.r_ax;  // handle
	  iss->cx=3; }  // file was truncated
	}
      else { printf("LFNDOS: ERROR in call to 716C/DX=%X\n",iss->dx);
	errorcalls++; }
      }
    if (failthis>0) { iss->ax=failthis;
      setdoserror(failthis); iss->flags|=1; return; }
    }
  else if (iss->ax==0x7143) {
    tempptr=(char*)MK_FP(iss->ds,iss->dx);
    replace_slashes(tempptr);
//    printf("7143 want '%s' ",tempptr);
    if (findentry(tempptr,lfdbuffer)==0) { iss->ax=DOSERR_FILENOTFOUND;
      setdoserror(iss->ax); iss->flags|=1; return; }
    int acc=iss->bx & 0x00ff;
//    printf(" sub %d '%s' attr:%X %X  ",acc,tempptr,buffr[aa],buffr[aa+11]);
    if (acc==0) { unsigned utm;  // get attributes
      _dos_getfileattr(lfdbuffer,&utm); iss->cx=utm; }
    else if (acc==1) _dos_setfileattr(lfdbuffer,iss->cx);
    else if (acc==2) { iss->dx=*(short*)&buffr[aa+30];
      iss->ax=*(short*)&buffr[aa+28]; }
    else if (acc==4) { iss->cx=*(short*)&buffr[aa+22];
      iss->di=*(short*)&buffr[aa+24]; }
    else { printf("Unsupported LFN function 7143 called: %02X\n",acc);
      errorcalls++; ErrorReturn(); }
    }
  else if (iss->ax==0x71A8) {
    tempptr=(char*)MK_FP(iss->ds,iss->si); lfdbuffer[0]=0;
    generateshortname(tempptr,0,lfdbuffer); strupr(lfdbuffer);
    tempptr=(char*)MK_FP(iss->es,iss->di);
    if ((iss->dx & 0xff00)==1) dostodirname(lfdbuffer,tempptr);
    else strcpy(tempptr,lfdbuffer);
//    printf("conv to '%s' DX=%X\n",tempptr,iss->dx);
    if (((iss->dx & 0x00f0)==0x0020) |
      ((iss->dx & 0x000f)==0x0002)) {
      printf("LFNDOS/71A8: unicode not supported\n");
      ErrorReturn(); }
    }
  else { printf("Unsupported LFN function called! function=%X\n",iss->ax); //getch();
    errorcalls++; ErrorReturn(); }
  iss->flags&=~1;
  }

/*void cinthandler() {
  // save old psp
  rrr.r_ax=0x6200;
  intr(0x21,&rrr);
  int pspwas=rrr.r_bx;
  // set our psp
  rrr.r_ax=0x5000;
  rrr.r_bx=_psp;
  intr(0x21,&rrr);
  __cinthandler();
  // restore old psp
  rrr.r_ax=0x5000;
  rrr.r_bx=pspwas;
  intr(0x21,&rrr);
  }*/
} // extern C

//#define ErrorReturn() { iss->ax=0x7100; outp(0x20,0x20); iss->flags|=1; return; }
#define INSTALLATIONCHECK 0x4bc2
/*
--------U-214BC2------------------------
INT 21 - "LFNDOS" - INSTALLATION CHECK
	AX = 4BC2h
	BX = 0000h
	CX = BEEFh
Return: AX = DEADh if installed
	    BX = version number (major in high byte)
	    CX = 0000h
	    DX = 0000h
Program:LFNDOS is a Win95 LFN API provider under plain DOS, by Chris Jones.
SeeAlso:AX=71FEh
--------U-2171FE-----------------------
INT 21 - "LFNDOS v1.03+" - UNINSTALL
	AX = 71FEh
	BX = DEADh
Return: BX = ADDEh if failed to remove
	all registers undefined if successful
SeeAlso:AX=4BC2h
*/
void interrupt myint21(...) {
  if (_AX==INSTALLATIONCHECK) ;
  else if (_AH!=0x71) _chain_intr(oldint21);
  iss=(InterruptStackState*)MK_FP(_SS,_SP);
  if ((iss->ax==INSTALLATIONCHECK) & (iss->cx==0xbeef)) {
    iss->ax=0xdead;
    iss->bx=LFNDOS_VERSION;
    iss->cx=0;
    iss->dx=0;
    outp(0x20,0x20); return;
    }
  else if (iss->ax==INSTALLATIONCHECK) _chain_intr(oldint21);
  retcs=iss->return_cs;
  retip=iss->return_ip;
  iss->return_cs=FP_SEG(asminthandler);
  iss->return_ip=FP_OFF(asminthandler);
  outp(0x20,0x20); return;
  }

struct DriveInformation {
  short drive_number;   // kind of redundant, 0=A, 1=B, etc
  short bytes_per_sector;
  short sectors_per_cluster;
  short sectors_per_fat;
  short number_of_root_dir_sectors;
  long  root_dir_start_sector;
  short fat_start_sector;
  long  dir_area_start;
  char  file_system_id[9];  // eg. 'FAT16   '
  };
extern void readdiskinfo(int,DriveInformation*);
int installedastsr=0;

int remove_tsr() {
  if (installedastsr==0) return 0;
  if (getvect(INT21)!=myint21) return 0;  // another TSR has taken it
  setvect(INT21,oldint21);
  tempstack-=OURSTACKSIZE;
  // set our psp
  rrr.r_ax=0x5000;
  rrr.r_bx=_psp;
  intr(0x21,&rrr);
  farfree(tempstack);
  if (use_cd) farfree(trbuf);
  _exit(1);
  unsigned short far*envptr=(unsigned short far*)MK_FP(_psp,0x2c);
  unsigned short envseg=envptr[0];
  _dos_freemem(_psp);
  _dos_freemem(envseg);
//  _exit(1);
  return 1;
  }

void main(int argc,char*argv[]) {
  printf("LFNDOS v%d.%02d" LFNDOS_SUBVER " (c) 1998, 1999 Chris Jones\n",LFNDOS_VERSION >> 8,LFNDOS_VERSION & 0x00ff);
#ifndef CHRIS_JONES_AUTHENTIC
  printf(
    "NOTE: This is NOT the original LFNDOS, as published by Chris Jones.\n"
    "It has been modified and therefore Chris Jones cannot be held responsible\n"
    "for any damages which arise from the modifications made to the software.\n");
#endif
  #ifdef LFNDOS_BETA
  printf("WARNING: BETA version. This version may NOT be distributed.\n");
  #endif
  int hh;
  for (hh=0;hh<MAXSEARCHES;hh++) { //mfbaloc[hh]=NULL;
    if (hh>0) mfbaloc[hh]=(myffblk*)malloc(sizeof(myffblk));
    handlesinuse[hh]=0; }

  if (argc>1) strlwr(argv[1]);
  if ((argc>1) && (argv[1][1]!='u') && (argv[1][1]!='t')) {
    printf("\nUsage: LFNDOS [-u] [-t]"
      "\n\nLFNDOS emulates the Win95 LFN API so that DOS programs can use long\nfilenames.\n"
      "\n -u  removes installed TSR from memory."
//      "\n -c  installs as memory-resident, not TSR\n");
      "\n -t  installs as TSR, not memory-resident (warning: bugs, may crash)\n");
    return; }
  int osvermm=(_osmajor << 8) + _osminor;
  if (osvermm < 0x031E) { printf("Requires DOS 3.3\n"); return; }
  rrr.r_ax=0x1600;
  intr(0x2f,&rrr);
  if ((rrr.r_ax & 0x00ff) > 0) {
    if ((rrr.r_ax & 0x00ff) == 0x80) ;
    else if ((rrr.r_ax & 0x00ff) >=4) {
      printf("Windows 95 or above is running. You probably do not need LFNDOS.\n"
	"LFNDOS not installed.\n");
      return; }
    printf("Warning: Windows %d.%02d detected.\n",rrr.r_ax & 0x00ff,rrr.r_ax>>8);
    }
  int wantaction=2;
  if (argv[1][1]=='u') wantaction=1;
  else if (argv[1][1]=='t') wantaction=0;
  rrr.r_ax=INSTALLATIONCHECK;
  rrr.r_bx=0;
  rrr.r_cx=0xbeef;
  intr(0x21,&rrr);
  if ((wantaction==1) & (rrr.r_ax!=0xdead)) {
    printf("LFNDOS not resident.\n"); return; }
  else if (wantaction==1) {
    if (rrr.r_bx<0x0103) { printf("Cannot remove LFNDOS before v1.03.\n"); return; }
    rrr.r_ax=0x71FE;
    rrr.r_bx=0xdead;
    intr(0x21,&rrr);
    if (rrr.r_bx==0xadde) {
      printf("Unable to remove, because another program has taken INT21. Remove that\n"
	   "program, then try again.\n"); return; }
    printf("LFNDOS removed.\n");
    if (rrr.r_bx>0) { errorcalls=rrr.r_bx;
      printf("There were %d calls to unsupported functions.\n",errorcalls); }
    return;
    }
  if (rrr.r_ax==0xdead) { printf("LFNDOS v%d.%02d already installed.\n",rrr.r_bx >> 8,rrr.r_bx & 0x00ff);
    return; }
  use_cd=0;
/*  if (cd_installed()) {
    if (cd_getversion() < 0x020A) use_cd=0;
    }*/
  if (use_cd) printf("MSCDEX support enabled.\n");
  lastdrive=setdisk(getdisk());
  tempstack=(char*)farmalloc(OURSTACKSIZE+100);
  MSS_SET_BLOCK_LABEL(tempstack,"Interrupt stack");
  tempstack+=OURSTACKSIZE;  // stacks go downwards
//  uselfnchdir(1);
  printf("Checking drives:\n");
  int numdriv=setdisk(getdisk());
  int oridrive=getdisk();
  int numdone=0;
  for (int pp=2;pp<numdriv;pp++) {
    if (cd_iscddrive(pp)) printf("%c:[CD-ROM  ] ",pp+'A');
    else if (isdriveremote(pp+1)) continue;
    else if (_chdrive(pp+1)!=0) continue;
    else { DriveInformation dri; dri.file_system_id[0]=0;
      readdiskinfo(pp,&dri);
      printf("%c:",pp+'A');
      if (dri.file_system_id[0]==0) printf("[UNKNOWN ] ");
      else printf("[%-8s] ",dri.file_system_id);
      }
    numdone++;
    if (numdone % 6 == 0) printf("\n");
    }
  if (use_cd) { trbuf=(char*)farmalloc(2050);
    MSS_SET_BLOCK_LABEL(trbuf,"CDROM absread buffer");
    }
  setdisk(oridrive);
  printf("\n");
/*  printf("using %d paragraphs\n",(_SS + (_SP/16) - _psp)+3);
  return;*/
  oldint21=getvect(INT21);
  setvect(INT21,myint21);
  if (wantaction==0) {
    printf("Type LFNDOS -u  to remove LFNDOS...\n"); installedastsr=1;
    _dos_keep(0, ((_SS + (_SP/16)) - _psp)+10);
    printf("Error going resident. Try using LFNDOS (without switches) to use\nthe non-TSR mode.\n");
    return;
    }
  printf("Type EXIT to remove LFNDOS...");
  system("");
  printf("LFNDOS removed.\n");
//  printf("oldret: %p  findfirst: %p retad: %04X:%04X\n",oldreturnaddr,findfirsthere,retcs,retip);
  setvect(INT21,oldint21);
  tempstack-=OURSTACKSIZE;
  if (use_cd) free(trbuf);
  free(tempstack);
  if (errorcalls>0) printf("There were %d calls to unsupported functions.\n",errorcalls);

  }
