/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <DOS.h>
#include "ISHRDDRV.H"

#ifdef PERFORM_CDROM_CHECK
#include "ISCDDRV.H"
#endif

//////////// PART 1:  HD DETECTION  ////////////////////////////////////

/* returns status of drivenum, 1=A:,2=B:, ... */
BYTE isHardDrive (BYTE drivenum)
{
   union REGS regs;
   register BYTE drv_info = 0;

   regs.x.ax = 0x4409;       // check block device if remote
   regs.h.bl = drivenum;     // 0=current,1=A:,2=B:,...
   intdos (&regs, &regs);
   if ( !regs.x.cflag )
   {
	drv_info |= DRV_EXISTS;

      if (regs.x.dx & 0x9000)  /* network and substed*/
#ifdef DISALLOW_REMOTE_DRIVE
		return DRV_INVALID;
#else
		drv_info |= DRV_IFS;
#endif

	if ((regs.x.dx & 0x0FFF) == 0x800)  /* ramdisk (and NT2k NTFS)*/
#ifdef DISALLOW_RAMDISK
		return DRV_INVALID;
#else
		drv_info |= DRV_RAMDISK;
#endif

#ifdef PERFORM_REMOVABLE_CHECK
	regs.x.ax = 0x4408;	// check block device if removable
	regs.h.bl = drivenum;	// 0=current,1=A:,2=B:,...
	intdos (&regs, &regs);  // returns carry clear & ax=0 for removable, ax=1 for fixed
	if (!regs.x.cflag && !regs.x.ax)
#ifdef DISALLOW_REMOVABLE_DRIVE
		return DRV_INVALID;
#else
		drv_info |= DRV_REMOVABLE;
#endif
#endif /* PERFORM_REMOVABLE_CHECK */


#ifdef PERFORM_CDROM_CHECK
	if (isCDRomDrive(drivenum))
#ifdef DISALLOW_CDROM
		return DRV_INVALID;
#else
		drv_info |= DRV_CDROM;
#endif
#endif /* PERFORM_CDROM_CHECK */


	/* All checks done, return information about drive, is valid */
	return drv_info;
   }
   return DRV_INVALID;
}
