/*  HTML Help Header File

    Copyright (c) Express Software 1998.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

#ifndef _HTML_H
#define _HTML_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "conio.h"

#define OK      0
#define FAILED -1
#define CANCEL -2

#define BORDER_COLOR (Yellow +BakBlue)
#define HEADER_COLOR (BrCyan +BakBlue)
#define TITLE_COLOR  (BrWhite+BakBlue)
#define TABLE_COLOR  (BrWhite+BakBlue)
#define INVAL_COLOR  (BrRed  +BakBlue)
#define ACTIVE_COLOR (BrWhite+BakBlack)
#define MENU_COLOR   (BrCyan +BakBlue)
#define HINT_COLOR   (Yellow +BakBlue)
#define MESG_COLOR   (BrGreen+BakBlue)
#define WARN_COLOR   (BrRed  +BakBlue)

#define  MAIN_BORDER  "ͻ ͼ"
#define  VERT_BORDER  "   "
#define  HRZN_BORDER  "        "

void get_base_dir(char *);
void html_view(char *target);
void start_gui(void);
int write_int(int attr, int x, int y, int w, unsigned long xx);
void parse_arg(char *str, char **argv, int argv_size);
void show_error(char *);
int enter_string(int x, int y, char *prompt, int maxlen, char *str, char *help);

#ifdef HTML_HELP

  struct event ev;
  int hd, select_target, mode, quiet;
  char tmp2[80], tmp3[80];

  int interactive;
  char buf[25*80*2], base_dir[256], tmp[512*3];

#define mesg(M)  char *M;

#else

  extern struct event ev;
  extern int hd, select_target, mode, quiet;
  extern char tmp2[80];
  extern char tmp3[80];

  extern int interactive;
  extern char buf[25*80*2];
  extern char base_dir[256];
  extern char tmp[512];

#define mesg(M)  extern char *M;

#endif
#endif
