{
    This file is the source for a series of routines to directly access the
    system's video memory.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit screen;

interface

uses dos;

type
  charinfo = record
    character : char;
    attribs : byte;
  end;

var
  segment, offset : word;

procedure get_xy (x, y : integer; var info : charinfo);
procedure put_xy (x, y : integer; c : char; attribs : byte);
procedure write_xy (x, y : byte; text : string; attribs : byte);
procedure fillarea (x1, y1, x2, y2 : byte; c : char; attribs : byte);
procedure cleararea (x1, y1, x2, y2, attribs : byte);

implementation

procedure get_xy (x, y : integer; var info : charinfo);
var
  r : registers;
  screen : ^char;
begin
  offset := (y * 160) + (x * 2);
  screen := ptr (segment, offset);
  info.character := screen^;
  screen := ptr (segment, offset + 1);
  info.attribs := byte (screen^);
end;

procedure put_xy (x, y : integer; c : char; attribs : byte);
var
  r : registers;
  screen : ^char;
begin
  offset := (y * 160) + (x * 2);
  screen := ptr (segment, offset);
  screen^ := c;
  screen := ptr (segment, offset + 1);
  screen^ := char (attribs);
end;

procedure write_xy (x, y : byte; text : string; attribs : byte);
var
  r : registers;
  screen : ^char;
  i : byte;
  c : byte;
begin
  offset := (y * 160) + (x * 2);
  c := 0;
  for i := 0 to (length (text) - 1) do begin
    screen := ptr (segment, offset + c);
    asm inc c end;
    screen^ := text [i + 1];
    screen := ptr (segment, offset + c);
    screen^ := char (attribs);
    asm inc c end;
  end;
end;

procedure fillarea (x1, y1, x2, y2 : byte; c : char; attribs : byte);
var
  x, y : byte;
begin
  for x := x1 to x2 do
    for y := y1 to y2 do
      put_xy (x, y, c, attribs);
end;

procedure cleararea (x1, y1, x2, y2, attribs : byte);
begin
  fillarea (x1, y1, x2, y2, ' ', attribs);
end;

var
  regs : registers;

begin
  write ('SCREEN.TPU initializing...');
  regs.ah := $0f;
  intr ($10, regs);
  segment := 0;
  if regs.al > 3 then
    exit;
  segment := $b800 + regs.bh * 256;
  offset := 0;
  writeln ('Done');
end.
