{
    This file is the source for a series of routines providing the
    functionality of linked lists.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit lists;

interface

uses strings;

type
  plistnode = ^listnode;
  listnode = record
    data : pchar;
    prevptr, nextptr : plistnode;
  end;
  list = object
  public
    procedure init;
    procedure ins (value : string);
    procedure del (value : string);
    function isempty : boolean;
    function atend : boolean;
    function count : longint;
    function get : string;
    function getitem (itemNumber : longint) : string;
    procedure free;
    procedure next;
    procedure prev;
    procedure reset;
  private
    current, sptr : plistnode;
  end;

implementation

procedure list.prev;
begin
  if current^.prevptr <> nil then
    current := current^.prevptr;
end;

function list.atend : boolean;
begin
  atend := current^.nextptr = nil;
end;

procedure list.next;
begin
  if current^.nextptr <> nil then
    current := current^.nextptr;
end;

procedure list.ins (value : string);
var
  newptr, previousptr, currentptr : plistnode;
  size : word;
begin
{ the following code inserts data in alphabetical order into the list
  new (newptr);
  newptr^.data := value;
  newptr^.nextptr := nil;
  previousptr := nil;
  currentptr := sptr;
  while (currentptr <> nil) and (value > currentptr^.data) do begin
    previousptr := currentptr;
    currentptr := currentptr^.nextptr;
  end;
  if previousptr = nil then begin
    newptr^.nextptr := sptr;
    sptr := newptr;
  end else begin
    previousptr^.nextptr := newptr;
    newptr^.nextptr := currentptr;
  end; }
  new (newptr);
  size := length (value) + 1;
  getmem (newptr^.data, size);
  strpcopy (newptr^.data, value);
  newptr^.nextptr := nil;
  newptr^.prevptr := nil;
  previousptr := nil;
  currentptr := sptr;
  while (currentptr <> nil) do begin
    previousptr := currentptr;
    currentptr := currentptr^.nextptr;
  end;
  if previousptr = nil then begin
    newptr^.nextptr := sptr;
    sptr := newptr;
  end else begin
    previousptr^.nextptr := newptr;
    newptr^.prevptr := previousptr;
    newptr^.nextptr := currentptr;
  end;
  current := sptr;
end;

procedure list.del (value : string);
var
  previousptr, currentptr, tempptr : plistnode;
  tempstr : string;
  size : word;
begin
  tempstr := strpas (sptr^.data);
  if value = tempstr then begin
    tempptr := sptr;
    sptr^.nextptr^.prevptr := nil;
    sptr := sptr^.nextptr;
    size := strlen (sptr^.data) + 1;
    freemem (sptr^.data, size);
    dispose (tempptr);
  end else begin
    previousptr := sptr;
    currentptr := sptr^.nextptr;
    tempstr := strpas (currentptr^.data);
    while (currentptr <> nil) and (tempstr <> value) do begin
      previousptr := currentptr;
      currentptr := currentptr^.nextptr;
      tempstr := strpas (currentptr^.data);
    end;
    if currentptr <> nil then begin
      tempptr := currentptr;
      previousptr^.nextptr := currentptr^.nextptr;
      currentptr^.nextptr^.prevptr := previousptr;
      size := strlen (tempptr^.data) + 1;
      freemem (tempptr^.data, size);
      dispose (tempptr);
    end;
  end;
  current := sptr;
end;

function list.isempty : boolean;
begin
  isempty := sptr = nil;
end;

function list.count : longint;
var
  temp : plistnode;
  i : longint;
begin
  temp := sptr;
  if (temp = NIL) then begin
    count := 0;
    exit;
  end else begin
    i := 0;
    while (temp <> nil) do begin
      inc (i);
      temp := temp^.nextptr;
    end;
    count := i;
  end;
end;

function list.getitem (itemNumber : longint) : string;
var
  currentptr : plistnode;
  currentItem : word;
  rv : pchar;
begin
  dec (itemnumber);
  currentPtr := sptr;
  currentItem := 1;
  rv := currentPtr^.data;
  if itemnumber > count then begin
    getitem := '';
    exit;
  end;
  if currentPtr <> nil then begin
    for currentitem := 1 to itemnumber do
      currentptr := currentptr^.nextptr;
    rv := currentptr^.data;
  end;
  getitem := strpas (rv);
end;

procedure list.free;
var
  currentPtr, tempptr : plistnode;
  size : word;
begin
  currentPtr := sPtr;
  while (currentPtr <> nil) do begin
    tempPtr := currentPtr;
    currentPtr := currentPtr^.nextptr;       { de-thread the node }
    size := strlen (tempptr^.data) + 1;
    freemem (tempptr^.data, size);
    dispose (tempPtr);                       { free the de-threaded node }
  end;
  sptr := nil;
end;

procedure list.init;
begin
  sptr := nil;
  current := nil;
end;

function list.get : string;
begin
  get := strpas (current^.data);
end;

procedure list.reset;
begin
  current := sptr;
end;

begin
  writeln ('LISTS.TPU initializing...Done');
end.
