/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1beta1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTriggerTemplates implements TriggerTemplateInterface
type FakeTriggerTemplates struct {
	Fake *FakeTriggersV1beta1
	ns   string
}

var triggertemplatesResource = v1beta1.SchemeGroupVersion.WithResource("triggertemplates")

var triggertemplatesKind = v1beta1.SchemeGroupVersion.WithKind("TriggerTemplate")

// Get takes name of the triggerTemplate, and returns the corresponding triggerTemplate object, and an error if there is any.
func (c *FakeTriggerTemplates) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.TriggerTemplate, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(triggertemplatesResource, c.ns, name), &v1beta1.TriggerTemplate{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.TriggerTemplate), err
}

// List takes label and field selectors, and returns the list of TriggerTemplates that match those selectors.
func (c *FakeTriggerTemplates) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.TriggerTemplateList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(triggertemplatesResource, triggertemplatesKind, c.ns, opts), &v1beta1.TriggerTemplateList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.TriggerTemplateList{ListMeta: obj.(*v1beta1.TriggerTemplateList).ListMeta}
	for _, item := range obj.(*v1beta1.TriggerTemplateList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested triggerTemplates.
func (c *FakeTriggerTemplates) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(triggertemplatesResource, c.ns, opts))

}

// Create takes the representation of a triggerTemplate and creates it.  Returns the server's representation of the triggerTemplate, and an error, if there is any.
func (c *FakeTriggerTemplates) Create(ctx context.Context, triggerTemplate *v1beta1.TriggerTemplate, opts v1.CreateOptions) (result *v1beta1.TriggerTemplate, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(triggertemplatesResource, c.ns, triggerTemplate), &v1beta1.TriggerTemplate{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.TriggerTemplate), err
}

// Update takes the representation of a triggerTemplate and updates it. Returns the server's representation of the triggerTemplate, and an error, if there is any.
func (c *FakeTriggerTemplates) Update(ctx context.Context, triggerTemplate *v1beta1.TriggerTemplate, opts v1.UpdateOptions) (result *v1beta1.TriggerTemplate, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(triggertemplatesResource, c.ns, triggerTemplate), &v1beta1.TriggerTemplate{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.TriggerTemplate), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTriggerTemplates) UpdateStatus(ctx context.Context, triggerTemplate *v1beta1.TriggerTemplate, opts v1.UpdateOptions) (*v1beta1.TriggerTemplate, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(triggertemplatesResource, "status", c.ns, triggerTemplate), &v1beta1.TriggerTemplate{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.TriggerTemplate), err
}

// Delete takes name of the triggerTemplate and deletes it. Returns an error if one occurs.
func (c *FakeTriggerTemplates) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(triggertemplatesResource, c.ns, name, opts), &v1beta1.TriggerTemplate{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTriggerTemplates) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(triggertemplatesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.TriggerTemplateList{})
	return err
}

// Patch applies the patch and returns the patched triggerTemplate.
func (c *FakeTriggerTemplates) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.TriggerTemplate, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(triggertemplatesResource, c.ns, name, pt, data, subresources...), &v1beta1.TriggerTemplate{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.TriggerTemplate), err
}
