// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package personalizeruntimeiface provides an interface to enable mocking the Amazon Personalize Runtime service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package personalizeruntimeiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/personalizeruntime"
)

// PersonalizeRuntimeAPI provides an interface to enable mocking the
// personalizeruntime.PersonalizeRuntime service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Personalize Runtime.
//	func myFunc(svc personalizeruntimeiface.PersonalizeRuntimeAPI) bool {
//	    // Make svc.GetActionRecommendations request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := personalizeruntime.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockPersonalizeRuntimeClient struct {
//	    personalizeruntimeiface.PersonalizeRuntimeAPI
//	}
//	func (m *mockPersonalizeRuntimeClient) GetActionRecommendations(input *personalizeruntime.GetActionRecommendationsInput) (*personalizeruntime.GetActionRecommendationsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockPersonalizeRuntimeClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type PersonalizeRuntimeAPI interface {
	GetActionRecommendations(*personalizeruntime.GetActionRecommendationsInput) (*personalizeruntime.GetActionRecommendationsOutput, error)
	GetActionRecommendationsWithContext(aws.Context, *personalizeruntime.GetActionRecommendationsInput, ...request.Option) (*personalizeruntime.GetActionRecommendationsOutput, error)
	GetActionRecommendationsRequest(*personalizeruntime.GetActionRecommendationsInput) (*request.Request, *personalizeruntime.GetActionRecommendationsOutput)

	GetPersonalizedRanking(*personalizeruntime.GetPersonalizedRankingInput) (*personalizeruntime.GetPersonalizedRankingOutput, error)
	GetPersonalizedRankingWithContext(aws.Context, *personalizeruntime.GetPersonalizedRankingInput, ...request.Option) (*personalizeruntime.GetPersonalizedRankingOutput, error)
	GetPersonalizedRankingRequest(*personalizeruntime.GetPersonalizedRankingInput) (*request.Request, *personalizeruntime.GetPersonalizedRankingOutput)

	GetRecommendations(*personalizeruntime.GetRecommendationsInput) (*personalizeruntime.GetRecommendationsOutput, error)
	GetRecommendationsWithContext(aws.Context, *personalizeruntime.GetRecommendationsInput, ...request.Option) (*personalizeruntime.GetRecommendationsOutput, error)
	GetRecommendationsRequest(*personalizeruntime.GetRecommendationsInput) (*request.Request, *personalizeruntime.GetRecommendationsOutput)
}

var _ PersonalizeRuntimeAPI = (*personalizeruntime.PersonalizeRuntime)(nil)
