/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.link;

import com.jidesoft.swing.MultilineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.DefaultDataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataModelImplementationDetails;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;

public class LinkGraphDialog
extends JDialog {
    private static final String PREF_KEY_LINK_SHEET_WIDTH = "Squirrel.graph.link.dlg.width";
    private static final String PREF_KEY_LINK_SHEET_HEIGHT = "Squirrel.graph.link.dlg.height";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(LinkGraphDialog.class);
    DataSetViewerTablePanel tblGraphFiles;
    JTextField txtDir;
    JButton btnExplore;
    JButton btnChangeDir;
    JButton btnHomeDir;
    JButton btnCreate;

    public LinkGraphDialog(GraphPlugin graphPlugin, ISession session) {
        super(SessionUtils.getOwningFrame((ISession)session), s_stringMgr.getString("linkGraph.dialog.title", new Object[]{session.getAlias().getUrl()}));
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        String lblText = s_stringMgr.getString("linkGraph.dialog.displayedFolder", new Object[]{session.getAlias().getUrl()});
        content.add((Component)new MultilineLabel(lblText), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
        this.txtDir = new JTextField();
        this.txtDir.setEditable(false);
        content.add((Component)this.txtDir, gbc);
        content.add((Component)new MultilineLabel(lblText), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        content.add((Component)this.createFolderButtonsPanel(), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0);
        content.add((Component)new JLabel(s_stringMgr.getString("linkGraph.dialog.graphsInFolder")), gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tblGraphFiles = new DataSetViewerTablePanel();
        this.tblGraphFiles.init(null, 2, (IDataModelImplementationDetails)new DefaultDataModelImplementationDetails(session));
        content.add((Component)new JScrollPane(this.tblGraphFiles.getComponent()), gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        content.add((Component)this.createButtonPanel(session, content), gbc);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(content);
        this.setSize(this.getDimension());
        GUIUtils.centerWithinParent((Window)this);
        GUIUtils.enableCloseByEscape((JDialog)this);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LinkGraphDialog.this.onWindowClosing();
            }
        });
    }

    private JPanel createButtonPanel(ISession session, JPanel content) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0);
        this.btnCreate = new JButton(s_stringMgr.getString("linkGraph.dialog.btnCreate"));
        ret.add((Component)this.btnCreate, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 3, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("linkGraph.dialog.createLinksLabel", new Object[]{session.getAlias().getUrl()})), gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private void onWindowClosing() {
        Dimension size = this.getSize();
        Preferences.userRoot().putInt(PREF_KEY_LINK_SHEET_WIDTH, size.width);
        Preferences.userRoot().putInt(PREF_KEY_LINK_SHEET_HEIGHT, size.height);
    }

    private JPanel createFolderButtonsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.btnChangeDir = new JButton(s_stringMgr.getString("linkGraph.dialog.changeFolder"));
        pnl.add((Component)this.btnChangeDir, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.btnHomeDir = new JButton(s_stringMgr.getString("linkGraph.dialog.toHomeDir"));
        pnl.add((Component)this.btnHomeDir, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.btnExplore = new JButton(s_stringMgr.getString("linkGraph.dialog.openFolderInExplorer"));
        pnl.add((Component)this.btnExplore, gbc);
        return pnl;
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt(PREF_KEY_LINK_SHEET_WIDTH, 800), Preferences.userRoot().getInt(PREF_KEY_LINK_SHEET_HEIGHT, 500));
    }
}

