/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.type.CollectionType;

public abstract class EJB3CascadingAction
extends CascadingAction {
    private static Log log = LogFactory.getLog(CascadingAction.class);
    public static final CascadingAction PERSIST_SKIPLAZY = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to persist: " + entityName));
            }
            session.persist(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getLoadedElementsIterator((SessionImplementor)session, (CollectionType)collectionType, (Object)collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST_SKIPLAZY";
        }
    };
}

