/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class TimestampIndexedColumn
extends IndexedColumn {
    private LongRange _longRange = new LongRange();

    public TimestampIndexedColumn(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        super(rows, colIx, colDef);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object ix1, Object ix2) {
                if (ix1 instanceof NoIx && ix2 instanceof NoIx) {
                    return TimestampIndexedColumn.this.compareUtilDate(((NoIx)ix1).get(), ((NoIx)ix2).get());
                }
                if (ix1 instanceof NoIx) {
                    return TimestampIndexedColumn.this.compareUtilDate(((NoIx)ix1).get(), TimestampIndexedColumn.this.getRow((Integer)ix2));
                }
                if (ix2 instanceof NoIx) {
                    return TimestampIndexedColumn.this.compareUtilDate(TimestampIndexedColumn.this.getRow((Integer)ix1), ((NoIx)ix2).get());
                }
                return TimestampIndexedColumn.this.compareUtilDate(TimestampIndexedColumn.this.getRow((Integer)ix1), TimestampIndexedColumn.this.getRow((Integer)ix2));
            }
        };
        this._longRange.beginInit();
        this.sortIx(comparator);
        this._longRange.endInit();
    }

    private int compareUtilDate(Object o1, Object o2) {
        Long t1 = null;
        if (null != o1) {
            t1 = ((Date)o1).getTime();
        }
        Long t2 = null;
        if (null != o2) {
            t2 = ((Date)o2).getTime();
        }
        this._longRange.init(t1);
        this._longRange.init(t2);
        if (t1 == null && t2 != null) {
            return -1;
        }
        if (t1 != null && t2 == null) {
            return 1;
        }
        if (t1 == null && t2 == null) {
            return 0;
        }
        return t1.compareTo(t2);
    }

    @Override
    public Calculator getCalculator() {
        return new Calculator(){

            public Object getMid(Object min, Object max) {
                return TimestampIndexedColumn.this.onGetMid(min, max);
            }
        };
    }

    @Override
    public String calculateDist(Object beginData, Object endData) {
        if (null == beginData || null == endData) {
            return "0";
        }
        Date dBeg = (Date)beginData;
        Date dEnd = (Date)endData;
        long diff = dEnd.getTime() - dBeg.getTime();
        long diffInDays = diff / 1000L / 86400L;
        long diffInHours = (diff / 1000L - 86400L * diffInDays) / 3600L;
        long diffInMins = (diff / 1000L - 86400L * diffInDays - 3600L * diffInHours) / 60L;
        long diffInSecs = diff / 1000L - 86400L * diffInDays - 3600L * diffInHours - 60L * diffInMins;
        long diffMillis = diff % 1000L;
        if (0L == diff) {
            return "0";
        }
        String ret = "(";
        if (0L < diffInDays) {
            ret = ret + diffInDays + " days  ";
        }
        if (0L < diffInHours) {
            ret = ret + diffInHours + " hours  ";
        }
        if (0L < diffInMins) {
            ret = ret + diffInMins + " minutes  ";
        }
        if (0L < diffInSecs) {
            ret = ret + diffInSecs + " seconds  ";
        }
        if (0L < diffMillis) {
            ret = ret + diffMillis + " millis ";
        }
        return ret.trim() + ")";
    }

    private Object onGetMid(Object min, Object max) {
        Long longMin = null == min ? Long.valueOf(this._longRange.getMin() - 1L) : Long.valueOf(((Date)min).getTime());
        Long longMax = null == max ? Long.valueOf(this._longRange.getMin() - 1L) : Long.valueOf(((Date)max).getTime());
        return new Timestamp(longMin + (longMax - longMin) / 2L);
    }

    private static class LongRange {
        private long _max;
        private long _min;
        private boolean _initializing;
        private boolean _isInit;

        private LongRange() {
            this._min = this._max = System.currentTimeMillis();
        }

        public void init(Long l) {
            if (!this._initializing) {
                return;
            }
            if (null == l) {
                return;
            }
            if (!this._isInit) {
                this._min = l;
                this._max = l;
                this._isInit = true;
            }
            this._min = Math.min(this._min, l);
            this._max = Math.max(this._max, l);
        }

        public long getMin() {
            return this._min;
        }

        void beginInit() {
            this._initializing = true;
        }

        void endInit() {
            this._initializing = false;
        }
    }
}

