/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.mainframe.action.OpenConnectionCommandListener;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.BaseException;

public class OpenConnectionCommand {
    private IApplication _app;
    private ISQLAlias _sqlAlias;
    private final String _userName;
    private final String _password;
    private final SQLDriverPropertyCollection _props;
    private SQLConnection _conn;

    public OpenConnectionCommand(IApplication app, ISQLAlias sqlAlias, String userName, String password, SQLDriverPropertyCollection props) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null ISQLAlias passed");
        }
        this._app = app;
        this._sqlAlias = sqlAlias;
        this._userName = userName;
        this._password = password;
        this._props = props;
    }

    public void execute(final OpenConnectionCommandListener openConnectionCommandListener) throws BaseException {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Runnable taskConnect = new Runnable(){

            @Override
            public void run() {
                OpenConnectionCommand.this.executeConnect();
            }
        };
        final Future<?> future = executorService.submit(taskConnect);
        Runnable taskAwaitConnect = new Runnable(){

            @Override
            public void run() {
                OpenConnectionCommand.this.awaitConnection(future, openConnectionCommandListener);
            }
        };
        executorService.submit(taskAwaitConnect);
    }

    public void executeAndWait() {
        this.executeConnect();
    }

    private void awaitConnection(Future future, final OpenConnectionCommandListener openConnectionCommandListener) {
        try {
            if (0 < DriverManager.getLoginTimeout()) {
                future.get(DriverManager.getLoginTimeout(), TimeUnit.SECONDS);
            } else {
                future.get();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    openConnectionCommandListener.openConnectionFinished(null);
                }
            });
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    openConnectionCommandListener.openConnectionFinished(t);
                }
            });
        }
    }

    private void executeConnect() {
        this._conn = null;
        IIdentifier driverID = this._sqlAlias.getDriverIdentifier();
        ISQLDriver sqlDriver = this._app.getDataCache().getDriver(driverID);
        SQLDriverManager mgr = this._app.getSQLDriverManager();
        try {
            this._conn = mgr.getConnection(sqlDriver, this._sqlAlias, this._userName, this._password, this._props);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public SQLConnection getSQLConnection() {
        return this._conn;
    }
}

