/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.spi.model.services.CsmExpressionEvaluatorProvider;
import org.openide.util.Lookup;

public class CsmExpressionEvaluator {
    private static final CsmExpressionEvaluatorProvider EMPTY_PROVIDER = new EmptyExpressionEvaluator();
    private static CsmExpressionEvaluatorProvider defaultProvider;

    private CsmExpressionEvaluator() {
    }

    public static synchronized CsmExpressionEvaluatorProvider getProvider() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        defaultProvider = (CsmExpressionEvaluatorProvider)Lookup.getDefault().lookup(CsmExpressionEvaluatorProvider.class);
        return defaultProvider == null ? EMPTY_PROVIDER : defaultProvider;
    }

    public static Object eval(String expr, CsmScope scope) {
        return CsmExpressionEvaluator.getProvider().eval(expr, scope);
    }

    public static Object eval(String expr, CsmInstantiation inst, CsmScope scope) {
        return CsmExpressionEvaluator.getProvider().eval(expr, inst, scope);
    }

    public static Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        return CsmExpressionEvaluator.getProvider().eval(expr, decl, scope, mapping);
    }

    public static boolean isValid(Object evaluated) {
        return CsmExpressionEvaluator.getProvider().isValid(evaluated);
    }

    private static final class EmptyExpressionEvaluator
    implements CsmExpressionEvaluatorProvider {
        EmptyExpressionEvaluator() {
        }

        @Override
        public Object eval(String expr, CsmScope scope) {
            return expr;
        }

        @Override
        public Object eval(String expr, CsmInstantiation inst, CsmScope scope) {
            return expr;
        }

        @Override
        public Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            return expr;
        }

        @Override
        public Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, CsmFile expressionFile, int startOffset, int endOffset, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            return expr;
        }

        @Override
        public boolean isValid(Object evaluated) {
            return false;
        }
    }
}

