/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.export;

import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.export.Export;
import org.netbeans.modules.subversion.remote.util.CheckoutCompleted;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ExportAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Export";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -4;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.isCacheReady() && this.getCachedContext(nodes).getRoots().size() > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        VCSFileProxy[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length != 1) {
            return;
        }
        VCSFileProxy[] files = Subversion.getInstance().getStatusCache().listFiles(ctx, 88532);
        VCSFileProxy fromFile = roots[0];
        RequestProcessor rp = this.createRequestProcessor(ctx);
        boolean hasChanges = files.length > 0;
        Export export = new Export(fromFile, hasChanges);
        if (export.showDialog()) {
            this.performExport(export, rp, nodes, roots);
        }
    }

    private void performExport(final Export export, final RequestProcessor rp, final Node[] nodes, VCSFileProxy[] roots) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(ExportAction.this, nodes, ExportAction.this.getCachedContext(nodes)){

                    @Override
                    public void perform() {
                        VCSFileProxy fromFile = export.getFromFile();
                        VCSFileProxy toFile = export.getToFile();
                        VCSFileProxySupport.mkdir((VCSFileProxy)toFile);
                        if (this.isCanceled()) {
                            return;
                        }
                        try {
                            SvnClient client = Subversion.getInstance().getClient(fromFile);
                            client.doExport(fromFile, toFile, true);
                        }
                        catch (SVNClientException ex) {
                            SvnClientExceptionHandler.notifyException(new Context(fromFile), ex, true, true);
                            return;
                        }
                        if (export.getScanAfterExport()) {
                            CheckoutCompleted cc = new CheckoutCompleted(toFile, new String[]{"."});
                            if (this.isCanceled()) {
                                return;
                            }
                            cc.scanForProjects(this, CheckoutCompleted.Type.EXPORT);
                        }
                    }
                };
                support.start(rp);
            }
        });
    }
}

