/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GrailsSources
extends FileChangeAdapter
implements Sources {
    public static final List KNOWN_FOLDERS = Arrays.asList("docs", "grails-app", "lib", "scripts", "src", "test", "web-app");
    public static final List KNOWN_FOLDERS_IN_GRAILS_APP = Arrays.asList("conf", "controllers", "domain", "i18n", "services", "taglib", "utils", "views");
    public static final List KNOWN_OR_IGNORED_FOLDERS_IN_TEST = Arrays.asList("unit", "integration", "reports");
    public static final List IGNORED_FOLDERS_IN_GRAILS_APP = Arrays.asList("target", "gradle");
    private final FileObject projectDir;
    private final GrailsProject project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private GrailsSources(GrailsProject project) {
        this.project = project;
        this.projectDir = project.getProjectDirectory();
    }

    static GrailsSources create(GrailsProject project) {
        GrailsSources sources = new GrailsSources(project);
        sources.startFSListener();
        return sources;
    }

    private void startFSListener() {
        try {
            FileSystem fs = this.projectDir.getFileSystem();
            fs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fs));
        }
        catch (FileStateInvalidException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    public SourceGroup[] getSourceGroups(String type) {
        ArrayList<Group> result = new ArrayList<Group>();
        if ("generic".equals(type)) {
            this.addGroup(this.projectDir, this.projectDir.getName(), result);
        } else if ("java".equals(type)) {
            this.addGroup(SourceCategory.SRC_JAVA, "LBL_SrcJava", result);
        } else if ("groovy".equals(type)) {
            this.addGroup(SourceCategory.GRAILSAPP_CONF, "LBL_grails-app_conf", result);
            this.addGroup(SourceCategory.GRAILSAPP_CONTROLLERS, "LBL_grails-app_controllers", result);
            this.addGroup(SourceCategory.GRAILSAPP_DOMAIN, "LBL_grails-app_domain", result);
            this.addGroup(SourceCategory.GRAILSAPP_SERVICES, "LBL_grails-app_services", result);
            this.addGroup(SourceCategory.GRAILSAPP_TAGLIB, "LBL_grails-app_taglib", result);
            this.addGroup(SourceCategory.GRAILSAPP_UTILS, "LBL_grails-app_utils", result);
            this.addGroup(SourceCategory.SCRIPTS, "LBL_scripts", result);
            this.addGroup(SourceCategory.SRC_GROOVY, "LBL_SrcGroovy", result);
            this.addGroup(SourceCategory.TEST_INTEGRATION, "LBL_IntegrationTests", result);
            this.addGroup(SourceCategory.TEST_UNIT, "LBL_UnitTests", result);
        } else if ("grails".equals(type)) {
            this.addGroup(SourceCategory.LIB, "LBL_lib", result);
            this.addGroup(SourceCategory.GRAILSAPP_I18N, "LBL_grails-app_i18n", result);
            this.addGroup(SourceCategory.WEBAPP, "LBL_web-app", result);
            this.addGroup(SourceCategory.GRAILSAPP_VIEWS, "LBL_grails-app_views", result);
            this.addGroup(SourceCategory.TEMPLATES, "LBL_grails-templates", result);
        } else if ("grails_unknown".equals(type)) {
            File pluginsDirFile = this.project.getBuildConfig().getProjectPluginsDir();
            FileObject pluginsDir = pluginsDirFile == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)pluginsDirFile));
            File globalPluginsDirFile = this.project.getBuildConfig().getGlobalPluginsDir();
            FileObject globalPluginsDir = globalPluginsDirFile == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)globalPluginsDirFile));
            for (FileObject child : this.projectDir.getChildren()) {
                if (!child.isFolder() || !VisibilityQuery.getDefault().isVisible(child) || KNOWN_FOLDERS.contains(child.getName()) || IGNORED_FOLDERS_IN_GRAILS_APP.contains(child.getName()) || child == pluginsDir || child == globalPluginsDir) continue;
                String name = child.getName();
                this.addGroup(child, Character.toUpperCase(name.charAt(0)) + name.substring(1), result);
            }
            this.addGroup(SourceCategory.SRC_GWT, "LBL_SrcGwt", result);
            this.addUnknownGroups(KNOWN_FOLDERS_IN_GRAILS_APP, result, "grails-app", null);
            this.addUnknownGroups(KNOWN_OR_IGNORED_FOLDERS_IN_TEST, result, "test", "LBL_SomeTests");
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void fileDeleted(FileEvent fe) {
        this.changeSupport.fireChange();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.changeSupport.fireChange();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.changeSupport.fireChange();
    }

    private void addUnknownGroups(Collection<String> alreadyKnown, List<Group> result, String relativePath, String bundleKey) {
        FileObject folder = this.projectDir.getFileObject(relativePath);
        if (folder != null) {
            for (FileObject child : folder.getChildren()) {
                if (!child.isFolder() || !VisibilityQuery.getDefault().isVisible(child) || alreadyKnown.contains(child.getName())) continue;
                String name = child.getName();
                String localizedName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                if (bundleKey != null) {
                    localizedName = NbBundle.getMessage(GrailsSources.class, (String)bundleKey, (Object)localizedName);
                }
                this.addGroup(child, localizedName, result);
            }
        }
    }

    private void addGroup(FileObject fileObject, String displayName, List<Group> list) {
        if (fileObject != null) {
            list.add(new Group(fileObject, displayName));
        }
    }

    private void addGroup(SourceCategory sourceCategory, String bundleLabel, List<Group> list) {
        FileObject fileObject = this.projectDir.getFileObject(sourceCategory.getRelativePath());
        if (fileObject != null) {
            list.add(new Group(fileObject, NbBundle.getMessage(GrailsSources.class, (String)bundleLabel)));
        }
    }

    private final class Group
    implements SourceGroup {
        private final FileObject loc;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final String displayName;

        public Group(FileObject loc, String displayName) {
            this.loc = loc;
            this.displayName = displayName;
        }

        public FileObject getRootFolder() {
            return this.loc;
        }

        public String getName() {
            String location = this.loc.getPath();
            return location.length() > 0 ? location : "generic";
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) throws IllegalArgumentException {
            if (file == this.loc) {
                return true;
            }
            String path = FileUtil.getRelativePath((FileObject)this.loc, (FileObject)file);
            if (path == null) {
                throw new IllegalArgumentException();
            }
            if (file.isFolder()) {
                path = path + File.separator;
            }
            if (file.isFolder() && file != GrailsSources.this.projectDir && ProjectManager.getDefault().isProject(file)) {
                return false;
            }
            File f = FileUtil.toFile((FileObject)file);
            return f == null || SharabilityQuery.getSharability((File)f) != 2;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public String toString() {
            return "GrailsSources.Group[name=" + this.getName() + ",rootFolder=" + this.getRootFolder() + "]";
        }
    }
}

