/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jpcsclite;

public class APDU {
    public static final int CLA = 0;
    public static final int INS = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;
    public static final int P3 = 4;
    public static final int CASE_1 = 1;
    public static final int CASE_2S = 2;
    public static final int CASE_3S = 3;
    public static final int CASE_4S = 4;
    public static final int CASE_2E = 5;
    public static final int CASE_3E = 6;
    public static final int CASE_4E = 7;
    public static final int LOGICAL_CHN_MASK = 3;
    public static final int APDU_TYPE_MASK = 240;
    static final int CMD_HDR_BYTES = 4;
    public byte[] command;
    public int Lc;
    public byte[] dataIn;
    public int Le;
    public byte[] dataOut;
    public byte[] sw1sw2;
    public final short APDU_BUFFER_LENGTH = (short)133;
    private final short BUFFERSIZE = (short)133;
    private byte[] buffer;

    public APDU() {
        this.command = new byte[5];
        this.Lc = 0;
        this.dataIn = null;
        this.Le = 0;
        this.dataOut = null;
        this.sw1sw2 = new byte[2];
    }

    public APDU(byte[] buf) {
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.buffer.length;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public byte[] getDataIn() {
        return this.dataIn;
    }

    public void setDataIn(byte[] dataIn) {
        this.dataIn = dataIn;
        this.Lc = dataIn == null ? 0 : dataIn.length;
    }

    public void setDataIn(byte[] dataIn, int length) {
        this.dataIn = dataIn;
        this.Lc = length;
    }

    public int getLc() {
        return this.Lc;
    }

    public void setDataOut(byte[] dataOut) {
        this.dataOut = dataOut;
        this.Le = dataOut == null ? 0 : dataOut.length;
    }

    public void setDataOut(byte[] dataOut, int length) {
        this.dataOut = dataOut;
        if (dataOut == null && length > 0) {
            throw new IllegalArgumentException();
        }
        if (dataOut.length < length) {
            throw new IllegalArgumentException();
        }
        this.Le = length;
    }

    public int getLe() {
        return this.Le;
    }

    public byte[] getDataOut() {
        return this.dataOut;
    }

    public byte[] getSw1Sw2() {
        return this.sw1sw2;
    }

    public int getStatus() {
        return ((this.sw1sw2[0] & 0xFF) << 8 | this.sw1sw2[1] & 0xFF) & 0xFFFF;
    }

    public int getCase() {
        if (this.Lc == 0 && this.Le >= 0 && this.Le < 256) {
            return 2;
        }
        if (this.Lc == 0 && this.Le > 256) {
            return 5;
        }
        if (this.Lc > 256 && this.Le == 0) {
            return 6;
        }
        if (this.Lc > 0 && this.Lc <= 255 && this.Le >= 0 && this.Le < 256) {
            return 4;
        }
        return 7;
    }

    public byte getChannelInfo() {
        byte theAPDUChannel = (byte)(this.command[0] & 3);
        byte theAPDUType = (byte)(this.command[0] & 0xFFFFFFF0);
        if (theAPDUType != 0 && theAPDUType != -128 && theAPDUType != -112 && theAPDUType != -96) {
            return 0;
        }
        return theAPDUChannel;
    }

    public byte[] getCommandApduBytes() {
        byte[] newApdu = new byte[5 + this.Lc + 1];
        System.arraycopy(this.command, 0, newApdu, 0, 4);
        newApdu[4] = (byte)this.Lc;
        if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, newApdu, 5, this.Lc);
        }
        newApdu[5 + this.Lc] = (byte)this.Le;
        return newApdu;
    }

    public byte[] getResponseApduBytes() {
        byte[] newApdu = new byte[5 + this.Lc + 1 + this.Le + 2];
        System.arraycopy(this.command, 0, newApdu, 0, 4);
        newApdu[this.command.length] = (byte)this.Lc;
        if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, newApdu, 5, this.Lc);
        }
        newApdu[this.command.length + 1 + this.Lc] = (byte)this.Le;
        if (this.dataOut.length != 0) {
            System.arraycopy(this.dataOut, 0, newApdu, 5 + this.Lc + 1, this.Le);
        }
        System.arraycopy(this.sw1sw2, 0, newApdu, newApdu.length - 2, 2);
        return newApdu;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("CLA: " + APDU.byteHexString(this.command[0]) + ", ");
        sb.append("INS: " + APDU.byteHexString(this.command[1]) + ", ");
        sb.append("P1: " + APDU.byteHexString(this.command[2]) + ", ");
        sb.append("P2: " + APDU.byteHexString(this.command[3]) + ", ");
        sb.append("Lc: " + APDU.byteHexString(this.Lc));
        for (i = 0; i < this.Lc; ++i) {
            sb.append(", " + APDU.byteHexString(this.dataIn[i]));
        }
        sb.append(", Le: " + APDU.byteHexString(this.Le));
        if (this.dataOut != null) {
            for (i = 0; i < this.Le && i < this.dataOut.length; ++i) {
                sb.append(", " + APDU.byteHexString(this.dataOut[i]));
            }
        }
        sb.append(", SW1: " + APDU.byteHexString(this.sw1sw2[0]));
        sb.append(", SW2: " + APDU.byteHexString(this.sw1sw2[1]));
        return sb.toString();
    }

    private static String byteHexString(int data) {
        StringBuffer sb = new StringBuffer();
        if ((data & 0xFF) < 16) {
            sb.append("0");
        }
        sb.append(Integer.toHexString(data & 0xFF));
        return sb.toString();
    }

    public static String byteArrayHexString(byte[] array) {
        return APDU.byteArrayHexString(array, ":");
    }

    public static String byteArrayHexString(byte[] array, String delimiter) {
        StringBuffer sb = new StringBuffer();
        if (array == null) {
            return "";
        }
        for (byte element : array) {
            sb.append(APDU.byteHexString(element) + delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }
}

