/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.options;

import java.util.List;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.options.Bundle;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;

public final class AnalysisOptionsValidator {
    private final ValidationResult result = new ValidationResult();

    public AnalysisOptionsValidator validateCodeSniffer(String codeSnifferPath, String codeSnifferStandard) {
        this.validateCodeSnifferPath(codeSnifferPath);
        this.validateCodeSnifferStandard(codeSnifferStandard);
        return this;
    }

    public AnalysisOptionsValidator validateMessDetector(String messDetectorPath, List<String> messDetectorRuleSets) {
        this.validateMessDetectorPath(messDetectorPath);
        this.validateMessDetectorRuleSets(messDetectorRuleSets);
        return this;
    }

    public AnalysisOptionsValidator validateCodingStandardsFixer(String codingStandardsFixerPath) {
        this.validateCodingStandardsFixerPath(codingStandardsFixerPath);
        return this;
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public AnalysisOptionsValidator validateCodeSnifferPath(String codeSnifferPath) {
        String warning = CodeSniffer.validate(codeSnifferPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"codeSniffer.path", warning));
        }
        return this;
    }

    public AnalysisOptionsValidator validateCodeSnifferStandard(String codeSnifferStandard) {
        if (!StringUtils.hasText((String)codeSnifferStandard)) {
            this.result.addWarning(new ValidationResult.Message((Object)"codeSniffer.standard", Bundle.AnalysisOptionsValidator_codeSniffer_standard_empty()));
        }
        return this;
    }

    private AnalysisOptionsValidator validateMessDetectorPath(String messDetectorPath) {
        String warning = MessDetector.validate(messDetectorPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"messDetector.path", warning));
        }
        return this;
    }

    public AnalysisOptionsValidator validateMessDetectorRuleSets(List<String> messDetectorRuleSets) {
        if (messDetectorRuleSets.isEmpty()) {
            this.result.addWarning(new ValidationResult.Message((Object)"messDetector.ruleSets", Bundle.AnalysisOptionsValidator_messDetector_ruleSets_empty()));
        }
        return this;
    }

    private AnalysisOptionsValidator validateCodingStandardsFixerPath(String codingStandardsFixerPath) {
        String warning = CodingStandardsFixer.validate(codingStandardsFixerPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"codingStandardsFixer.path", warning));
        }
        return this;
    }
}

