/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.ui.PlatformsComboBoxModel;
import org.netbeans.modules.j2me.project.ui.SourceLevelComboBoxModel;
import org.netbeans.modules.java.api.common.ui.PlatformFilter;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;

public class J2MEProjectUtils {
    private static ButtonGroup configurationsGroup;
    private static ButtonGroup profilesGroup;
    private static ArrayList<JCheckBox> optionalPackages;
    private static HashMap<String, J2MEPlatform.J2MEProfile> name2profileAll;

    public static ComboBoxModel createPlatformComboBoxModel() {
        return new DefaultComboBoxModel<JavaPlatform>(J2MEProjectUtils.readPlatforms());
    }

    public static ButtonGroup getConfigurationsButtonGroup() {
        return configurationsGroup;
    }

    public static ButtonGroup getProfilesButtonGroup() {
        return profilesGroup;
    }

    public static ArrayList<JCheckBox> getOptionalPackages() {
        return optionalPackages;
    }

    public static HashMap<J2MEPlatform.Device, List<String>> getOptionalPackagesForDevices() {
        JavaPlatform[] platforms;
        HashMap<J2MEPlatform.Device, List<String>> devices2packages = new HashMap<J2MEPlatform.Device, List<String>>();
        for (JavaPlatform jp : platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", new SpecificationVersion("8.0")))) {
            J2MEPlatform.Device[] devices;
            if (!(jp instanceof J2MEPlatform)) continue;
            for (J2MEPlatform.Device device : devices = ((J2MEPlatform)jp).getDevices()) {
                J2MEPlatform.J2MEProfile[] profiles;
                ArrayList<String> deviceProfiles = new ArrayList<String>();
                devices2packages.put(device, deviceProfiles);
                for (J2MEPlatform.J2MEProfile profile : profiles = device.getProfiles()) {
                    if (!profile.getType().equals("optional")) continue;
                    deviceProfiles.add(profile.toString());
                }
            }
        }
        return devices2packages;
    }

    public static HashMap<String, J2MEPlatform.J2MEProfile> getNameToProfileMap() {
        if (name2profileAll == null || name2profileAll.isEmpty()) {
            J2MEProjectUtils.readPlatforms();
        }
        return name2profileAll;
    }

    public static JavaPlatform[] readPlatforms() {
        configurationsGroup = new ButtonGroup();
        profilesGroup = new ButtonGroup();
        optionalPackages = new ArrayList();
        name2profileAll = new HashMap();
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", new SpecificationVersion("8.0")));
        Arrays.sort(platforms, new Comparator<JavaPlatform>(){

            @Override
            public int compare(JavaPlatform o1, JavaPlatform o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> cfg = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> prof = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> opt = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        for (JavaPlatform platform1 : platforms) {
            Profile[] profiles;
            if (!(platform1 instanceof J2MEPlatform)) continue;
            J2MEPlatform platform = (J2MEPlatform)platform1;
            block11: for (Profile profile : profiles = platform.getSpecification().getProfiles()) {
                if (!(profile instanceof J2MEPlatform.J2MEProfile)) continue;
                J2MEPlatform.J2MEProfile p = (J2MEPlatform.J2MEProfile)profile;
                name2profileAll.put(p.toString(), p);
                switch (p.getType()) {
                    case "configuration": {
                        p = J2MEProjectUtils.takeBetter(p, (J2MEPlatform.J2MEProfile)cfg.remove(p));
                        cfg.put(p, p);
                        continue block11;
                    }
                    case "profile": {
                        p = J2MEProjectUtils.takeBetter(p, (J2MEPlatform.J2MEProfile)prof.remove(p));
                        prof.put(p, p);
                        continue block11;
                    }
                    case "optional": {
                        p = J2MEProjectUtils.takeBetter(p, (J2MEPlatform.J2MEProfile)opt.remove(p));
                        opt.put(p, p);
                    }
                }
            }
        }
        J2MEPlatform.J2MEProfile[] arr = cfg.values().toArray(new J2MEPlatform.J2MEProfile[cfg.size()]);
        J2MEProjectUtils.initAllConfigurations(arr);
        arr = prof.values().toArray(new J2MEPlatform.J2MEProfile[prof.size()]);
        J2MEProjectUtils.initAllProfiles(arr);
        arr = opt.values().toArray(new J2MEPlatform.J2MEProfile[opt.size()]);
        J2MEProjectUtils.initAllOptionalPackages(arr);
        return platforms;
    }

    private static J2MEPlatform.J2MEProfile takeBetter(J2MEPlatform.J2MEProfile p1, J2MEPlatform.J2MEProfile p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return p1.getDisplayNameWithVersion().length() > p2.getDisplayNameWithVersion().length() ? p1 : p2;
    }

    private static void initAllConfigurations(J2MEPlatform.J2MEProfile[] cfgs) {
        Arrays.sort(cfgs);
        for (J2MEPlatform.J2MEProfile cfg : cfgs) {
            JRadioButton btn = new JRadioButton(cfg.toString());
            btn.setToolTipText(cfg.getDisplayNameWithVersion());
            btn.setActionCommand(cfg.toString());
            configurationsGroup.add(btn);
        }
    }

    private static void initAllProfiles(J2MEPlatform.J2MEProfile[] profs) {
        Arrays.sort(profs);
        for (J2MEPlatform.J2MEProfile prof : profs) {
            JRadioButton btn = new JRadioButton(prof.toString());
            btn.setToolTipText(prof.getDisplayNameWithVersion());
            btn.setActionCommand(prof.toString());
            profilesGroup.add(btn);
        }
    }

    private static void initAllOptionalPackages(J2MEPlatform.J2MEProfile[] opts) {
        Arrays.sort(opts, new Comparator<J2MEPlatform.J2MEProfile>(){

            @Override
            public int compare(J2MEPlatform.J2MEProfile o1, J2MEPlatform.J2MEProfile o2) {
                return o1.getDisplayNameWithVersion().compareTo(o2.getDisplayNameWithVersion());
            }
        });
        for (J2MEPlatform.J2MEProfile opt : opts) {
            String dName = opt.isNameIsJarFileName() ? opt.getDisplayName() : opt.getDisplayNameWithVersion();
            JCheckBox cb = new JCheckBox(dName);
            cb.setToolTipText(dName);
            cb.setActionCommand(opt.toString());
            optionalPackages.add(cb);
        }
    }

    public static ComboBoxModel createJDKPlatformComboBoxModel() {
        return new PlatformsComboBoxModel(PlatformUiSupport.createPlatformComboBoxModel(null, Arrays.asList(new PlatformFilter(){

            public boolean accept(JavaPlatform platform) {
                return new SpecificationVersion("1.8").compareTo((Object)platform.getSpecification().getVersion()) <= 0;
            }
        })));
    }

    public static ListCellRenderer createJDKPlatformListCellRenderer() {
        return PlatformUiSupport.createPlatformListCellRenderer();
    }

    public static String getJadURL(AntProjectHelper helper) {
        FileObject fo = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        URL base = URLMapper.findURL((FileObject)fo, (int)2);
        if (base == null) {
            return null;
        }
        PropertyEvaluator eval = helper.getStandardPropertyEvaluator();
        try {
            URL newURL = new URL(base.getProtocol(), "localhost", base.getPort(), J2MEProjectUtils.encodeURL("/servlet/org.netbeans.modules.j2me.project.ota.JAMServlet/" + helper.getProjectDirectory().getPath() + "/" + eval.evaluate("${dist.dir}/${dist.jad}")));
            return newURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private static String encodeURL(String orig) {
        StringTokenizer slashTok = new StringTokenizer(orig, "/", true);
        StringBuffer path = new StringBuffer();
        while (slashTok.hasMoreTokens()) {
            String tok = slashTok.nextToken();
            if (tok.startsWith("/")) {
                path.append(tok);
                continue;
            }
            try {
                path.append(URLEncoder.encode(tok, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                path.append(URLEncoder.encode(tok));
            }
        }
        return path.toString();
    }

    public static SourceLevelComboBoxModel.SourceLevelListCellRenderer createSourceLevelListCellRenderer() {
        return new SourceLevelComboBoxModel.SourceLevelListCellRenderer();
    }

    public static boolean isLibraryLiblet(File file) {
        if (file.exists()) {
            try {
                JarFile jar = new JarFile(file);
                Attributes manifestAttributes = jar.getManifest().getMainAttributes();
                return manifestAttributes.containsKey(new Attributes.Name("LIBlet-Name"));
            }
            catch (IOException ex) {
                Logger.getLogger(J2MEProjectUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public static boolean isLibraryLiblet(Project project) {
        J2MEProject j2meProj;
        String propVal;
        if (project != null && project instanceof J2MEProject && (propVal = (j2meProj = (J2MEProject)project).evaluator().getProperty("manifest.is.liblet")) != null) {
            return Boolean.parseBoolean(propVal);
        }
        return false;
    }
}

