/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.event.SimpleProfilingStateAdapter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedRadioButton;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerFeatures;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.ui.ProjectSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class ProfilerSessions {
    private static final int MIN_WAIT_WIDTH = 350;
    private static final int ENABLE_CANCEL_MS = 5000;
    private static volatile boolean waitingCancelled;

    ProfilerSessions() {
    }

    static void configure(final ProfilerSession session, final Lookup context, final String actionName) {
        final ProfilerFeatures _features = session.getFeatures();
        final Set<ProfilerFeature> compatA = ProfilerFeatures.getCompatible(_features.getAvailable(), context);
        if (compatA.isEmpty()) {
            ProfilerDialogs.displayInfo((String)Bundle.ProfilerSessions_actionNotSupported());
        } else {
            UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Set<ProfilerFeature> compatS = ProfilerFeatures.getCompatible(_features.getActivated(), context);
                    ProfilerFeature feature = compatS.size() == 1 ? compatS.iterator().next() : (!compatS.isEmpty() ? ProfilerSessions.selectFeature(compatS, actionName) : (compatA.size() == 1 ? (ProfilerFeature)compatA.iterator().next() : ProfilerSessions.selectFeature(compatA, actionName)));
                    if (feature != null) {
                        _features.activateFeature(feature);
                        feature.configure(context);
                        session.selectFeature(feature);
                        session.open();
                    }
                }
            });
        }
    }

    static void createAndConfigure(final Lookup context, Lookup.Provider project, final String actionName) {
        if (project == null) {
            project = ProjectUtilities.getMainProject();
        }
        final Lookup.Provider _project = project;
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UI ui = UI.createAndConfigure(context, _project);
                HelpCtx helpCtx = new HelpCtx("SelectFeatureDialog.HelpCtx");
                String caption = actionName == null ? Bundle.ProfilerSessions_selectProjectAndFeature() : actionName;
                DialogDescriptor dd = new DialogDescriptor((Object)ui, caption, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
                final ProfilerSession session = ui.selectedSession();
                if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                    final ProfilerFeature feature = ui.selectedFeature();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilerFeatures features = session.getFeatures();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    features.activateFeature(feature);
                                    feature.configure(context);
                                    session.selectFeature(feature);
                                    session.open();
                                }
                            });
                        }
                    });
                } else if (session != null) {
                    session.close();
                }
                dd.setMessage(null);
            }
        });
    }

    private static ProfilerFeature selectFeature(Set<ProfilerFeature> features, String actionName) {
        UI ui = UI.selectFeature(features);
        HelpCtx helpCtx = new HelpCtx("SelectFeatureDialog.HelpCtx");
        String caption = actionName == null ? Bundle.ProfilerSessions_selectFeature() : actionName;
        DialogDescriptor dd = new DialogDescriptor((Object)ui, caption, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        ProfilerFeature ret = dd.getValue() == DialogDescriptor.OK_OPTION ? ui.selectedFeature() : null;
        dd.setMessage(null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean waitForProfiler() {
        final Profiler profiler = Profiler.getDefault();
        if (profiler.getProfilingState() == 1) {
            return true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            waitingCancelled = ProfilerSessions.blockingWaitDialog(profiler, null);
        } else {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitingCancelled = ProfilerSessions.blockingWaitDialog(profiler, lock);
                    }
                });
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return !waitingCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean blockingWaitDialog(Profiler profiler, Object lock) {
        try {
            if (profiler.getProfilingState() == 1) {
                boolean bl = false;
                return bl;
            }
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            panel.setBorder(new EmptyBorder(15, 15, 15, 10));
            panel.add((Component)new JLabel(Bundle.ProfilerSessions_finishingSession()), "North");
            JProgressBar progress = new JProgressBar();
            progress.setIndeterminate(true);
            panel.add((Component)progress, "South");
            Dimension ps = panel.getPreferredSize();
            panel.setPreferredSize(new Dimension(Math.max(ps.width, 350), ps.height));
            final JButton cancel = new JButton(Bundle.ProfilerSessions_cancel());
            cancel.setVisible(false);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.ProfilerSessions_finishSessionCaption(), true, new Object[]{cancel}, null, 0, null, null);
            final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            final JDialog jd = d instanceof JDialog ? (JDialog)d : null;
            ProfilingStateAdapter listener = new ProfilingStateAdapter(){

                public void profilingStateChanged(ProfilingStateEvent e) {
                    if (e.getNewState() == 1) {
                        d.setVisible(false);
                    }
                }
            };
            profiler.addProfilingStateListener((ProfilingStateListener)listener);
            int closeOp = -1;
            if (jd != null) {
                closeOp = jd.getDefaultCloseOperation();
                jd.setDefaultCloseOperation(0);
            }
            final int _closeOp = closeOp;
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (jd != null) {
                        jd.setDefaultCloseOperation(_closeOp);
                    }
                    cancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            d.setVisible(false);
                        }
                    });
                    cancel.setVisible(true);
                    d.pack();
                }
            });
            timer.setRepeats(false);
            timer.start();
            d.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
            d.setVisible(true);
            profiler.removeProfilingStateListener((ProfilingStateListener)listener);
            boolean bl = dd.getValue() != null;
            return bl;
        }
        finally {
            if (lock != null) {
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        }
    }

    public static final class ExitHandler
    implements Runnable {
        @Override
        public void run() {
            ProfilerSession current = ProfilerSession.currentSession();
            if (current != null) {
                current.persistStorage(true);
            }
        }
    }

    public static final class StopAction
    extends AbstractAction {
        private ProfilerSession session;
        private final ProfilingStateListener listener = new SimpleProfilingStateAdapter(){

            protected void update() {
                StopAction.this.updateState();
            }
        };

        public static StopAction getInstance() {
            return Singleton.INSTANCE;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.session != null) {
                this.setEnabled(false);
                final ProfilerSession sessionF = this.session;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!sessionF.doStop()) {
                            StopAction.this.setEnabled(true);
                        }
                    }
                });
            }
        }

        void setSession(ProfilerSession _session) {
            if (this.session != null) {
                this.session.removeListener(this.listener);
            }
            this.session = _session;
            if (this.session != null) {
                this.session.addListener(this.listener);
            }
            this.putValue("ShortDescription", this.session != null && this.session.isAttach() ? Bundle.HINT_DetachAction() : Bundle.HINT_StopAction());
            this.updateState();
        }

        private void updateState() {
            this.setEnabled(this.session != null && this.session.getState() == 4);
        }

        private StopAction() {
            this.putValue("Name", Bundle.LBL_StopAction());
            this.putValue("ShortDescription", Bundle.HINT_StopAction());
            this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Stop"));
            this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Stop"));
            this.updateState();
        }

        private static final class Singleton {
            private static final StopAction INSTANCE = new StopAction();

            private Singleton() {
            }
        }
    }

    private static class UI
    extends JPanel {
        private ProfilerFeature selectedFeature;
        private ProfilerSession selectedSession;
        private JPanel contents;
        private JRadioButton profileProject;
        private JRadioButton attachProject;
        private JLabel selectModeLabel;

        static UI selectFeature(Set<ProfilerFeature> features) {
            return new UI(features);
        }

        static UI createAndConfigure(Lookup context, Lookup.Provider project) {
            return new UI(context, project);
        }

        ProfilerFeature selectedFeature() {
            return this.selectedFeature;
        }

        ProfilerSession selectedSession() {
            if (this.selectedSession != null) {
                this.selectedSession.setAttach(this.attachProject.isSelected());
            }
            return this.selectedSession;
        }

        UI(Set<ProfilerFeature> features) {
            super(new GridBagLayout());
            int y = 0;
            this.selectModeLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.selectModeLabel, (String)Bundle.ProfilerSessions_selectHandlingFeature());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.anchor = 17;
            c.insets = new Insets(10, 10, 10, 10);
            this.add((Component)this.selectModeLabel, c);
            ButtonGroup rbg = new ButtonGroup();
            for (final ProfilerFeature f : features) {
                JExtendedRadioButton rb = new JExtendedRadioButton(f.getName(), f.getIcon()){

                    protected void fireItemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            UI.this.selectedFeature = f;
                        }
                    }
                };
                rbg.add((AbstractButton)rb);
                if (rbg.getSelection() == null) {
                    rb.setSelected(true);
                }
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = y++;
                c.anchor = 17;
                c.insets = new Insets(0, 20, 0, 10);
                this.add((Component)rb, c);
                if (this.selectModeLabel.getLabelFor() != null) continue;
                this.selectModeLabel.setLabelFor((Component)rb);
            }
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(15, 0, 0, 300);
            this.add((Component)UIUtils.createFillerPanel(), c);
        }

        private void repaintContents() {
            this.contents.invalidate();
            this.contents.revalidate();
            this.contents.repaint();
        }

        UI(final Lookup context, final Lookup.Provider project) {
            super(new GridBagLayout());
            int y = 0;
            JLabel l = new JLabel();
            Mnemonics.setLocalizedText((JLabel)l, (String)Bundle.ProfilerSessions_selectProject());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.anchor = 17;
            c.insets = new Insets(10, 10, 10, 10);
            this.add((Component)l, c);
            this.contents = new JPanel(new GridBagLayout());
            ProjectSelector.Populator populator = new ProjectSelector.Populator(){

                @Override
                protected Lookup.Provider initialProject() {
                    return project;
                }
            };
            ProjectSelector selector = new ProjectSelector(populator){

                protected void selectionChanged() {
                    Lookup.Provider project = this.getProject();
                    UI.this.refreshProfileAttach(project);
                    UI.this.refreshFeatures(context, project);
                }
            };
            l.setLabelFor((Component)((Object)selector));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 20, 4, 10);
            this.add((Component)((Object)selector), c);
            ButtonGroup bg = new ButtonGroup();
            this.profileProject = new JRadioButton();
            bg.add(this.profileProject);
            this.profileProject.setSelected(true);
            Mnemonics.setLocalizedText((AbstractButton)this.profileProject, (String)Bundle.ProfilerSessions_profileProject());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.weightx = 0.0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 20, 10, 5);
            this.add((Component)this.profileProject, c);
            this.attachProject = new JRadioButton();
            bg.add(this.attachProject);
            Mnemonics.setLocalizedText((AbstractButton)this.attachProject, (String)Bundle.ProfilerSessions_attachProject());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.weightx = 0.0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 0, 10, 10);
            this.add((Component)this.attachProject, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = y++;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 0, 10, 0);
            this.add((Component)UIUtils.createFillerPanel(), c);
            this.selectModeLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.selectModeLabel, (String)Bundle.ProfilerSessions_selectHandlingFeature());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.anchor = 17;
            c.insets = new Insets(10, 10, 10, 10);
            this.add((Component)this.selectModeLabel, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.contents, c);
            JExtendedRadioButton ref = new JExtendedRadioButton("XXX");
            final int refHeight = ref.getPreferredSize().height;
            JPanel filler = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(300, refHeight * 2);
                }
            };
            filler.setOpaque(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(15, 0, 0, 0);
            this.add((Component)filler, c);
            Lookup.Provider _project = selector.getProject();
            this.refreshProfileAttach(_project);
            this.refreshFeatures(context, _project);
        }

        private void refreshProfileAttach(Lookup.Provider project) {
            boolean fromExternal = !this.profileProject.isEnabled();
            this.profileProject.setEnabled(project != null);
            if (project == null) {
                this.attachProject.setSelected(true);
            } else if (fromExternal) {
                this.profileProject.setSelected(true);
            }
        }

        private void refreshFeatures(final Lookup context, final Lookup.Provider project) {
            this.contents.removeAll();
            JLabel l = new JLabel(Bundle.ProfilerSessions_loadingFeatures(), 0);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(0, 20, 0, 10);
            this.contents.add((Component)l, c);
            this.repaintContents();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (UI.this.selectedSession != null) {
                        UI.this.selectedSession.close();
                    }
                    Lookup projectContext = project == null ? Lookup.EMPTY : Lookups.fixed((Object[])new Object[]{project});
                    UI.this.selectedSession = ProfilerSession.forContext(projectContext);
                    final ProfilerFeatures features = UI.this.selectedSession.getFeatures();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UI.this.contents.removeAll();
                            UI.this.selectModeLabel.setLabelFor(null);
                            int y = 0;
                            ButtonGroup rbg = new ButtonGroup();
                            for (final ProfilerFeature f : features.getAvailable()) {
                                if (!f.supportsConfiguration(context)) continue;
                                JExtendedRadioButton rb = new JExtendedRadioButton(f.getName(), f.getIcon()){

                                    protected void fireItemStateChanged(ItemEvent e) {
                                        if (e.getStateChange() == 1) {
                                            UI.this.selectedFeature = f;
                                        }
                                    }
                                };
                                rbg.add((AbstractButton)rb);
                                if (rbg.getSelection() == null) {
                                    rb.setSelected(true);
                                }
                                GridBagConstraints c = new GridBagConstraints();
                                c.gridx = 0;
                                c.gridy = y++;
                                c.anchor = 17;
                                c.insets = new Insets(0, 20, 0, 10);
                                UI.this.contents.add((Component)rb, c);
                                if (UI.this.selectModeLabel.getLabelFor() != null) continue;
                                UI.this.selectModeLabel.setLabelFor((Component)rb);
                            }
                            UI.this.repaintContents();
                        }
                    });
                }
            });
        }
    }
}

