/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import com.google.inject.Module;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingException;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.project.ui.ProjectGroup;
import org.netbeans.api.project.ui.ProjectGroupChangeEvent;
import org.netbeans.api.project.ui.ProjectGroupChangeListener;
import org.netbeans.modules.maven.embedder.EmbedderConfiguration;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.impl.ExtensionModule;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class EmbedderFactory {
    public static final String PROP_COMMANDLINE_PATH = "commandLineMavenPath";
    static final String PROP_DEFAULT_OPTIONS = "defaultOptions";
    private static final Set<String> forbidden = new HashSet<String>();
    private static final java.util.logging.Logger LOG;
    private static MavenEmbedder project;
    private static final AtomicBoolean projectLoaded;
    private static final Object PROJECT_LOCK;
    private static MavenEmbedder online;
    private static final Object ONLINE_LOCK;
    private static final RequestProcessor RP;
    private static final RequestProcessor.Task warmupTask;
    private static final Properties statics;

    private EmbedderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCachedEmbedders() {
        Object object = PROJECT_LOCK;
        synchronized (object) {
            projectLoaded.set(false);
            project = null;
        }
        object = ONLINE_LOCK;
        synchronized (object) {
            online = null;
        }
        RP.post((Runnable)warmupTask, 100);
    }

    public static File getDefaultMavenHome() {
        return InstalledFileLocator.getDefault().locate("maven", "org.netbeans.modules.maven.embedder", false);
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven");
    }

    private static Preferences getGroupedPreferences(ProjectGroup grp) {
        if (grp != null) {
            return grp.preferencesForPackage(EmbedderFactory.class);
        }
        return null;
    }

    @NonNull
    public static File getMavenHome() {
        String str = EmbedderFactory.getPreferences().get(PROP_COMMANDLINE_PATH, null);
        if (str != null) {
            return FileUtil.normalizeFile((File)new File(str));
        }
        return EmbedderFactory.getDefaultMavenHome();
    }

    @NonNull
    public static File getEffectiveMavenHome() {
        ProjectGroup grp = OpenProjects.getDefault().getActiveProjectGroup();
        return EmbedderFactory.getEffectiveMavenHome(grp);
    }

    @NonNull
    public static File getEffectiveMavenHome(ProjectGroup grp) {
        String str;
        Preferences grPref = EmbedderFactory.getGroupedPreferences(grp);
        String string = str = grPref != null ? grPref.get(PROP_COMMANDLINE_PATH, null) : null;
        if (str == null) {
            str = EmbedderFactory.getPreferences().get(PROP_COMMANDLINE_PATH, null);
        }
        if (str != null) {
            return FileUtil.normalizeFile((File)new File(str));
        }
        return EmbedderFactory.getDefaultMavenHome();
    }

    public static void setMavenHome(File path) {
        File oldValue = EmbedderFactory.getMavenHome();
        File defValue = EmbedderFactory.getDefaultMavenHome();
        if (oldValue.equals(path) || path == null && oldValue.equals(defValue)) {
            return;
        }
        if (path == null || path.equals(defValue)) {
            EmbedderFactory.getPreferences().remove(PROP_COMMANDLINE_PATH);
        } else {
            EmbedderFactory.getPreferences().put(PROP_COMMANDLINE_PATH, FileUtil.normalizeFile((File)path).getAbsolutePath());
        }
        EmbedderFactory.resetCachedEmbedders();
    }

    public static void setGroupedMavenHome(ProjectGroup grp, File path) {
        File oldValue = EmbedderFactory.getEffectiveMavenHome(grp);
        File defValue = EmbedderFactory.getMavenHome();
        if (oldValue.equals(path) || path == null && oldValue.equals(defValue)) {
            return;
        }
        Preferences prefs = grp.preferencesForPackage(EmbedderFactory.class);
        if (path == null || path.equals(defValue)) {
            prefs.remove(PROP_COMMANDLINE_PATH);
        } else {
            prefs.put(PROP_COMMANDLINE_PATH, FileUtil.normalizeFile((File)path).getAbsolutePath());
        }
        EmbedderFactory.resetCachedEmbedders();
    }

    static Map<String, String> getCustomGlobalUserProperties() {
        HashMap<String, String> toRet = new HashMap<String, String>();
        String options = EmbedderFactory.getPreferences().get(PROP_DEFAULT_OPTIONS, "");
        try {
            String[] cmdlines = CommandLineUtils.translateCommandline((String)options);
            if (cmdlines != null) {
                for (String cmd : cmdlines) {
                    int ind;
                    if (cmd == null || !cmd.startsWith("-D") || (ind = (cmd = cmd.substring("-D".length())).indexOf(61)) <= -1) continue;
                    String key = cmd.substring(0, ind);
                    String val = cmd.substring(ind + 1);
                    toRet.put(key, val);
                }
            }
            return toRet;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "cannot parse " + options, ex);
            return Collections.emptyMap();
        }
    }

    private static File getSettingsXml() {
        return new File(EmbedderFactory.getEffectiveMavenHome(), "conf/settings.xml");
    }

    @NonNull
    public static MavenEmbedder createProjectLikeEmbedder() throws PlexusContainerException {
        String mavenCoreRealmId = "plexus.core";
        ContainerConfiguration dpcreq = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", EmbedderFactory.class.getClassLoader())).setName("maven");
        DefaultPlexusContainer pc = new DefaultPlexusContainer(dpcreq, new Module[]{new ExtensionModule()});
        pc.setLoggerManager((LoggerManager)new NbLoggerManager());
        Properties userprops = new Properties();
        userprops.putAll(EmbedderFactory.getCustomGlobalUserProperties());
        EmbedderConfiguration configuration = new EmbedderConfiguration((PlexusContainer)pc, EmbedderFactory.cloneStaticProps(), userprops, true, EmbedderFactory.getSettingsXml());
        try {
            return new MavenEmbedder(configuration);
        }
        catch (ComponentLookupException ex) {
            throw new PlexusContainerException(ex.toString(), (Throwable)ex);
        }
    }

    private static void rethrowThreadDeath(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        Throwable t2 = t.getCause();
        if (t2 != null) {
            EmbedderFactory.rethrowThreadDeath(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties cloneStaticProps() {
        Properties properties = statics;
        synchronized (properties) {
            if (statics.isEmpty()) {
                statics.setProperty("netbeans.execution", "true");
                EmbedderFactory.fillEnvVars(statics);
                statics.putAll((Map<?, ?>)EmbedderFactory.excludeNetBeansProperties(System.getProperties()));
            }
            Properties toRet = new Properties();
            toRet.putAll((Map<?, ?>)statics);
            return toRet;
        }
    }

    static Properties excludeNetBeansProperties(Properties props) {
        Properties toRet = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (forbidden.contains(entry.getKey())) continue;
            toRet.put(entry.getKey(), entry.getValue());
        }
        return toRet;
    }

    public static boolean isProjectEmbedderLoaded() {
        return projectLoaded.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MavenEmbedder getProjectEmbedder() {
        Object object = PROJECT_LOCK;
        synchronized (object) {
            if (project == null) {
                try {
                    project = EmbedderFactory.createProjectLikeEmbedder();
                }
                catch (PlexusContainerException ex) {
                    EmbedderFactory.rethrowThreadDeath(ex);
                    throw new IllegalStateException(ex);
                }
                projectLoaded.set(true);
            }
            return project;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MavenEmbedder getOnlineEmbedder() {
        Object object = ONLINE_LOCK;
        synchronized (object) {
            if (online == null) {
                try {
                    online = EmbedderFactory.createOnlineEmbedder();
                }
                catch (PlexusContainerException ex) {
                    EmbedderFactory.rethrowThreadDeath(ex);
                    throw new IllegalStateException(ex);
                }
            }
            return online;
        }
    }

    @NonNull
    static MavenEmbedder createOnlineEmbedder() throws PlexusContainerException {
        String mavenCoreRealmId = "plexus.core";
        ContainerConfiguration dpcreq = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", EmbedderFactory.class.getClassLoader())).setName("maven");
        DefaultPlexusContainer pc = new DefaultPlexusContainer(dpcreq);
        pc.setLoggerManager((LoggerManager)new NbLoggerManager());
        Properties userprops = new Properties();
        userprops.putAll(EmbedderFactory.getCustomGlobalUserProperties());
        EmbedderConfiguration req = new EmbedderConfiguration((PlexusContainer)pc, EmbedderFactory.cloneStaticProps(), userprops, false, EmbedderFactory.getSettingsXml());
        try {
            return new MavenEmbedder(req);
        }
        catch (ComponentLookupException ex) {
            throw new PlexusContainerException(ex.toString(), (Throwable)ex);
        }
    }

    @Deprecated
    public static ArtifactRepository createRemoteRepository(MavenEmbedder embedder, String url, String id) {
        return embedder.createRemoteRepository(url, id);
    }

    @Deprecated
    public static List<Model> createModelLineage(File pom, MavenEmbedder embedder) throws ModelBuildingException {
        return embedder.createModelLineage(pom);
    }

    public static Properties fillEnvVars(Properties properties) {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (BaseUtilities.isWindows()) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            properties.setProperty("env." + key, entry.getValue());
        }
        return properties;
    }

    static {
        forbidden.add("netbeans.logger.console");
        forbidden.add("java.util.logging.config.class");
        forbidden.add("netbeans.autoupdate.language");
        forbidden.add("netbeans.dirs");
        forbidden.add("netbeans.home");
        forbidden.add("sun.awt.exception.handler");
        forbidden.add("org.openide.TopManager.GUI");
        forbidden.add("org.openide.major.version");
        forbidden.add("netbeans.autoupdate.variant");
        forbidden.add("netbeans.dynamic.classpath");
        forbidden.add("netbeans.autoupdate.country");
        forbidden.add("netbeans.hash.code");
        forbidden.add("org.openide.TopManager");
        forbidden.add("org.openide.version");
        forbidden.add("netbeans.buildnumber");
        forbidden.add("javax.xml.parsers.DocumentBuilderFactory");
        forbidden.add("javax.xml.parsers.SAXParserFactory");
        forbidden.add("rave.build");
        forbidden.add("netbeans.accept_license_class");
        forbidden.add("rave.version");
        forbidden.add("netbeans.autoupdate.version");
        forbidden.add("netbeans.importclass");
        forbidden.add("netbeans.user");
        LOG = java.util.logging.Logger.getLogger(EmbedderFactory.class.getName());
        projectLoaded = new AtomicBoolean(false);
        PROJECT_LOCK = new Object();
        ONLINE_LOCK = new Object();
        RP = new RequestProcessor("Maven Embedder warmup");
        warmupTask = RP.create(new Runnable(){

            @Override
            public void run() {
                EmbedderFactory.getProjectEmbedder();
            }
        });
        RP.post(new Runnable(){

            @Override
            public void run() {
                OpenProjects.getDefault().addProjectGroupChangeListener(new ProjectGroupChangeListener(){

                    public void projectGroupChanging(ProjectGroupChangeEvent event) {
                        EmbedderFactory.resetCachedEmbedders();
                    }

                    public void projectGroupChanged(ProjectGroupChangeEvent event) {
                    }
                });
            }
        });
        statics = new Properties();
    }

    private static class NbLoggerManager
    extends BaseLoggerManager {
        private NbLoggerManager() {
        }

        protected Logger createLogger(String name) {
            int level = this.levelOf(LOG).intValue();
            return new NbLogger(level <= Level.FINEST.intValue() ? 0 : (level <= Level.FINER.intValue() ? 1 : (level <= Level.FINE.intValue() ? 2 : 5)), name);
        }

        private Level levelOf(java.util.logging.Logger log) {
            Level lvl = log.getLevel();
            if (lvl != null) {
                return lvl;
            }
            java.util.logging.Logger par = log.getParent();
            if (par != null) {
                return this.levelOf(par);
            }
            return Level.INFO;
        }

        private static class NbLogger
        extends AbstractLogger {
            NbLogger(int threshold, String name) {
                super(threshold, name);
                LOG.log(Level.FINEST, "created Plexus logger {0} at threshold {1}", new Object[]{name, threshold});
            }

            private java.util.logging.Logger logger() {
                return java.util.logging.Logger.getLogger(LOG.getName() + "." + this.getName());
            }

            public void debug(String m, Throwable t) {
                this.logger().log(Level.FINEST, m, t);
            }

            public void info(String m, Throwable t) {
                this.logger().log(Level.FINER, m, t);
            }

            public void warn(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public void error(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public void fatalError(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public Logger getChildLogger(String name) {
                return new NbLogger(this.getThreshold(), this.getName() + "." + name);
            }
        }
    }
}

