/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.commit;

import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitFileNode;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.commit.CommitAction;
import org.netbeans.modules.git.remote.ui.commit.CommitPanel;
import org.netbeans.modules.git.remote.ui.commit.GitCommitParameters;
import org.netbeans.modules.git.remote.ui.commit.GitCommitTable;
import org.netbeans.modules.git.remote.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.remotefs.versioning.hooks.GitHook;
import org.netbeans.modules.remotefs.versioning.hooks.GitHookContext;
import org.netbeans.modules.remotefs.versioning.hooks.VCSHookContext;
import org.netbeans.modules.remotefs.versioning.hooks.VCSHooks;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitDiffProvider;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitFilter;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitPanel;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitTable;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileNode;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.util.common.VCSCommitParameters;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GitCommitPanel
extends VCSCommitPanel<GitFileNode.GitLocalFileNode> {
    static final GitCommitFilter FILTER_HEAD_VS_WORKING = new GitCommitFilter("HEAD_VS_WORKING", new ImageIcon(GitCommitPanel.class.getResource("/org/netbeans/modules/git/remote/resources/icons/head_vs_working.png")), NbBundle.getMessage(GitCommitPanel.class, (String)"ParametersPanel.tgbHeadVsWorking.toolTipText"), true);
    static final GitCommitFilter FILTER_HEAD_VS_INDEX = new GitCommitFilter("HEAD_VS_INDEX", new ImageIcon(GitCommitPanel.class.getResource("/org/netbeans/modules/git/remote/resources/icons/head_vs_index.png")), NbBundle.getMessage(GitCommitPanel.class, (String)"ParametersPanel.tgbHeadVsIndex.toolTipText"), false);
    private final Collection<GitHook> hooks;
    private final VCSFileProxy[] roots;
    private final VCSFileProxy repository;
    private final boolean fromGitView;
    private final DiffProvider diffProvider;
    GitProgressSupport support;

    private GitCommitPanel(GitCommitTable table, VCSFileProxy[] roots, VCSFileProxy repository, VCSCommitParameters.DefaultCommitParameters parameters, Preferences preferences, Collection<GitHook> hooks, VCSHookContext hooksContext, DiffProvider diffProvider, boolean fromGitView, List<VCSCommitFilter> filters) {
        super((VCSCommitTable)table, (VCSCommitParameters)parameters, preferences, hooks, hooksContext, filters, (VCSCommitDiffProvider)diffProvider);
        this.diffProvider = diffProvider;
        this.roots = roots;
        this.repository = repository;
        this.hooks = hooks;
        this.fromGitView = fromGitView;
        diffProvider.setMode(GitCommitPanel.getAcceptedMode(this.getSelectedFilter()));
    }

    public static GitCommitPanel create(VCSFileProxy[] roots, VCSFileProxy repository, GitUser user, boolean fromGitView) {
        Preferences preferences = GitModuleConfig.getDefault().getPreferences();
        String lastCanceledCommitMessage = GitModuleConfig.getDefault().getLastCanceledCommitMessage();
        GitCommitParameters parameters = new GitCommitParameters(preferences, lastCanceledCommitMessage, user);
        Collection hooks = VCSHooks.getInstance().getHooks(GitHook.class);
        GitHookContext hooksCtx = new GitHookContext(roots, null, new GitHookContext.LogEntry[0]);
        DiffProvider diffProvider = new DiffProvider();
        final GitCommitTable gitCommitTable = new GitCommitTable();
        final CommitPanel panel = parameters.getPanel();
        panel.amendCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                gitCommitTable.setAmend(panel.amendCheckBox.isSelected());
            }
        });
        return new GitCommitPanel(gitCommitTable, roots, repository, parameters, preferences, hooks, (VCSHookContext)hooksCtx, diffProvider, fromGitView, GitCommitPanel.createFilters(fromGitView));
    }

    private static void disableFilters() {
        for (GitCommitFilter f : Arrays.asList(FILTER_HEAD_VS_INDEX, FILTER_HEAD_VS_WORKING)) {
            f.setSelected(false);
        }
    }

    private static List<VCSCommitFilter> createFilters(boolean gitViewStoredMode) {
        assert (EventQueue.isDispatchThread());
        GitCommitPanel.disableFilters();
        FileInformation.Mode mode = gitViewStoredMode ? GitModuleConfig.getDefault().getLastUsedModificationContext() : GitModuleConfig.getDefault().getLastUsedCommitViewMode();
        (FileInformation.Mode.HEAD_VS_INDEX.equals((Object)mode) ? FILTER_HEAD_VS_INDEX : FILTER_HEAD_VS_WORKING).setSelected(true);
        return Arrays.asList(new VCSCommitFilter[]{FILTER_HEAD_VS_INDEX, FILTER_HEAD_VS_WORKING});
    }

    public GitCommitParameters getParameters() {
        return (GitCommitParameters)super.getParameters();
    }

    public Collection<GitHook> getHooks() {
        return this.hooks;
    }

    protected void computeNodes() {
        this.computeNodesIntern();
    }

    public boolean open(VCSContext context, HelpCtx helpCtx, String title) {
        assert (EventQueue.isDispatchThread());
        boolean ok = super.open(context, helpCtx, title);
        GitProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        if (ok && !this.fromGitView) {
            GitModuleConfig.getDefault().setLastUsedCommitViewMode(this.getSelectedFilter() == FILTER_HEAD_VS_INDEX ? FileInformation.Mode.HEAD_VS_INDEX : FileInformation.Mode.HEAD_VS_WORKING_TREE);
        }
        this.diffProvider.componentClosed();
        return ok;
    }

    RequestProcessor.Task computeNodesIntern() {
        final boolean[] refreshFinnished = new boolean[]{false};
        RequestProcessor rp = Git.getInstance().getRequestProcessor(this.repository);
        GitProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        this.support = this.getProgressSupport(refreshFinnished);
        String preparingMessage = NbBundle.getMessage(CommitAction.class, (String)"Progress_Preparing_Commit");
        this.setupProgress(preparingMessage, this.support.getProgressComponent());
        if (this.diffProvider.isOpen()) {
            this.diffProvider.refreshFiles(new GitFileNode[0], GitCommitPanel.getAcceptedMode(this.getSelectedFilter()));
        }
        RequestProcessor.Task task = this.support.start(rp, this.repository, preparingMessage);
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!refreshFinnished[0]) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanel.this.showProgress();
                        }
                    });
                }
            }
        }, 1000L);
        return task;
    }

    protected GitProgressSupport getProgressSupport(boolean[] refreshFinished) {
        return new GitCommitDialogProgressSupport(refreshFinished, this.getSelectedFilter());
    }

    private static EnumSet<FileInformation.Status> getAcceptedStatus(VCSCommitFilter f) {
        if (f == FILTER_HEAD_VS_INDEX) {
            return FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX;
        }
        if (f == FILTER_HEAD_VS_WORKING) {
            return FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING;
        }
        throw new IllegalStateException("wrong filter " + (f != null ? f.getID() : "NULL"));
    }

    private static FileInformation.Mode getAcceptedMode(VCSCommitFilter f) {
        if (f == FILTER_HEAD_VS_INDEX) {
            return FileInformation.Mode.HEAD_VS_INDEX;
        }
        if (f == FILTER_HEAD_VS_WORKING) {
            return FileInformation.Mode.HEAD_VS_WORKING_TREE;
        }
        throw new IllegalStateException("wrong filter " + (f != null ? f.getID() : "NULL"));
    }

    static class GitCommitPanelMerged
    extends GitCommitPanel {
        private final VCSFileProxy repository;
        private final DiffProvider diffProvider;

        static GitCommitPanel create(VCSFileProxy[] roots, VCSFileProxy repository, GitUser user, String mergeCommitMessage) {
            Preferences preferences = GitModuleConfig.getDefault().getPreferences();
            String lastCanceledCommitMessage = GitModuleConfig.getDefault().getLastCanceledCommitMessage();
            GitCommitParameters parameters = new GitCommitParameters(preferences, mergeCommitMessage == null ? lastCanceledCommitMessage : mergeCommitMessage, mergeCommitMessage != null, user);
            Collection hooks = VCSHooks.getInstance().getHooks(GitHook.class);
            GitHookContext hooksCtx = new GitHookContext(roots, null, new GitHookContext.LogEntry[0]);
            DiffProvider diffProvider = new DiffProvider();
            return new GitCommitPanelMerged(new GitCommitTable(false, true), roots, repository, parameters, preferences, hooks, hooksCtx, diffProvider);
        }

        private GitCommitPanelMerged(GitCommitTable gitCommitTable, VCSFileProxy[] roots, VCSFileProxy repository, VCSCommitParameters.DefaultCommitParameters parameters, Preferences preferences, Collection<GitHook> hooks, GitHookContext hooksCtx, DiffProvider diffProvider) {
            super(gitCommitTable, roots, repository, parameters, preferences, hooks, (VCSHookContext)hooksCtx, diffProvider, true, GitCommitPanelMerged.createFilters());
            this.repository = repository;
            this.diffProvider = diffProvider;
        }

        private static List<VCSCommitFilter> createFilters() {
            GitCommitPanel.disableFilters();
            FILTER_HEAD_VS_INDEX.setSelected(true);
            return Collections.singletonList(FILTER_HEAD_VS_INDEX);
        }

        @Override
        protected GitProgressSupport getProgressSupport(boolean[] refreshFinnished) {
            return new MergedCommitDialogProgressSupport(refreshFinnished, this.getSelectedFilter());
        }

        public void setErrorLabel(String htmlErrorLabel) {
            if (htmlErrorLabel == null || htmlErrorLabel.isEmpty()) {
                htmlErrorLabel = NbBundle.getMessage(GitCommitPanel.class, (String)"MSG_CommitPanel.afterMerge");
            }
            super.setErrorLabel(htmlErrorLabel);
        }

        private class MergedCommitDialogProgressSupport
        extends GitProgressSupport {
            private final boolean[] refreshFinished;
            private final VCSCommitFilter filter;

            MergedCommitDialogProgressSupport(boolean[] refreshFinished, VCSCommitFilter filter) {
                this.refreshFinished = refreshFinished;
                this.filter = filter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                VCSFileProxy[] files;
                block11: {
                    FileStatusCache cache;
                    block10: {
                        block9: {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GitCommitPanelMerged.this.getCommitTable().setNodes((VCSFileNode[])new GitFileNode.GitLocalFileNode[0]);
                                }
                            });
                            try {
                                files = this.getClient().listModifiedIndexEntries(new VCSFileProxy[]{GitCommitPanelMerged.this.repository}, this.getProgressMonitor());
                            }
                            catch (GitException ex) {
                                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                                this.refreshFinished[0] = true;
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GitCommitPanelMerged.this.stopProgress();
                                    }
                                });
                                return;
                            }
                            cache = Git.getInstance().getFileStatusCache();
                            if (!this.isCanceled()) break block9;
                            this.refreshFinished[0] = true;
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        cache.refreshAllRoots(Collections.singletonMap(GitCommitPanelMerged.this.repository, Arrays.asList(files)), this.getProgressMonitor());
                        if (!this.isCanceled()) break block10;
                        this.refreshFinished[0] = true;
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    this.refreshFinished[0] = true;
                    files = cache.listFiles(new VCSFileProxy[]{GitCommitPanelMerged.this.repository}, FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX);
                    if (files.length != 0) break block11;
                    this.refreshFinished[0] = true;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    ArrayList<GitFileNode.GitLocalFileNode> nodesList = new ArrayList<GitFileNode.GitLocalFileNode>(files.length);
                    for (VCSFileProxy file : files) {
                        GitFileNode.GitLocalFileNode node = new GitFileNode.GitLocalFileNode(GitCommitPanelMerged.this.repository, file, GitCommitPanel.getAcceptedMode(this.filter));
                        nodesList.add(node);
                    }
                    final GitFileNode.GitLocalFileNode[] nodes = nodesList.toArray(new GitFileNode.GitLocalFileNode[files.length]);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanelMerged.this.getCommitTable().setNodes((VCSFileNode[])nodes);
                            if (GitCommitPanelMerged.this.diffProvider.isOpen()) {
                                GitCommitPanelMerged.this.diffProvider.refreshFiles(nodes, GitCommitPanel.getAcceptedMode(MergedCommitDialogProgressSupport.this.filter));
                            }
                        }
                    });
                    this.refreshFinished[0] = true;
                }
                catch (Throwable throwable) {
                    this.refreshFinished[0] = true;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private static class GitCommitFilter
    extends VCSCommitFilter {
        private final Icon icon;
        private final String tooltip;
        private final String id;

        GitCommitFilter(String id, Icon icon, String tooltip, boolean selected) {
            super(selected);
            this.icon = icon;
            this.tooltip = tooltip;
            this.id = id;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String getID() {
            return this.id;
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
        }
    }

    private static class DiffProvider
    extends VCSCommitDiffProvider<GitFileNode> {
        private MultiDiffPanelController controller;
        private GitFileNode[] files;
        private FileInformation.Mode mode;

        private DiffProvider() {
        }

        public Set<VCSFileProxy> getModifiedFiles() {
            return this.getSaveCookiesPerFile().keySet();
        }

        private Map<VCSFileProxy, SaveCookie> getSaveCookiesPerFile() {
            HashMap<VCSFileProxy, SaveCookie> modifiedFiles = new HashMap<VCSFileProxy, SaveCookie>();
            if (this.controller != null) {
                Map<VCSFileProxy, SaveCookie> cookies = this.controller.getSaveCookies(false);
                modifiedFiles.putAll(cookies);
            }
            return modifiedFiles;
        }

        public JComponent createDiffComponent(VCSFileProxy file) {
            this.componentClosed();
            this.controller = new MultiDiffPanelController(new GitFileNode[0], this.mode);
            return this.controller.getPanel();
        }

        protected JComponent getDiffComponent(GitFileNode[] files) {
            return this.getDiffComponent(files, this.mode);
        }

        private JComponent getDiffComponent(GitFileNode[] files, FileInformation.Mode mode) {
            if (!(this.controller == null || Arrays.equals((Object[])this.files, (Object[])files) && mode == this.mode)) {
                this.beforeFilesChanged();
                this.files = Arrays.copyOf(files, files.length);
                this.controller.changeFiles(files, mode);
            }
            this.setMode(mode);
            if (this.controller == null) {
                this.files = Arrays.copyOf(files, files.length);
                this.controller = new MultiDiffPanelController(files, mode);
            }
            return this.controller.getPanel();
        }

        protected void selectFile(VCSFileProxy file) {
            if (this.controller != null) {
                this.controller.selectFile(file);
            }
        }

        private void setMode(FileInformation.Mode mode) {
            this.mode = mode;
        }

        private void refreshFiles(GitFileNode[] files, FileInformation.Mode mode) {
            this.getDiffComponent(files, mode);
        }

        private void componentClosed() {
            if (this.controller != null) {
                this.controller.componentClosed();
                this.controller = null;
            }
        }

        private void beforeFilesChanged() {
            SaveCookie[] saveCookies;
            if (this.controller != null && (saveCookies = this.getSaveCookies()).length > 0 && SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies)) {
                EditorCookie[] editorCookies;
                for (EditorCookie cookie : editorCookies = this.getEditorCookies()) {
                    cookie.open();
                }
            }
        }

        private boolean isOpen() {
            return this.controller != null;
        }

        protected SaveCookie[] getSaveCookies() {
            return this.getSaveCookiesPerFile().values().toArray(new SaveCookie[0]);
        }

        protected EditorCookie[] getEditorCookies() {
            EditorCookie[] cookies;
            LinkedList<EditorCookie> allCookies = new LinkedList<EditorCookie>();
            if (this.controller != null && (cookies = this.controller.getEditorCookies(true)).length > 0) {
                allCookies.add(cookies[0]);
            }
            return allCookies.toArray(new EditorCookie[allCookies.size()]);
        }
    }

    private class GitCommitDialogProgressSupport
    extends GitProgressSupport {
        private final boolean[] refreshFinished;
        private final VCSCommitFilter filter;

        public GitCommitDialogProgressSupport(boolean[] refreshFinished, VCSCommitFilter filter) {
            this.refreshFinished = refreshFinished;
            this.filter = filter;
        }

        @Override
        public void perform() {
            try {
                this.loadFiles();
                if (RepositoryInfo.getInstance(GitCommitPanel.this.repository).getActiveBranch() != GitBranch.NO_BRANCH_INSTANCE) {
                    this.loadHeadLogMessage();
                }
                this.refreshFinished[0] = true;
            }
            catch (GitException ex) {
                try {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    this.refreshFinished[0] = true;
                }
                catch (Throwable throwable) {
                    this.refreshFinished[0] = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanel.this.stopProgress();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        private void loadHeadLogMessage() throws IllegalArgumentException, GitException {
            GitRevisionInfo gitRevisionInfo = this.getClient().log("HEAD", this.getProgressMonitor());
            final String headCommitMessage = gitRevisionInfo.getFullMessage();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GitCommitPanel.this.getParameters().getPanel().setHeadCommitMessage(headCommitMessage);
                }
            });
        }

        private boolean loadFiles() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GitCommitPanel.this.getCommitTable().setNodes((VCSFileNode[])new GitFileNode.GitLocalFileNode[0]);
                }
            });
            FileStatusCache cache = Git.getInstance().getFileStatusCache();
            cache.refreshAllRoots(Collections.singletonMap(GitCommitPanel.this.repository, Arrays.asList(GitCommitPanel.this.roots)), this.getProgressMonitor());
            this.refreshFinished[0] = true;
            VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])GitCommitPanel.this.roots);
            ArrayList<VCSFileProxy> fileList = new ArrayList<VCSFileProxy>();
            EnumSet acceptedStatus = GitCommitPanel.getAcceptedStatus(this.filter);
            for (int c = 0; c < split.length; ++c) {
                int i;
                VCSFileProxy[] files;
                boolean recursive;
                VCSFileProxy[] splitRoots = split[c];
                boolean bl = recursive = c == 1;
                if (recursive) {
                    files = cache.listFiles(splitRoots, (EnumSet<FileInformation.Status>)acceptedStatus);
                    for (i = 0; i < files.length; ++i) {
                        for (int r = 0; r < splitRoots.length; ++r) {
                            if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)splitRoots[r], (VCSFileProxy)files[i]) || fileList.contains(files[i])) continue;
                            fileList.add(files[i]);
                        }
                    }
                    continue;
                }
                files = GitUtils.flatten(splitRoots, acceptedStatus);
                for (i = 0; i < files.length; ++i) {
                    if (fileList.contains(files[i])) continue;
                    fileList.add(files[i]);
                }
            }
            if (fileList.isEmpty()) {
                return true;
            }
            ArrayList<GitFileNode.GitLocalFileNode> nodesList = new ArrayList<GitFileNode.GitLocalFileNode>(fileList.size());
            for (VCSFileProxy file : fileList) {
                GitFileNode.GitLocalFileNode node = new GitFileNode.GitLocalFileNode(GitCommitPanel.this.repository, file, GitCommitPanel.getAcceptedMode(this.filter));
                nodesList.add(node);
            }
            final GitFileNode.GitLocalFileNode[] nodes = nodesList.toArray(new GitFileNode.GitLocalFileNode[nodesList.size()]);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GitCommitPanel.this.getCommitTable().setNodes((VCSFileNode[])nodes);
                    if (GitCommitPanel.this.diffProvider.isOpen()) {
                        GitCommitPanel.this.diffProvider.refreshFiles(nodes, GitCommitPanel.getAcceptedMode(GitCommitDialogProgressSupport.this.filter));
                    }
                }
            });
            return false;
        }
    }
}

