/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.checkout;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.AbstractMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.git.remote.ui.checkout.AbstractCheckoutAction;
import org.netbeans.modules.git.remote.ui.checkout.AbstractCheckoutRevision;
import org.netbeans.modules.git.remote.ui.checkout.Bundle;
import org.netbeans.modules.git.remote.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.LifecycleManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class SwitchBranchAction
extends AbstractCheckoutAction {
    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.checkoutRevision(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void checkoutRevision(VCSFileProxy repository, String preselectedRevision) {
        this.checkoutRevision(repository, new SwitchBranch(repository, RepositoryInfo.getInstance(repository), preselectedRevision), "LBL_SwitchBranchAction.progressName", new HelpCtx("org.netbeans.modules.git.remote.ui.checkout.SwitchBranchAction"));
    }

    public static class KnownBranchAction
    extends AbstractAction {
        private final VCSContext ctx;
        private final String branchName;

        public KnownBranchAction(String recentBranch, VCSContext ctx) {
            super(Bundle.SwitchBranchAction_KnownBranchAction_name(recentBranch));
            this.branchName = recentBranch;
            this.ctx = ctx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractMap.SimpleImmutableEntry<VCSFileProxy, VCSFileProxy[]> roots = GitUtils.getActionRoots(this.ctx);
            if (roots != null) {
                final VCSFileProxy root = roots.getKey();
                final AtomicBoolean canceled = new AtomicBoolean(false);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        LifecycleManager.getDefault().saveAll();
                        Utils.logVCSActionEvent((String)"Git");
                        if (!canceled.get()) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((SwitchBranchAction)SystemAction.get(SwitchBranchAction.class)).checkoutRevision(root, KnownBranchAction.this.branchName, null, Bundle.SwitchBranchAction_KnownBranchAction_progress(KnownBranchAction.this.branchName));
                                }
                            });
                        }
                    }
                };
                ProgressUtils.runOffEventDispatchThread((Runnable)run, (String)Bundle.MSG_GitAction_savingFiles_progress(), (AtomicBoolean)canceled, (boolean)false);
            }
        }
    }

    private static class SwitchBranch
    extends AbstractCheckoutRevision {
        public SwitchBranch(VCSFileProxy repository, RepositoryInfo info, String initialRevision) {
            super(info, new RevisionDialogController(repository, new VCSFileProxy[]{repository}, info.getBranches(), null));
            this.panel.jLabel1.setText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"SwitchBranch.jLabel1.text"));
        }

        @Override
        protected String getOkButtonLabel() {
            return NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_SwitchBranch.OKButton.text");
        }

        @Override
        protected String getDialogTitle() {
            return NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_SwitchBranch.title");
        }
    }
}

