/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.actions;

import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.openide.util.RequestProcessor;

public interface ActionProgress {
    public RequestProcessor.Task getActionTask();

    public boolean isCanceled();

    public boolean isError();

    public boolean isFinishedSuccess();

    public static final class ActionResult
    implements ActionProgress {
        private final boolean canceled;
        private final boolean error;

        public ActionResult(boolean canceled, boolean error) {
            this.canceled = canceled;
            this.error = error;
        }

        @Override
        public RequestProcessor.Task getActionTask() {
            return null;
        }

        @Override
        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public boolean isError() {
            return this.error;
        }

        @Override
        public boolean isFinishedSuccess() {
            return !this.canceled && !this.error;
        }
    }

    public static final class DefaultActionProgress
    implements ActionProgress {
        private final GitProgressSupport supp;

        public DefaultActionProgress(GitProgressSupport supp) {
            this.supp = supp;
        }

        @Override
        public RequestProcessor.Task getActionTask() {
            return this.supp.getTask();
        }

        @Override
        public boolean isCanceled() {
            return this.supp.isCanceled();
        }

        @Override
        public boolean isError() {
            return this.supp.isError();
        }

        @Override
        public boolean isFinishedSuccess() {
            return this.supp.isFinishedSuccessfully();
        }
    }
}

