/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.freeform;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.freeform.FreeFormProjectsSupport;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Element;

public final class FreeFormProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    private static final String NBJDK_PROPERTIES = "nbproject/nbjdk.properties";
    private static final String NBJDK_ACTIVE = "nbjdk.active";

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        Project project = this.getProject();
        Element e = ProjectUtils.getAuxiliaryConfiguration((Project)project).getConfigurationFragment("data", "http://www.netbeans.org/ns/profiler/1", false);
        if (e != null) {
            String profileTarget = e.getAttribute("profile-target");
            String profileSingleTarget = e.getAttribute("profile-file-target");
            if (profileTarget == null && profileSingleTarget == null) {
                return false;
            }
        } else if (!FreeFormProjectsSupport.saveProfilerConfig(project, null, null)) {
            return false;
        }
        return super.checkProjectCanBeProfiled(profiledClassFile);
    }

    public JavaPlatform resolveProjectJavaPlatform() {
        ProjectAccessor acc = (ProjectAccessor)this.getProject().getLookup().lookup(ProjectAccessor.class);
        EditableProperties ep = acc.getHelper().getProperties(NBJDK_PROPERTIES);
        String platformName = ep.getProperty(NBJDK_ACTIVE);
        return this.getPlatformByName(platformName);
    }

    public boolean isProfilingSupported() {
        boolean supported = super.isProfilingSupported();
        if (!supported) {
            return false;
        }
        String WEB_MODULE_PROVIDER_TYPE = "org.netbeans.modules.web.freeform.WebModules";
        for (Object x : this.getProject().getLookup().lookupAll(Object.class)) {
            if (!"org.netbeans.modules.web.freeform.WebModules".equals(x.getClass().getName())) continue;
            return false;
        }
        return true;
    }

    public FreeFormProjectProfilingSupportProvider(Project project) {
        super(project);
    }
}

