/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.ui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.ExternalDropHandler;
import org.openide.windows.TopComponent;

public class RemoteExternalDropHandler
extends ExternalDropHandler {
    private static final RequestProcessor RP = new RequestProcessor(RemoteExternalDropHandler.class);
    private final DataFlavor daoFlavour = RemoteExternalDropHandler.createDataObjectFlavuor();

    private static DataFlavor createDataObjectFlavuor() {
        DataFlavor flavour;
        try {
            flavour = new DataFlavor("application/x-java-openide-dataobjectdnd;class=org.openide.loaders.DataObject");
        }
        catch (ClassNotFoundException ex) {
            flavour = null;
            RemoteLogger.info(ex);
        }
        return flavour;
    }

    public boolean canDrop(DropTargetDragEvent e) {
        Transferable t;
        if (this.canDrop(e.getCurrentDataFlavors()) && (t = e.getTransferable()) != null) {
            FileObject fo = this.getFileObject(t);
            return fo instanceof RemoteFileObject;
        }
        return false;
    }

    public boolean canDrop(DropTargetDropEvent e) {
        Transferable t;
        if (this.canDrop(e.getCurrentDataFlavors()) && (t = e.getTransferable()) != null) {
            FileObject fo = this.getFileObject(t);
            return fo instanceof RemoteFileObject;
        }
        return false;
    }

    private boolean canDrop(DataFlavor[] flavours) {
        for (DataFlavor f : flavours) {
            if (!f.equals(this.daoFlavour)) continue;
            return true;
        }
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent e) {
        FileObject fo;
        Transferable t = e.getTransferable();
        if (t != null && (fo = this.getFileObject(t)) instanceof RemoteFileObject) {
            String errMsg;
            for (Component c = e.getDropTargetContext().getComponent(); c != null; c = c.getParent()) {
                if (!(c instanceof TopComponent)) continue;
                ((TopComponent)c).requestActive();
                break;
            }
            if ((errMsg = this.openFile(fo)) == null) {
                return true;
            }
            RemoteExternalDropHandler.showWarningMessageFileNotOpened(errMsg);
            return false;
        }
        return false;
    }

    static void showWarningMessageFileNotOpened(Object errMsg) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message(errMsg, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private FileObject getFileObject(Transferable t) {
        if (t.isDataFlavorSupported(this.daoFlavour)) {
            try {
                Object d = t.getTransferData(this.daoFlavour);
                if (d instanceof DataObject) {
                    DataObject dao = (DataObject)d;
                    return dao.getPrimaryFile();
                }
            }
            catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException ex) {
                RemoteLogger.info(ex);
            }
        }
        return null;
    }

    String openFile(final FileObject fo) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() {
                return OpenFile.open((FileObject)fo, (int)-1);
            }
        };
        Future future = RP.submit((Callable)task);
        try {
            return (String)future.get(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            RemoteLogger.info(e);
            return null;
        }
    }
}

